/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.mtplayer.gui.filter.FilterController;
import de.p2tools.mtplayer.gui.filter.helper.PCboString;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ButtonClearFilterFactory;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.P2MenuButton;
import de.p2tools.p2lib.mtfilter.FilterCheckRegEx;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class AboFilterController
extends FilterController {
    private P2MenuButton mbChannel;
    private final ComboBox<String> cboState = new ComboBox();
    private PCboString cboName;
    private PCboString cboSearchText;
    private PCboString cboDescription;
    private final ProgData progData;

    public AboFilterController() {
        VBox vBoxFilter = this.getVBoxFilter();
        this.progData = ProgData.getInstance();
        this.progData.aboFilterController = this;
        this.initFilter();
        this.addCont("Abos f\u00fcr Sender", (Control)this.mbChannel, vBoxFilter);
        this.addCont("Status", this.cboState, vBoxFilter);
        this.addCont("Name", (Control)this.cboName, vBoxFilter);
        this.addCont("Filtertext", (Control)this.cboSearchText, vBoxFilter);
        this.addCont("Beschreibung", (Control)this.cboDescription, vBoxFilter);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        Button btnClear = P2ButtonClearFilterFactory.getPButtonClearFilter();
        hBox.getChildren().add(btnClear);
        Button btnHelpFilter = P2Button.helpButton("Filter", "Die Filter erlauben ein detailliertes Durchsuchen und Filtern der vorhandenen Abos.\n\n-- Men\u00fcs \"Abos f\u00fcr Sender\" und \"Status\" --\nDie Eintr\u00e4ge der Filtermen\u00fcs werden automatisch aus der Aboliste erstellt.\n\n-- Suchen und Filtern --\n\"Name\", \"Beschreibung\" sucht Abos die im \"Namen\" bzw. im der \"Beschreibung\" den Filtertext enthalten.\n\"Filtertext\" sucht Abos die im \"Thema\", \"Thema-Titel\", \"Titel\" oder in \"Irgendwo\" den Filtertext enthalten.\n\n");
        HBox hBoxHelp = new HBox();
        hBoxHelp.setAlignment(Pos.CENTER_RIGHT);
        hBoxHelp.getChildren().add(btnHelpFilter);
        vBoxFilter.getChildren().addAll((Node[])new Node[]{hBox, P2GuiTools.getVBoxGrower(), hBoxHelp});
        btnClear.setOnAction(a -> this.clearFilter());
    }

    private void initFilter() {
        this.mbChannel = new P2MenuButton(ProgConfig.FILTER_ABO_CHANNEL, ThemeListFactory.channelsForAbosList);
        this.cboState.getItems().addAll((String[])new String[]{"", "eingeschaltet", "ausgeschaltet"});
        this.cboState.valueProperty().bindBidirectional(ProgConfig.FILTER_ABO_TYPE);
        this.cboName = new PCboString(this.progData.stringFilterLists.getFilterListAboName(), ProgConfig.FILTER_ABO_NAME);
        FilterCheckRegEx fN = new FilterCheckRegEx(this.cboName.getEditor());
        this.cboName.getEditor().textProperty().addListener((observable2, oldValue, newValue) -> fN.checkPattern());
        this.cboSearchText = new PCboString(this.progData.stringFilterLists.getFilterListAboSearchText(), ProgConfig.FILTER_ABO_SEARCH_TEXT);
        FilterCheckRegEx fS = new FilterCheckRegEx(this.cboSearchText.getEditor());
        this.cboSearchText.getEditor().textProperty().addListener((observable2, oldValue, newValue) -> fS.checkPattern());
        this.cboDescription = new PCboString(this.progData.stringFilterLists.getFilterListAboDescription(), ProgConfig.FILTER_ABO_DESCRIPTION);
        FilterCheckRegEx fD = new FilterCheckRegEx(this.cboDescription.getEditor());
        this.cboDescription.getEditor().textProperty().addListener((observable2, oldValue, newValue) -> fD.checkPattern());
    }

    private void clearFilter() {
        ProgConfig.FILTER_ABO_NAME.set("");
        ProgConfig.FILTER_ABO_SEARCH_TEXT.set("");
        ProgConfig.FILTER_ABO_DESCRIPTION.set("");
        ProgConfig.FILTER_ABO_CHANNEL.setValue("");
        ProgConfig.FILTER_ABO_TYPE.set("");
    }
}

