/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.propose;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.propose.ProposeData;
import de.p2tools.mtplayer.controller.data.propose.ProposeFactory;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneProposeList {
    private final ProgData progData;
    private final Stage stage;
    private final TableView<ProposeData> tableList = new TableView();
    private final FilteredList<ProposeData> filteredList;
    private final SortedList<ProposeData> sortedList;

    public PaneProposeList(ProgData progData, Stage stage) {
        this.progData = progData;
        this.stage = stage;
        this.filteredList = new FilteredList<ProposeData>(progData.proposeList, p -> true);
        this.sortedList = new SortedList<ProposeData>((ObservableList<ProposeData>)this.filteredList);
    }

    public AnchorPane makePane() {
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        this.initTableList(vBox);
        this.initUnderTable(vBox);
        AnchorPane anchorPane = new AnchorPane();
        AnchorPane.setTopAnchor(vBox, 0.0);
        AnchorPane.setRightAnchor(vBox, 0.0);
        AnchorPane.setBottomAnchor(vBox, 0.0);
        AnchorPane.setLeftAnchor(vBox, 0.0);
        anchorPane.getChildren().add(vBox);
        return anchorPane;
    }

    public void close() {
    }

    private void initTableList(VBox vBox) {
        this.tableList.setMinHeight(200.0);
        this.tableList.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableList.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.tableList.setEditable(true);
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setCellValueFactory(new PropertyValueFactory("name"));
        TableColumn countColumn = new TableColumn("Anzahl");
        countColumn.setCellValueFactory(new PropertyValueFactory("count"));
        nameColumn.prefWidthProperty().bind(this.tableList.widthProperty().multiply(0.6));
        countColumn.prefWidthProperty().bind(this.tableList.widthProperty().multiply(0.3));
        this.tableList.getColumns().addAll(nameColumn, countColumn);
        this.tableList.getSelectionModel().selectedItemProperty().addListener((observableValue, dataOld, dataNew) -> this.setTableSel((ProposeData)dataNew));
        this.sortedList.comparatorProperty().bind(this.tableList.comparatorProperty());
        this.tableList.setItems(this.sortedList);
        vBox.getChildren().addAll((Node[])new Node[]{this.tableList});
        VBox.setVgrow(this.tableList, Priority.ALWAYS);
    }

    private void initUnderTable(VBox vBox) {
        Button btnGenerate = new Button("Liste erstellen");
        btnGenerate.setOnAction(a -> ProposeFactory.generateProposeList());
        Label lblCountList = new Label();
        lblCountList.textProperty().bind(this.progData.proposeList.sizeProperty().asString());
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(0.0));
        int row = 0;
        gridPane.add(btnGenerate, 1, row);
        gridPane.add(lblCountList, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        vBox.getChildren().addAll((Node[])new Node[]{gridPane});
    }

    private void setTableSel(ProposeData proposeData) {
        if (proposeData != null) {
            // empty if block
        }
    }
}

