/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.propose;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.cleaningdata.CleaningData;
import de.p2tools.mtplayer.controller.data.cleaningdata.CleaningDataList;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.ptable.P2CellCheckBox;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneCleaningList {
    TableView<CleaningData> tableView = new TableView();
    private final ProgData progData;
    private final Stage stage;
    private CleaningData cleaningData;
    private final TextField txtClean = new TextField();
    private final CheckBox chkExact = new CheckBox();
    public final CleaningDataList cleaningDataList;

    public PaneCleaningList(Stage stage, boolean propose) {
        this.stage = stage;
        this.progData = ProgData.getInstance();
        this.cleaningDataList = propose ? this.progData.cleaningDataListPropose : this.progData.cleaningDataListMedia;
    }

    public void close() {
    }

    public AnchorPane makePane() {
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        this.makePane(vBox);
        AnchorPane anchorPane = new AnchorPane();
        AnchorPane.setTopAnchor(vBox, 0.0);
        AnchorPane.setRightAnchor(vBox, 0.0);
        AnchorPane.setBottomAnchor(vBox, 0.0);
        AnchorPane.setLeftAnchor(vBox, 0.0);
        anchorPane.getChildren().add(vBox);
        return anchorPane;
    }

    private void makePane(VBox vBox) {
        this.initTable(vBox);
        this.addButton(vBox);
        this.addTextField(vBox);
    }

    private void initTable(VBox vBox) {
        this.tableView.setMinHeight(200.0);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        TableColumn removeColumn = new TableColumn("Entfernen");
        removeColumn.setCellValueFactory(new PropertyValueFactory("cleaningString"));
        removeColumn.prefWidthProperty().bind(this.tableView.widthProperty().multiply(0.25));
        TableColumn exactColumn = new TableColumn("Immer");
        exactColumn.setCellValueFactory(new PropertyValueFactory("always"));
        exactColumn.setCellFactory(new P2CellCheckBox<S, T>().cellFactory);
        exactColumn.prefWidthProperty().bind(this.tableView.widthProperty().multiply(0.1));
        TableColumn utfCodeColumn = new TableColumn("UTF-8 Code");
        utfCodeColumn.setCellValueFactory(new PropertyValueFactory("codePoint"));
        utfCodeColumn.prefWidthProperty().bind(this.tableView.widthProperty().multiply(0.4));
        this.tableView.getColumns().addAll(removeColumn, exactColumn, utfCodeColumn);
        this.tableView.setMaxHeight(Double.MAX_VALUE);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> this.setActData());
        SortedList<CleaningData> sortedList = this.cleaningDataList.getSortedList();
        sortedList.comparatorProperty().bind(this.tableView.comparatorProperty());
        this.tableView.setItems(sortedList);
        VBox.setVgrow(this.tableView, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{this.tableView});
    }

    private void addButton(VBox vBox) {
        Button btnDel = new Button("");
        btnDel.setGraphic(ProgIcons.ICON_BUTTON_REMOVE.getImageView());
        btnDel.setOnAction(event -> {
            ObservableList selected = this.tableView.getSelectionModel().getSelectedItems();
            if (selected == null || selected.isEmpty()) {
                P2Alert.showInfoNoSelection();
            } else {
                this.cleaningDataList.removeAll(selected);
                this.tableView.getSelectionModel().clearSelection();
            }
        });
        Button btnNew = new Button("");
        btnNew.setGraphic(ProgIcons.ICON_BUTTON_ADD.getImageView());
        btnNew.setOnAction(event -> {
            CleaningData blackData = new CleaningData();
            this.cleaningDataList.add(blackData);
            this.tableView.getSelectionModel().clearSelection();
            this.tableView.getSelectionModel().select(blackData);
            this.tableView.scrollTo(blackData);
        });
        Button btnClear = new Button("_Alle l\u00f6schen");
        btnClear.setTooltip(new Tooltip("Alle Eintr\u00e4ge in der Liste werden gel\u00f6scht"));
        btnClear.setOnAction(event -> {
            if (this.cleaningDataList.size() > 0 && !P2Alert.showAlertOkCancel(this.stage, "Liste l\u00f6schen", "Sollen alle Tabelleneintr\u00e4ge gel\u00f6scht werden?", "Die Tabelle wird komplett gel\u00f6scht und alle Eintr\u00e4ge gehen verloren.")) {
                return;
            }
            this.cleaningDataList.clear();
        });
        Button btnAddStandards = new Button("_Standards einf\u00fcgen");
        btnAddStandards.setTooltip(new Tooltip("Die Standardeintr\u00e4ge der Liste anf\u00fcgen"));
        btnAddStandards.setOnAction(event -> this.cleaningDataList.initList());
        HBox hBox1 = new HBox(10.0);
        hBox1.setPadding(new Insets(5.0));
        hBox1.getChildren().addAll((Node[])new Node[]{btnNew, btnDel, btnClear, P2GuiTools.getHBoxGrower(), btnAddStandards});
        vBox.getChildren().add(hBox1);
    }

    private void addTextField(VBox vBox) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(0.0));
        int row = 0;
        gridPane.add(new Label("Entfernen:"), 0, row);
        gridPane.add(this.txtClean, 1, row);
        gridPane.add(new Label("Immer:"), 0, ++row);
        gridPane.add(this.chkExact, 1, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        vBox.getChildren().add(gridPane);
    }

    private void setActData() {
        CleaningData blackDataAct = (CleaningData)this.tableView.getSelectionModel().getSelectedItem();
        if (blackDataAct == this.cleaningData) {
            return;
        }
        if (this.cleaningData != null) {
            this.txtClean.textProperty().unbindBidirectional(this.cleaningData.cleaningStringProperty());
            this.txtClean.clear();
            this.chkExact.selectedProperty().unbindBidirectional(this.cleaningData.alwaysProperty());
            this.chkExact.setSelected(false);
        }
        this.cleaningData = blackDataAct;
        if (this.cleaningData != null) {
            this.txtClean.textProperty().bindBidirectional(this.cleaningData.cleaningStringProperty());
            this.chkExact.selectedProperty().bindBidirectional(this.cleaningData.alwaysProperty());
        }
    }
}

