/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.downloaddialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.gui.dialog.downloaddialog.DownloadErrorStreamDialogController;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.log.P2Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class DownloadErrorDialogController
extends P2DialogExtra {
    private final HBox hBoxTitle;
    private final VBox vBoxCont;
    private final Label lblHeader = new Label("Downloadfehler");
    private final Button btnOk = new Button("_Ok");
    private final Button btnErrorStream = new Button("Programmausgabe");
    private final Button btnLogFile = new Button("Log \u00f6ffnen");
    private final CheckBox chkShowNot = new CheckBox("Nicht mehr anzeigen");
    private final CheckBox chkTime = new CheckBox("Automatisch ausblenden");
    private final Label lblFilmTitle = new Label("ARD: Tatort, ..");
    private final TextArea txtUrl = new TextArea();
    private final TextArea txtCont = new TextArea();
    private final Label lblTime = new Label("");
    private final ImageView imageView = new ImageView();
    private final GridPane gridPane = new GridPane();
    private final Timeline timeline = new Timeline();
    private Integer timeSeconds = ProgConfig.SYSTEM_PARAMETER_DOWNLOAD_ERRORMSG_IN_SECOND.getValue();
    private final DownloadData download;

    public DownloadErrorDialogController(DownloadData download) {
        super(ProgData.getInstance().primaryStage, ProgConfig.DOWNLOAD__ERROR_DIALOG_SIZE, "Fehler", false, false);
        this.download = download;
        this.hBoxTitle = this.getHBoxTitle();
        this.vBoxCont = this.getVBoxCont();
        this.init(true);
    }

    @Override
    public void make() {
        this.initCont();
        this.lblFilmTitle.setStyle("-fx-font-weight: bold;");
        this.lblFilmTitle.setText(this.download.getTitle());
        this.txtUrl.setEditable(false);
        this.txtUrl.setWrapText(true);
        String txt = "Url: \n" + this.download.getUrl() + "\nDatei: \n" + this.download.getDestPathFile();
        this.txtUrl.setText(txt);
        this.txtCont.setEditable(false);
        this.txtCont.setWrapText(true);
        this.txtCont.setText("Fehler:\n" + this.download.getDownloadStartDto().getErrorMsg());
        this.btnOk.setOnAction(event -> {
            this.stopCounter();
            this.quit();
        });
        this.btnErrorStream.setOnAction(a -> new DownloadErrorStreamDialogController(this.download.getDownloadStartDto().getErrorStream()));
        this.btnLogFile.setOnAction(a -> P2Logger.openLogFile());
        this.btnErrorStream.setVisible(!this.download.getDownloadStartDto().getErrStreamList().isEmpty());
        this.btnErrorStream.setManaged(this.btnErrorStream.isVisible());
        this.imageView.setImage(ProgIcons.ICON_ATTENTION_64.getImage());
        this.chkTime.setSelected(ProgConfig.DOWNLOAD_DIALOG_ERROR_TIME.get());
        this.chkTime.setOnAction(a -> {
            ProgConfig.DOWNLOAD_DIALOG_ERROR_TIME.setValue(this.chkTime.isSelected());
            if (this.chkTime.isSelected()) {
                this.startCounter();
            } else {
                this.stopCounter();
            }
        });
        this.chkShowNot.setOnAction(a -> ProgConfig.DOWNLOAD_DIALOG_ERROR_SHOW.setValue(!this.chkShowNot.isSelected()));
        this.lblTime.setText("");
        this.lblTime.visibleProperty().bind(ProgConfig.DOWNLOAD_DIALOG_ERROR_TIME);
        this.initCounter();
    }

    private void initCont() {
        this.hBoxTitle.getChildren().add(this.lblHeader);
        this.gridPane.setMaxWidth(Double.MAX_VALUE);
        this.gridPane.setPadding(new Insets(5.0));
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        int row = 0;
        this.gridPane.add(new Label("Film:"), 0, row);
        this.gridPane.add(this.lblFilmTitle, 1, row);
        this.gridPane.add(this.txtUrl, 0, ++row, 2, 1);
        this.gridPane.add(this.txtCont, 0, ++row, 2, 1);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        HBox hBox = new HBox(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.imageView, this.gridPane});
        HBox.setHgrow(this.gridPane, Priority.ALWAYS);
        this.vBoxCont.setPadding(new Insets(5.0));
        this.vBoxCont.getChildren().add(hBox);
        VBox.setVgrow(hBox, Priority.ALWAYS);
        this.addOkButton(this.btnOk);
        Button btnHelp = P2Button.helpButton(this.getStage(), "Download Fehler", "Hier werden die Fehler eines fehlgeschlagenen Downloads angezeigt.\n\n\"Nicht mehr Anzeigen\" meint genau das, bei einem Downloadfehler wird dieser Dialog nicht mehr angezeigt. Die Anzeige kann in den Einstellungen wieder eingeschaltet werden.\n\nIst \"Automatisch ausblenden\" eingeschaltet, wird der Dialog automatisch nach einer gewissen Zeit wieder beendet.\n\n\"Programmausgabe\" zeigt bei Downloads \u00fcber ein Hilfsprogramm dessen Ausgabe an. Der Button wird nur angezeigt, wenn es eine Programmausgabe gibt.\n\nMit \"Log \u00f6ffnen\" wird das Logfile mit dem Standardeditor des Betriebssystem ge\u00f6ffnet.\n");
        this.addHlpButton(btnHelp);
        this.getHboxLeft().getChildren().addAll((Node[])new Node[]{this.btnErrorStream, this.btnLogFile, P2GuiTools.getHBoxGrower()});
        this.getHBoxOverButtons().setAlignment(Pos.CENTER_RIGHT);
        this.getHBoxOverButtons().getChildren().addAll((Node[])new Node[]{this.chkTime, this.lblTime, P2GuiTools.getHBoxGrower(), this.chkShowNot});
    }

    private void initCounter() {
        this.timeline.setCycleCount(-1);
        this.timeline.getKeyFrames().add(new KeyFrame(Duration.seconds(1.0), new CountdownAction(), new KeyValue[0]));
        if (ProgConfig.DOWNLOAD_DIALOG_ERROR_TIME.get()) {
            this.startCounter();
        }
    }

    private void startCounter() {
        this.timeSeconds = ProgConfig.SYSTEM_PARAMETER_DOWNLOAD_ERRORMSG_IN_SECOND.getValue();
        this.timeline.playFromStart();
    }

    private void stopCounter() {
        this.timeline.stop();
    }

    private void quit() {
        this.close();
    }

    private class CountdownAction
    implements EventHandler {
        private CountdownAction() {
        }

        public void handle(Event event) {
            Integer n = DownloadErrorDialogController.this.timeSeconds;
            DownloadErrorDialogController.this.timeSeconds = DownloadErrorDialogController.this.timeSeconds - 1;
            if (DownloadErrorDialogController.this.timeSeconds > 0) {
                DownloadErrorDialogController.this.lblTime.setText("" + DownloadErrorDialogController.this.timeSeconds);
            } else {
                DownloadErrorDialogController.this.stopCounter();
                DownloadErrorDialogController.this.quit();
            }
        }
    }
}

