/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.downloadadd;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.gui.dialog.downloadadd.AddDownloadDto;
import de.p2tools.mtplayer.gui.dialog.downloadadd.InitProgramCall;
import de.p2tools.p2lib.P2LibConst;
import java.util.Arrays;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;

public class InitResolutionButton {
    private final AddDownloadDto addDownloadDto;
    private EventHandler<ActionEvent> onAction;

    public InitResolutionButton(AddDownloadDto addDownloadDto) {
        this.addDownloadDto = addDownloadDto;
        this.init();
    }

    private void init() {
        this.onAction = a -> this.setRes();
        this.addDownloadDto.rbHd.setOnAction(this.onAction);
        this.addDownloadDto.rbHigh.setOnAction(this.onAction);
        this.addDownloadDto.rbSmall.setOnAction(this.onAction);
    }

    public void setRes() {
        if (this.addDownloadDto.rbHd.isSelected()) {
            this.setResolution("hd");
            ProgConfig.DOWNLOAD_DIALOG_HD_HEIGHT_LOW.setValue("hd");
        } else if (this.addDownloadDto.rbHigh.isSelected()) {
            this.setResolution("normal");
            ProgConfig.DOWNLOAD_DIALOG_HD_HEIGHT_LOW.setValue("normal");
        } else {
            this.setResolution("small");
            ProgConfig.DOWNLOAD_DIALOG_HD_HEIGHT_LOW.setValue("small");
        }
        this.addDownloadDto.updateAct();
    }

    private void setResolution(String resolution) {
        if (this.addDownloadDto.chkResolutionAll.isSelected()) {
            Arrays.stream(this.addDownloadDto.addDownloadData).forEach(addDownloadData -> {
                if (resolution.equals("hd") && addDownloadData.download.isHd()) {
                    addDownloadData.download.setResolution("hd");
                } else if (resolution.equals("small") && this.addDownloadDto.getAct().download.isSmall()) {
                    addDownloadData.download.setResolution("small");
                } else {
                    addDownloadData.download.setResolution("normal");
                }
                InitProgramCall.setProgrammCall(this.addDownloadDto, addDownloadData);
            });
        } else {
            this.addDownloadDto.getAct().download.setResolution(resolution);
            InitProgramCall.setProgrammCall(this.addDownloadDto, this.addDownloadDto.getAct());
        }
    }

    public void makeAct() {
        this.addDownloadDto.rbHigh.setOnAction(null);
        this.addDownloadDto.rbHd.setOnAction(null);
        this.addDownloadDto.rbSmall.setOnAction(null);
        this.addDownloadDto.rbHigh.setDisable(this.addDownloadDto.getAct().downloadIsRunning());
        this.addDownloadDto.rbHd.setDisable(this.addDownloadDto.getAct().downloadIsRunning());
        this.addDownloadDto.rbSmall.setDisable(this.addDownloadDto.getAct().downloadIsRunning());
        this.addDownloadDto.rbHd.setDisable(!this.addDownloadDto.getAct().download.isHd());
        this.addDownloadDto.rbSmall.setDisable(!this.addDownloadDto.getAct().download.isSmall());
        switch (this.addDownloadDto.getAct().download.getResolution()) {
            case "hd": {
                this.addDownloadDto.rbHd.setSelected(true);
                break;
            }
            case "small": {
                this.addDownloadDto.rbSmall.setSelected(true);
                break;
            }
            default: {
                this.addDownloadDto.rbHigh.setSelected(true);
            }
        }
        String textHd = "HD";
        if (!this.addDownloadDto.rbHd.isDisable() && !this.addDownloadDto.getAct().download.getFilmSizeHd().isEmpty()) {
            this.addDownloadDto.rbHd.setText(textHd + P2LibConst.LINE_SEPARATOR + "[ " + this.addDownloadDto.getAct().download.getFilmSizeHd() + " MB ]");
        } else {
            this.addDownloadDto.rbHd.setText(textHd);
        }
        String textHeight = "hohe Aufl\u00f6sung";
        if (!this.addDownloadDto.getAct().download.getFilmSizeNormal().isEmpty()) {
            this.addDownloadDto.rbHigh.setText(textHeight + P2LibConst.LINE_SEPARATOR + "[ " + this.addDownloadDto.getAct().download.getFilmSizeNormal() + " MB ]");
        } else {
            this.addDownloadDto.rbHigh.setText(textHeight);
        }
        String textLow = "niedrige Aufl\u00f6sung";
        if (!this.addDownloadDto.rbSmall.isDisable() && !this.addDownloadDto.getAct().download.getFilmSizeSmall().isEmpty()) {
            this.addDownloadDto.rbSmall.setText(textLow + P2LibConst.LINE_SEPARATOR + "[ " + this.addDownloadDto.getAct().download.getFilmSizeSmall() + " MB ]");
        } else {
            this.addDownloadDto.rbSmall.setText(textLow);
        }
        this.addDownloadDto.rbHigh.setOnAction(this.onAction);
        this.addDownloadDto.rbHd.setOnAction(this.onAction);
        this.addDownloadDto.rbSmall.setOnAction(this.onAction);
    }
}

