/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.downloadadd;

import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryMakeParameter;
import de.p2tools.mtplayer.gui.dialog.downloadadd.AddDownloadData;
import de.p2tools.mtplayer.gui.dialog.downloadadd.AddDownloadDto;
import de.p2tools.mtplayer.gui.dialog.downloadadd.DownloadAddDialogFactory;
import de.p2tools.mtplayer.gui.dialog.downloadadd.InitProgramCall;
import de.p2tools.p2lib.mtfilm.tools.FileNameUtils;
import de.p2tools.p2lib.tools.P2InfoFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class InitPathName {
    private final ObservableList<String> pathList;
    private final AddDownloadDto addDownloadDto;

    public InitPathName(AddDownloadDto addDownloadDto) {
        this.addDownloadDto = addDownloadDto;
        this.pathList = FXCollections.observableArrayList();
        this.pathList.addAll((Collection<String>)ProgConfig.DOWNLOAD_DIALOG_DOWNLOAD_PATH);
        this.init();
    }

    private void init() {
        if (this.pathList.isEmpty() || this.pathList.size() == 1 && ((String)this.pathList.get(0)).isEmpty()) {
            this.pathList.clear();
            String path = this.addDownloadDto.getAct().download.getSetData().getDestPath().isEmpty() ? System.getProperty("user.home") : this.addDownloadDto.getAct().download.getSetData().getDestPath();
            this.pathList.add(path);
        }
        Arrays.stream(this.addDownloadDto.addDownloadData).toList().forEach(downloadAddData -> {
            if (downloadAddData.download.getDestPath().isEmpty()) {
                this.setPath((String)this.pathList.get(0), false);
            }
            if (!this.pathList.contains(downloadAddData.download.getDestPath())) {
                this.pathList.add(downloadAddData.download.getDestPath());
            }
        });
        this.addDownloadDto.cboPath.setEditable(true);
        this.addDownloadDto.cboPath.setItems(this.pathList);
        Arrays.stream(this.addDownloadDto.addDownloadData).toList().forEach(downloadAddData -> {
            if (downloadAddData.download.getDestFileName().isEmpty()) {
                if (!downloadAddData.download.getSetData().getDestName().isEmpty()) {
                    this.addDownloadDto.txtName.setText(downloadAddData.download.getSetData().getDestName());
                } else {
                    this.addDownloadDto.txtName.setText(downloadAddData.download.getTitle());
                }
            }
        });
        this.addDownloadDto.cboPath.getEditor().textProperty().addListener((observable2, oldValue, newValue) -> {
            if (!this.addDownloadDto.cboPath.isFocused()) {
                return;
            }
            if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                this.pathChanged();
            }
        });
        this.addDownloadDto.txtName.textProperty().addListener((observable2, oldValue, newValue) -> {
            if (!this.addDownloadDto.txtName.isFocused()) {
                return;
            }
            if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                this.nameChanged();
            }
        });
    }

    private void nameChanged() {
        this.addDownloadDto.getAct().download.setFile(this.addDownloadDto.cboPath.getEditor().getText(), this.addDownloadDto.txtName.getText());
        if (!this.addDownloadDto.txtName.getText().equals(FileNameUtils.checkFileName(this.addDownloadDto.txtName.getText(), false))) {
            this.addDownloadDto.txtName.setStyle(ProgColorList.DOWNLOAD_NAME_ERROR.getCssBackground());
        } else {
            this.addDownloadDto.txtName.setStyle("");
        }
        InitProgramCall.setProgrammCall(this.addDownloadDto, this.addDownloadDto.getAct());
    }

    public void pathChanged() {
        String s = this.addDownloadDto.cboPath.getEditor().getText();
        if (!this.addDownloadDto.cboPath.getItems().contains(s)) {
            this.addDownloadDto.cboPath.getItems().add(s);
        }
        this.setPath(s, this.addDownloadDto.chkPathAll.isSelected());
        DownloadAddDialogFactory.calculateAndCheckDiskSpace(s, this.addDownloadDto.lblFree, this.addDownloadDto.getAct());
    }

    private void setPath(String path, boolean all) {
        if (all) {
            Arrays.stream(this.addDownloadDto.addDownloadData).forEach(downloadAddData -> {
                if (!downloadAddData.download.getDestPath().equals(path)) {
                    downloadAddData.download.setFile(path, downloadAddData.download.getDestFileName());
                    InitProgramCall.setProgrammCall(this.addDownloadDto, downloadAddData);
                }
            });
        } else if (!this.addDownloadDto.getAct().download.getDestPath().equals(path)) {
            this.addDownloadDto.getAct().download.setFile(path, this.addDownloadDto.getAct().download.getDestFileName());
            InitProgramCall.setProgrammCall(this.addDownloadDto, this.addDownloadDto.getAct());
        }
    }

    public void makeAct() {
        this.addDownloadDto.cboPath.setDisable(this.addDownloadDto.getAct().downloadIsRunning());
        this.addDownloadDto.txtName.setDisable(this.addDownloadDto.getAct().downloadIsRunning());
        if (!this.addDownloadDto.cboPath.getItems().contains(this.addDownloadDto.getAct().download.getDestPath())) {
            this.addDownloadDto.cboPath.getItems().add(this.addDownloadDto.getAct().download.getDestPath());
        }
        this.addDownloadDto.cboPath.getSelectionModel().select(this.addDownloadDto.getAct().download.getDestPath());
        this.addDownloadDto.txtName.setText(this.addDownloadDto.getAct().download.getDestFileName());
        DownloadAddDialogFactory.calculateAndCheckDiskSpace(this.addDownloadDto.getAct().download.getDestPath(), this.addDownloadDto.lblFree, this.addDownloadDto.getAct());
    }

    public void clearPath() {
        this.pathList.clear();
        ProgConfig.DOWNLOAD_DIALOG_DOWNLOAD_PATH.clear();
        this.pathChanged();
    }

    public void proposeDestination() {
        String stdPath;
        String actPath = this.addDownloadDto.cboPath.getEditor().getText();
        if (actPath == null) {
            actPath = "";
        }
        if (this.addDownloadDto.getAct().download.getSetData().getDestPath().isEmpty()) {
            stdPath = P2InfoFactory.getStandardDownloadPath();
        } else {
            String path = this.addDownloadDto.getAct().download.getSetData().getDestPath();
            stdPath = DownloadFactoryMakeParameter.replaceTags(this.addDownloadDto.getAct().download, path, true);
        }
        actPath = DownloadAddDialogFactory.getNextName(stdPath, actPath, this.addDownloadDto.getAct().download.getTheme());
        if (!this.addDownloadDto.cboPath.getItems().contains(actPath)) {
            this.addDownloadDto.cboPath.getItems().add(actPath);
        }
        this.addDownloadDto.cboPath.getSelectionModel().select(actPath);
        this.pathChanged();
    }

    public void setUsedPaths() {
        ArrayList<AddDownloadData> list = new ArrayList<AddDownloadData>(Arrays.stream(this.addDownloadDto.addDownloadData).toList());
        Collections.reverse(list);
        list.forEach(downloadAddData -> ProgConfig.DOWNLOAD_DIALOG_DOWNLOAD_PATH.add(0, downloadAddData.download.getDestPath()));
        ArrayList<String> tmpPathList = new ArrayList<String>();
        for (String s : ProgConfig.DOWNLOAD_DIALOG_DOWNLOAD_PATH) {
            if (s.endsWith(File.separator)) {
                s = s.substring(0, s.length() - 1);
            }
            if (!tmpPathList.contains(s)) {
                tmpPathList.add(s);
            }
            if (tmpPathList.size() < 10) continue;
            break;
        }
        ProgConfig.DOWNLOAD_DIALOG_DOWNLOAD_PATH.clear();
        ProgConfig.DOWNLOAD_DIALOG_DOWNLOAD_PATH.addAll(tmpPathList);
    }
}

