/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.downloadadd;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.SizeTools;
import de.p2tools.mtplayer.controller.data.download.DownloadFactory;
import de.p2tools.mtplayer.gui.dialog.downloadadd.AddDownloadData;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import org.apache.commons.lang3.time.FastDateFormat;

public class DownloadAddDialogFactory {
    private DownloadAddDialogFactory() {
    }

    public static String getBlueStr() {
        Color c = DownloadAddDialogFactory.getBlue();
        return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
    }

    public static Color getBlue() {
        if (ProgConfig.SYSTEM_DARK_THEME.getValue().booleanValue()) {
            return Color.rgb(31, 162, 206);
        }
        return Color.BLUE;
    }

    public static Color getBlack() {
        if (ProgConfig.SYSTEM_DARK_THEME.getValue().booleanValue()) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    public static Text getText(String text) {
        Text t = new Text(text);
        t.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        t.setFill(DownloadAddDialogFactory.getBlue());
        return t;
    }

    public static Text getTextBlack(String text) {
        Text t = new Text(text);
        t.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        t.setFill(DownloadAddDialogFactory.getBlack());
        return t;
    }

    public static Text getTextBig(String text) {
        Text t = new Text(text);
        t.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        t.setFill(DownloadAddDialogFactory.getBlue());
        t.setStyle("-fx-font-size: 1.2em;");
        return t;
    }

    public static Text getResText(String text) {
        Text t = new Text(text);
        t.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        return t;
    }

    public static boolean getTime(String name, FastDateFormat format) {
        Date d;
        String ret = "";
        try {
            ret = name.substring(name.lastIndexOf(File.separator) + 1);
            d = new Date(format.parse(ret).getTime());
        }
        catch (Exception ignore) {
            d = null;
        }
        return d != null && format.getPattern().length() == ret.length();
    }

    public static String getNextName(String stdPath, String actDownPath, String theme) {
        String ret = actDownPath;
        theme = DownloadFactory.replaceFileNameWithReplaceList(theme, false);
        if (actDownPath.endsWith(File.separator)) {
            ret = actDownPath.substring(0, actDownPath.length() - File.separator.length());
        }
        try {
            String date = P2DateConst.F_FORMAT_yyyyMMdd.format(new Date());
            boolean isDate = DownloadAddDialogFactory.getTime(ret, P2DateConst.F_FORMAT_yyyyMMdd);
            boolean isTheme = ret.endsWith(theme) && !theme.isEmpty();
            boolean isStandard = actDownPath.equals(stdPath);
            if (isStandard) {
                Path path = Paths.get(stdPath, theme.isEmpty() ? date : theme);
                ret = path.toString();
            } else if (isTheme) {
                Path path = Paths.get(stdPath, date);
                ret = path.toString();
            } else if (isDate) {
                Path path = Paths.get(stdPath, new String[0]);
                ret = path.toString();
            } else {
                Path path = Paths.get(stdPath, new String[0]);
                ret = path.toString();
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(978451203, ex);
            ret = stdPath;
        }
        return ret;
    }

    public static void calculateAndCheckDiskSpace(String path, Label lblFree, AddDownloadData addDownloadData) {
        if (path == null || path.isEmpty()) {
            return;
        }
        try {
            String noSize = "";
            String sizeFree = "";
            long usableSpace = DownloadAddDialogFactory.getFreeDiskSpace(path);
            if (usableSpace > 0L) {
                sizeFree = SizeTools.humanReadableByteCount(usableSpace, true);
            }
            if ((usableSpace /= 1000000L) <= 0L) {
                lblFree.setText("");
            } else {
                int size;
                if (!addDownloadData.download.getFilmSizeHd().isEmpty() && (long)(size = Integer.parseInt(addDownloadData.download.getFilmSizeHd())) > usableSpace) {
                    noSize = ", nicht genug f\u00fcr HD";
                }
                if (!addDownloadData.download.getFilmSizeNormal().isEmpty() && (long)(size = Integer.parseInt(addDownloadData.download.getFilmSizeNormal())) > usableSpace) {
                    noSize = ", nicht genug f\u00fcr \"hoch\"";
                }
                if (!addDownloadData.download.getFilmSizeSmall().isEmpty() && (long)(size = Integer.parseInt(addDownloadData.download.getFilmSizeSmall())) > usableSpace) {
                    noSize = ", nicht genug f\u00fcr \"klein\"";
                }
                if (noSize.isEmpty()) {
                    lblFree.setText(" [ noch frei: " + sizeFree + " ]");
                } else {
                    lblFree.setText(" [ noch frei: " + sizeFree + noSize + " ]");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static long getFreeDiskSpace(String strPath) {
        long usableSpace = 0L;
        if (!strPath.isEmpty()) {
            try {
                Path path = Paths.get(strPath, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    path = path.getParent();
                }
                FileStore fileStore = Files.getFileStore(path);
                usableSpace = fileStore.getUsableSpace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return usableSpace;
    }
}

