/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.downloadadd;

import de.p2tools.mtplayer.controller.ProgSave;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.controller.data.setdata.SetFactory;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.starter.LogMsgFactory;
import de.p2tools.mtplayer.gui.dialog.downloadadd.AddDownloadData;
import de.p2tools.mtplayer.gui.dialog.downloadadd.AddDownloadDto;
import de.p2tools.mtplayer.gui.dialog.downloadadd.DownloadAddDialogGui;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import java.util.ArrayList;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;

public class DownloadAddDialogController
extends P2DialogExtra {
    private final ProgData progData;
    private final Button btnOk = new Button("_Ok");
    private final Button btnCancel = new Button("_Abbrechen");
    private boolean ok = false;
    private boolean setAll = false;
    private final ArrayList filmsToDownloadList;
    private final AddDownloadDto addDownloadDto;

    public DownloadAddDialogController(ProgData progData, ArrayList<FilmDataMTP> filmsToDownloadList, SetData setDataStart, String filterResolution) {
        super(progData.primaryStage, filmsToDownloadList.size() > 1 ? ProgConfig.DOWNLOAD_DIALOG_ADD_MORE_SIZE : ProgConfig.DOWNLOAD_DIALOG_ADD_SIZE, "Download anlegen", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.progData = progData;
        this.filmsToDownloadList = filmsToDownloadList;
        if (setDataStart == null) {
            setDataStart = (SetData)progData.setDataList.getSetDataListSave().get(0);
        }
        this.setAll = true;
        this.addDownloadDto = new AddDownloadDto(progData, setDataStart, filmsToDownloadList, filterResolution);
        this.initAll();
        this.init(true);
    }

    public DownloadAddDialogController(ProgData progData, ArrayList<DownloadData> downloadDataArrayList) {
        super(progData.primaryStage, downloadDataArrayList.size() > 1 ? ProgConfig.DOWNLOAD_DIALOG_ADD_MORE_SIZE : ProgConfig.DOWNLOAD_DIALOG_ADD_SIZE, "Download \u00e4ndern", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.progData = progData;
        this.filmsToDownloadList = downloadDataArrayList;
        this.addDownloadDto = new AddDownloadDto(progData, downloadDataArrayList);
        this.initAll();
        this.init(true);
    }

    @Override
    public void make() {
        this.initGui();
        this.initButton();
        this.addDownloadDto.updateAct();
    }

    @Override
    public void close() {
        if (this.setAll) {
            this.addDownloadDto.chkSetAll.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_SET_ALL);
            this.addDownloadDto.chkResolutionAll.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_RESOLUTION_ALL);
            this.addDownloadDto.chkPathAll.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_PATH_ALL);
            this.addDownloadDto.chkSubTitleAll.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_SUBTITLE_ALL);
            this.addDownloadDto.chkInfoAll.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_INFO_ALL);
            this.addDownloadDto.chkStartTimeAll.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_START_TIME_ALL);
        }
        if (this.addDownloadDto.addNewDownloads) {
            this.addDownloadDto.rbStartNow.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_DIALOG_START_DOWNLOAD_NOW);
            this.addDownloadDto.rbStartNotYet.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_DIALOG_START_DOWNLOAD_NOT);
            this.addDownloadDto.rbStartAtTime.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_DIALOG_START_DOWNLOAD_TIME);
        }
        super.close();
    }

    private void initAll() {
        if (this.setAll) {
            this.addDownloadDto.chkSetAll.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_SET_ALL);
            this.addDownloadDto.chkResolutionAll.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_RESOLUTION_ALL);
            this.addDownloadDto.chkPathAll.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_PATH_ALL);
            this.addDownloadDto.chkSubTitleAll.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_SUBTITLE_ALL);
            this.addDownloadDto.chkInfoAll.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_INFO_ALL);
            this.addDownloadDto.chkStartTimeAll.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ADD_START_TIME_ALL);
        } else {
            this.addDownloadDto.chkStartTimeAll.setSelected(true);
        }
        if (this.progData.setDataList.getSetDataListSave().size() <= 1) {
            this.addDownloadDto.chkSetAll.setSelected(false);
        }
    }

    private void initGui() {
        if (this.progData.setDataList.getSetDataListSave().isEmpty() || this.filmsToDownloadList.isEmpty()) {
            this.ok = false;
            this.quit();
            return;
        }
        DownloadAddDialogGui downloadAddDialogGui = new DownloadAddDialogGui(this.progData, this.addDownloadDto, this.getVBoxCont());
        downloadAddDialogGui.addCont();
        downloadAddDialogGui.init();
        this.addOkCancelButtons(this.btnOk, this.btnCancel);
    }

    private void initButton() {
        this.addDownloadDto.btnDest.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        this.addDownloadDto.btnDest.setTooltip(new Tooltip("Einen Pfad zum Speichern ausw\u00e4hlen."));
        this.addDownloadDto.btnDest.setOnAction(event -> {
            P2DirFileChooser.DirChooser(ProgData.getInstance().primaryStage, this.addDownloadDto.cboPath);
            this.addDownloadDto.initPathName.pathChanged();
        });
        this.addDownloadDto.btnPropose.setGraphic(ProgIcons.ICON_BUTTON_RESET.getImageView());
        this.addDownloadDto.btnPropose.setTooltip(new Tooltip("Einen Pfad zum Speichern vorschlagen lassen."));
        this.addDownloadDto.btnPropose.setOnAction(event -> this.addDownloadDto.initPathName.proposeDestination());
        this.addDownloadDto.btnClean.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        this.addDownloadDto.btnClean.setTooltip(new Tooltip("Die Liste der Pfade l\u00f6schen"));
        this.addDownloadDto.btnClean.setOnAction(a -> this.addDownloadDto.initPathName.clearPath());
        this.addDownloadDto.btnPrev.setOnAction(event -> {
            this.addDownloadDto.actFilmIsShown.setValue(this.addDownloadDto.actFilmIsShown.getValue() - 1);
            this.addDownloadDto.updateAct();
        });
        this.addDownloadDto.btnNext.setOnAction(event -> {
            this.addDownloadDto.actFilmIsShown.setValue(this.addDownloadDto.actFilmIsShown.getValue() + 1);
            this.addDownloadDto.updateAct();
        });
        this.btnOk.setOnAction(event -> {
            if (this.check()) {
                this.quit();
            }
        });
        this.btnCancel.setOnAction(event -> {
            this.ok = false;
            this.quit();
        });
    }

    private boolean check() {
        this.ok = false;
        for (AddDownloadData d : this.addDownloadDto.addDownloadData) {
            if (d.download == null) {
                P2Alert.showErrorAlert("Fehlerhafter Download!", "Fehlerhafter Download!", "Download konnte nicht erstellt werden.");
                continue;
            }
            if (d.download.getDestPath().isEmpty() || d.download.getDestFileName().isEmpty()) {
                P2Alert.showErrorAlert("Fehlerhafter Pfad/Name!", "Fehlerhafter Pfad/Name!", "Pfad oder Name ist leer.");
                continue;
            }
            if (SetFactory.checkPathWritable(d.download.getDestPath())) {
                this.ok = true;
                continue;
            }
            P2Alert.showErrorAlert("Fehlerhafter Pfad/Name!", "Fehlerhafter Pfad/Name!", "Pfad ist nicht beschreibbar.");
        }
        return this.ok;
    }

    private void quit() {
        this.addDownloadDto.initPathName.setUsedPaths();
        this.progData.mtPlayerController.setFocus();
        if (!this.ok) {
            this.close();
            return;
        }
        if (this.addDownloadDto.addNewDownloads) {
            this.addNewDownloads();
        } else {
            this.changeDownloads();
        }
        ProgSave.saveAll();
        this.progData.downloadGuiController.tableRefresh();
        this.close();
    }

    private void addNewDownloads() {
        ArrayList<DownloadData> list = new ArrayList<DownloadData>();
        ArrayList<DownloadData> listStarts = new ArrayList<DownloadData>();
        for (AddDownloadData addDownloadData : this.addDownloadDto.addDownloadData) {
            if (!addDownloadData.download.getStartTime().isEmpty() || addDownloadData.startNow) {
                listStarts.add(addDownloadData.download);
                LogMsgFactory.addNewDownloadMsg(addDownloadData.download, true, false);
            } else {
                LogMsgFactory.addNewDownloadMsg(addDownloadData.download, false, false);
            }
            list.add(addDownloadData.download);
        }
        this.progData.downloadList.addWithNo(list);
        this.progData.downloadList.startDownloads(listStarts, false);
    }

    private void changeDownloads() {
        ArrayList<DownloadData> list = new ArrayList<DownloadData>();
        for (AddDownloadData addDownloadData : this.addDownloadDto.addDownloadData) {
            if (addDownloadData.downloadIsRunning()) continue;
            addDownloadData.download.resetDownload();
            addDownloadData.downloadOrg.copyToMe(addDownloadData.download);
            if (!addDownloadData.download.getStartTime().isEmpty() || addDownloadData.startNow) {
                list.add(addDownloadData.downloadOrg);
                LogMsgFactory.addNewDownloadMsg(addDownloadData.downloadOrg, true, true);
                continue;
            }
            LogMsgFactory.addNewDownloadMsg(addDownloadData.downloadOrg, false, true);
        }
        this.progData.downloadList.startDownloads(list, false);
    }
}

