/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.abodialog;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.gui.dialog.abodialog.AboAddAllFactory;
import de.p2tools.mtplayer.gui.dialog.abodialog.AddAboDto;
import de.p2tools.mtplayer.gui.dialog.downloadadd.DownloadAddDialogFactory;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class AboAddDialogGuiPath
extends VBox {
    private final AddAboDto addAboDto;
    private final ProgData progData;
    private final Stage stage;

    public AboAddDialogGuiPath(ProgData progData, Stage stage, AddAboDto addAboDto) {
        this.progData = progData;
        this.stage = stage;
        this.addAboDto = addAboDto;
        this.addCont();
        this.init();
    }

    private void addCont() {
        this.addContSet();
        this.addContPath();
        this.addContFileName();
        this.addResFileName();
        Button btnHelp = P2Button.helpButton(this.stage, "Abo-Pfad anlegen", "Downloads aus Abos k\u00f6nnen im Pfad der im Set vorgegeben ist, in einem Unterordner davon oder in einem eigenen Pfad der im Abo vorgegeben wird, gespeichert werden. Der Dateiname kann der vorgegebene des Sets sein oder auch ein eigener f\u00fcr das Abo.\n\n** Pfad - Einstellungen aus dem Set verwenden **\nIst im Set \"Bei Abos Unterordner anlegen\" eingeschaltet, wird der Film auf jeden Fall in einem Unterordner des Speicherordners des Sets gespeichert. Im Set kann auch ausgew\u00e4hlt werden, wie der Unterordner hei\u00dfen soll. Wird im Abo \"Unterordner\" angeklickt, kann man einen Abo-eignen Namen daf\u00fcr angeben. Es wird dann auf jeden Fall ein Unterordner verwendet, auch wenn er im Set nicht eingeschaltet ist.\n\n** Pfad - Eigene Einstellungen verwenden **\nHier kann man f\u00fcr die Downloads einen eigenen Pfad vorgeben. Downloads dieses Abo landen dann in dem Ordner.\n\n** Dateiname - Einstellungen aus dem Set verwenden **\nDas macht genau das, was es sagt, der Dateiname wird nach den Set-Vorgaben erstellt.\n\n** Dateiname - Eigene Einstellungen verwenden **\nHier kann ein eigener Dateiname f\u00fcr Downloads dieses Abos vorgegeben werden.\n\n** Ergebnis **\nHier wird exemplarisch angezeigt, wie Pfad und Dateiname aussehen k\u00f6nnen.\n\n==========================\nDiese Parameter sind m\u00f6glich:\n\n%D Sendedatum des Films, wenn leer von 'heute'\n%d Sendezeit des Films, wenn leer von 'jetzt'\n%H 'heute', aktuelles Datum im Format JJJJMMTT, z.B. '20090815' am 15.08.2009\n%h 'jetzt', aktuelle Uhrzeit im Format HHMMss, z.B. '152059' um 15:20:59 Uhr\n\n%1 Tag, vom Sendedatum des Films, wenn leer von 'heute'\n%2 Monat, ebenso\n%3 Jahr, ebenso\n\n%4 Stunde, von der Sendezeit des Films, wenn leer von 'jetzt'\n%5 Minute, ebenso\n%6 Sekunde, ebenso\n\n%s Sender des Films\n%T Titel des Films\n%t Thema des Films\n\n%N Originaldateiname des Films (der kann sehr kryptisch und lang sein)\n%S Suffix des Originaldateinamens des Films (z.B. 'mp4')\n\n%i Filmnummer (\u00e4ndert sich beim Neuladen der Filmliste!)\n%q Qualit\u00e4t des Films ('HD', 'H', 'L')\n\n%Z Hashwert der URL, z.B.: '1433245578'\n%z Hashwert der URL, angeh\u00e4ngtes Suffix (entspricht '%Z.%S'), z.B.: '1433245578.mp4'\n\n\nIm Set kann eine maximale L\u00e4nge eines \"Elements\". z.B. %T und die maximale L\u00e4nge des gesamten Namens vorgegeben werden. Ist ein \"Element\" oder der gesamte Name l\u00e4nger, wird gek\u00fcrzt.\n\nBeispiele:\nAm 10.05.2021 liefert '%H__%t__%T' z.B. '20210510__Natur__Wildes Shetland' (kein Suffix)\nund '%H__%t__%T.%S' liefert z.B. '20210510__Natur__Wildes Shetland.xxx' (mit dem Originalsuffix)\n");
        HBox hBoxHelp = new HBox();
        hBoxHelp.setPadding(new Insets(10.0));
        hBoxHelp.setAlignment(Pos.CENTER_RIGHT);
        hBoxHelp.getChildren().add(btnHelp);
        this.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVBoxGrower(), hBoxHelp});
    }

    private void addContSet() {
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setMinWidth(Double.NEGATIVE_INFINITY);
        grid.setMaxWidth(Double.MAX_VALUE);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSizeCenter()});
        this.getChildren().add(grid);
        int row = 0;
        grid.add(this.addAboDto.textSet, 0, row);
        this.addAboDto.cboSetData.setMaxWidth(Double.MAX_VALUE);
        grid.add(this.addAboDto.cboSetData, 1, row);
        grid.add(this.addAboDto.chkSetAll, 2, row);
    }

    private void addContPath() {
        Text txtPath = DownloadAddDialogFactory.getText("Pfad:");
        txtPath.setUnderline(true);
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(20.0, 10.0, 10.0, 10.0));
        hBox.getChildren().add(txtPath);
        this.getChildren().add(hBox);
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setMinWidth(Double.NEGATIVE_INFINITY);
        grid.setMaxWidth(Double.MAX_VALUE);
        grid.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        grid.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSizeCenter()});
        this.getChildren().add(grid);
        int row = 0;
        this.addAboDto.cboAboSubDir.setMaxWidth(Double.MAX_VALUE);
        this.addAboDto.cboAboSubDir.setEditable(true);
        StackPane sp = new StackPane();
        sp.setAlignment(Pos.CENTER_LEFT);
        sp.getChildren().addAll((Node[])new Node[]{this.addAboDto.lblSetSubDir, this.addAboDto.cboAboSubDir});
        sp.setPrefWidth(20.0);
        sp.disableProperty().bind(this.addAboDto.rbSetPath.selectedProperty().not());
        HBox hBoxChk = new HBox(10.0);
        hBoxChk.disableProperty().bind(this.addAboDto.rbSetPath.selectedProperty().not());
        hBoxChk.setAlignment(Pos.CENTER_LEFT);
        hBoxChk.getChildren().addAll((Node[])new Node[]{this.addAboDto.chkAboSubDir, DownloadAddDialogFactory.getTextBlack("Unterordner:")});
        HBox.setHgrow(sp, Priority.ALWAYS);
        HBox hBoxSet = new HBox(10.0);
        hBoxSet.disableProperty().bind(this.addAboDto.rbSetPath.selectedProperty().not());
        hBoxSet.setAlignment(Pos.CENTER_LEFT);
        hBoxSet.getChildren().addAll((Node[])new Node[]{sp});
        HBox.setHgrow(sp, Priority.ALWAYS);
        grid.add(this.addAboDto.rbSetPath, 0, row, 3, 1);
        grid.add(this.addAboDto.chkDestAboDirAll, 4, row);
        RadioButton rb = new RadioButton();
        rb.setVisible(false);
        grid.add(rb, 0, ++row);
        grid.add(hBoxChk, 1, row);
        grid.add(sp, 2, row, 2, 1);
        Button btnPath = new Button();
        btnPath.setTooltip(new Tooltip("Einen Pfad zum Speichern ausw\u00e4hlen."));
        btnPath.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnPath.setOnAction(event -> {
            P2DirFileChooser.DirChooser(this.stage, this.addAboDto.cboAboDir);
            this.addAboDto.initDestination.setPathToAbo();
        });
        btnPath.disableProperty().bind(this.addAboDto.rbOwnPath.selectedProperty().not());
        grid.add(this.addAboDto.rbOwnPath, 0, ++row, 3, 1);
        grid.add(DownloadAddDialogFactory.getTextBlack("Zielpfad:"), 1, ++row);
        grid.add(this.addAboDto.cboAboDir, 2, row);
        grid.add(btnPath, 3, row);
        this.addAboDto.cboAboDir.setMaxWidth(Double.MAX_VALUE);
        this.addAboDto.cboAboDir.setEditable(true);
        this.addAboDto.cboAboDir.disableProperty().bind(this.addAboDto.rbOwnPath.selectedProperty().not());
        GridPane.setHgrow(this.addAboDto.cboAboDir, Priority.ALWAYS);
    }

    private void addContFileName() {
        Text txtFileName = DownloadAddDialogFactory.getText("Dateiname:");
        txtFileName.setUnderline(true);
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(30.0, 10.0, 10.0, 10.0));
        hBox.getChildren().add(txtFileName);
        this.getChildren().add(hBox);
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setMinWidth(Double.NEGATIVE_INFINITY);
        grid.setMaxWidth(Double.MAX_VALUE);
        grid.setPadding(new Insets(0.0, 10.0, 10.0, 25.0));
        grid.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSizeCenter()});
        this.getChildren().add(grid);
        this.addAboDto.cboAboFileName.disableProperty().bind(this.addAboDto.rbOwnFileName.selectedProperty().not());
        int row = 0;
        grid.add(this.addAboDto.rbSetFileName, 0, row, 3, 1);
        RadioButton rb = new RadioButton();
        rb.setVisible(false);
        grid.add(rb, 0, ++row);
        grid.add(DownloadAddDialogFactory.getTextBlack("Dateiname:"), 1, row);
        grid.add(this.addAboDto.lblSetFileName, 2, row);
        grid.add(this.addAboDto.chkDestAboFileNameAll, 3, row);
        ++row;
        grid.add(this.addAboDto.rbOwnFileName, 0, ++row, 3, 1);
        rb = new RadioButton();
        rb.setVisible(false);
        grid.add(rb, 0, ++row);
        grid.add(DownloadAddDialogFactory.getTextBlack("Dateiname:"), 1, row);
        grid.add(this.addAboDto.cboAboFileName, 2, row);
        this.addAboDto.cboAboFileName.setMaxWidth(Double.MAX_VALUE);
        this.addAboDto.cboAboFileName.setEditable(true);
        GridPane.setHgrow(this.addAboDto.cboAboFileName, Priority.ALWAYS);
    }

    private void addResFileName() {
        Text txtFileName = DownloadAddDialogFactory.getTextBig("Ergebnis:");
        txtFileName.setUnderline(true);
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(30.0, 10.0, 10.0, 10.0));
        hBox.getChildren().add(txtFileName);
        this.getChildren().add(hBox);
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setMinWidth(Double.NEGATIVE_INFINITY);
        grid.setMaxWidth(Double.MAX_VALUE);
        grid.setPadding(new Insets(0.0, 10.0, 10.0, 10.0));
        grid.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        this.getChildren().add(grid);
        Text txtPath = DownloadAddDialogFactory.getTextBlack("Pfad:");
        Text txtName = DownloadAddDialogFactory.getTextBlack("Dateiname:");
        int row = 0;
        RadioButton rb = new RadioButton();
        rb.setVisible(false);
        grid.add(rb, 0, row);
        grid.add(txtPath, 1, row);
        grid.add(this.addAboDto.lblResPath, 2, row);
        grid.add(txtName, 1, ++row);
        grid.add(this.addAboDto.lblResFileName, 2, row);
    }

    private void init() {
        AboAddAllFactory.init(this.addAboDto);
    }
}

