/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.abodialog;

import de.p2tools.mtplayer.controller.ProgSave;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.abo.AboDataProps;
import de.p2tools.mtplayer.controller.data.abo.AboFactory;
import de.p2tools.mtplayer.controller.data.abo.AboSearchDownloadsFactory;
import de.p2tools.mtplayer.controller.filmfilter.FilmFilter;
import de.p2tools.mtplayer.controller.worker.Busy;
import de.p2tools.mtplayer.gui.dialog.NoSetDialogController;
import de.p2tools.mtplayer.gui.dialog.abodialog.AboAddDialogGuiAbo;
import de.p2tools.mtplayer.gui.dialog.abodialog.AboAddDialogGuiPath;
import de.p2tools.mtplayer.gui.dialog.abodialog.AboAddDialogGuiSearch;
import de.p2tools.mtplayer.gui.dialog.abodialog.AddAboData;
import de.p2tools.mtplayer.gui.dialog.abodialog.AddAboDto;
import de.p2tools.mtplayer.gui.dialog.downloadadd.DownloadAddDialogFactory;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2GuiTools;
import java.util.List;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class AboAddDialogController
extends P2DialogExtra {
    private final Button btnOk = new Button("_Ok");
    private final Button btnApply = new Button("_Anwenden");
    private final Button btnCancel = new Button("_Abbrechen");
    private final ProgData progData;
    private final AddAboDto addAboDto;

    public AboAddDialogController(ProgData progData, AboData abo) {
        super(progData.primaryStage, ProgConfig.ABO_DIALOG_EDIT_SIZE, "Abo anlegen", false, false, P2DialogExtra.DECO.NO_BORDER, true);
        this.progData = progData;
        this.addAboDto = new AddAboDto(progData, true, abo);
        this.init(true);
    }

    public AboAddDialogController(ProgData progData, List<AboData> aboList) {
        super(progData.primaryStage, ProgConfig.ABO_DIALOG_EDIT_SIZE, "Abo \u00e4ndern", false, false, P2DialogExtra.DECO.NO_BORDER, true);
        this.progData = progData;
        this.addAboDto = new AddAboDto(progData, false, aboList);
        this.init(true);
    }

    public AboAddDialogController(ProgData progData, FilmFilter filmFilter, AboData abo) {
        super(progData.primaryStage, ProgConfig.ABO_DIALOG_EDIT_SIZE, "Abo anlegen", false, false, P2DialogExtra.DECO.NO_BORDER, true);
        this.progData = progData;
        this.addAboDto = new AddAboDto(progData, false, abo);
        String channel = filmFilter.isChannelVis() ? filmFilter.getChannel() : "";
        String theme = filmFilter.isThemeVis() ? filmFilter.getResTheme() : "";
        boolean themeExact = filmFilter.isThemeIsExact();
        String title = filmFilter.isTitleVis() ? filmFilter.getTitle() : "";
        String themeTitle = filmFilter.isThemeTitleVis() ? filmFilter.getThemeTitle() : "";
        String somewhere = filmFilter.isSomewhereVis() ? filmFilter.getSomewhere() : "";
        int timeRange = filmFilter.isTimeRangeVis() ? filmFilter.getTimeRange() : 0;
        int minDuration = filmFilter.isMinMaxDurVis() ? filmFilter.getMinDur() : 0;
        int maxDuration = filmFilter.isMinMaxDurVis() ? filmFilter.getMaxDur() : 150;
        this.addAboDto.getAct().abo.setChannel(channel);
        this.addAboDto.getAct().abo.setTheme(theme);
        this.addAboDto.getAct().abo.setThemeExact(themeExact);
        this.addAboDto.getAct().abo.setTitle(title);
        this.addAboDto.getAct().abo.setThemeTitle(themeTitle);
        this.addAboDto.getAct().abo.setSomewhere(somewhere);
        this.addAboDto.getAct().abo.setTimeRange(timeRange);
        this.addAboDto.getAct().abo.setMinDurationMinute(minDuration);
        this.addAboDto.getAct().abo.setMaxDurationMinute(maxDuration);
        this.init(true);
    }

    @Override
    public void close() {
        this.btnOk.disableProperty().unbind();
        this.btnApply.disableProperty().unbind();
        super.close();
    }

    @Override
    public void make() {
        if (this.progData.setDataList.getSetDataListAbo().isEmpty()) {
            Platform.runLater(() -> {
                super.close();
                new NoSetDialogController(ProgData.getInstance(), NoSetDialogController.TEXT.ABO);
            });
            return;
        }
        if (this.addAboDto.aboList.isEmpty()) {
            Platform.runLater(() -> super.close());
            return;
        }
        this.initGui();
        this.initButton();
        this.addAboDto.updateAct();
    }

    private void initGui() {
        boolean size = this.addAboDto.addAboData.length > 1;
        VBox vBoxCont = this.getVBoxCont();
        if (size) {
            HBox hBoxTop = new HBox();
            hBoxTop.getStyleClass().add("downloadDialog");
            hBoxTop.setSpacing(20.0);
            hBoxTop.setAlignment(Pos.CENTER);
            hBoxTop.setPadding(new Insets(5.0));
            hBoxTop.getChildren().addAll((Node[])new Node[]{this.addAboDto.btnPrev, this.addAboDto.lblSum, this.addAboDto.btnNext});
            vBoxCont.getChildren().add(hBoxTop);
        }
        Font font = Font.font(null, FontWeight.BOLD, -1.0);
        this.addAboDto.btnAll.setFont(font);
        this.addAboDto.btnAll.setWrapText(true);
        this.addAboDto.btnAll.setMinHeight(Double.NEGATIVE_INFINITY);
        HBox hBoxBtn = new HBox(10.0);
        hBoxBtn.setAlignment(Pos.CENTER_RIGHT);
        hBoxBtn.getChildren().addAll((Node[])new Node[]{DownloadAddDialogFactory.getText("Nr:"), this.addAboDto.lblAboNo, P2GuiTools.getHDistance(20), DownloadAddDialogFactory.getText("Treffer:"), this.addAboDto.lblHit, P2GuiTools.getHBoxGrower(), this.addAboDto.btnAll});
        vBoxCont.getChildren().add(hBoxBtn);
        vBoxCont.getChildren().add(this.getTabPane());
        vBoxCont.getChildren().add(ProgData.busy.getBusyHbox(Busy.BUSY_SRC.ABO_DIALOG));
        HBox hBox = new HBox(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{DownloadAddDialogFactory.getText("Letztes Abo:"), this.addAboDto.lblLastAbo, P2GuiTools.getHBoxGrower(), DownloadAddDialogFactory.getText("Angelegt:"), this.addAboDto.lblGenDate});
        vBoxCont.getChildren().add(hBox);
        this.addOkCancelApplyButtons(this.btnOk, this.btnCancel, this.btnApply);
        this.addHlpButton(P2Button.helpButton(this.getStage(), "Abo", "Ein Abo findet einen Download, wenn die Filtereinstellungen zum Film passen. Im \"Zielpfad\" wird der Download dann gespeichert. Ist eine \"Startzeit\" vorgegeben muss der Download trotzdem gestartet werden, das Laden beginnt dann aber erst zur vorgegebenen Zeit. Sind mehre Downloadsets (Download-Einstellungen) im Programm angelegt, kann man auch ausw\u00e4hlen, mit welcher die Downloads laufen sollen.\n\nMit den Textfeldern kann nach einem w\u00f6rtlichen Suchtext (Suchtext muss enthalten sein/oder darf nicht enthalten sein) oder nach regul\u00e4ren Ausdr\u00fccken (RegExp) gesucht werden.\n\nGro\u00df- und Kleinschreibung wird bei beiden Arten der Suche nicht unterschieden.\n\n-- W\u00f6rtlicher Suchtext muss enthalten sein --\nEin w\u00f6rtlicher Suchtext findet alle Dateien bei denen der Suchtext an beliebiger Stelle im durchsuchten Bereich enthalten ist.\n\nW\u00f6rtlicher Suchtext muss in \" angegeben werden. Dann wird alles gefunden, was im durchsuchten Bereich den Inhalt zwischen den \" enth\u00e4lt. Hier sind auch \",\" und \":\" erlaubt. Der gesamte Suchtext muss aber in \" eingeschlossen werden, z.B.\n\"das, das und das wird gesucht\"\nDann muss der durchsuchte Bereich genau das \"das, das und das wird gesucht\" enthalten (ohne die \").\nEine Suche mit RegEx, z.B. \"#:.*pass,+.*\" kann damit verk\u00fcrzt werden: \"pass,\". Das ist k\u00fcrzer und l\u00e4uft im Programm auch schneller.\n\nUm mehrere Begriffe zu suchen m\u00fcssen diese durch Komma oder Doppelpunkt getrennt werden. Das Komma verkn\u00fcpft die Begriffe mit ODER (=> mindestens einer der Begriffe muss vorkommen), der Doppelpunkt mit UND (=> alle Begriffe m\u00fcssen vorkommen).\n\n\n-- W\u00f6rtlicher Suchtext darf nicht enthalten sein --\nDer Suchtext muss mit '!:' (ohne die ' ') beginnen.\nEin w\u00f6rtlicher Suchtext schlie\u00dft alle Dateien aus, bei denen der Suchtext an beliebiger Stelle im durchsuchten Bereich enthalten ist.\n\nUm mehrere Begriffe auszuschlie\u00dfen, m\u00fcssen diese durch Komma oder Doppelpunkt getrennt werden. Das Komma verkn\u00fcpft die Begriffe mit ODER (=> mindestens einer der Begriffe muss enthalten sein) und der Doppelpunkt verkn\u00fcpft die Begriffe mit UND (=> alle Begriffe m\u00fcssen enthalten sein, damit der Beitrag ausgeschlossen wird).\n\n\nSuchtext und Suchbegriffe d\u00fcrfen Leerzeichen enthalten, aber kein Komma und keinen Doppelpunkt (wenn der gesamte Suchtext nicht in \" eingeschlossen ist.)\n\nBeispiele:\n'Tagesschau' findet u.a. 'Tagesschau, 12:00 Uhr', 'ARD Tagesschau Livestream', 'Bei Logo und der Tagesschau'.\n'Sport,Fussball' (Komma-getrennt) findet Filme bei denen 'Sport' oder 'Fussball' oder beides vorkommt, u.a. 'Wintersport im Mumintal' und 'Wie wird man Fussballprofi?'.\n'Sport:Fussball' (Doppelpunkt-getrennt) findet nur Dateien bei denen beides ('Sport' und 'Fussball') vorkommt, z.B. 'Wintersport, Fussball und Formel 1'.\n\n'!:Auto,Motorrad', es werden nur Beitr\u00e4ge gefunden, die weder \"Auto\" noch \"Motorrad\" enthalten.\n'!:Auto:Motorrad', es werden Beitr\u00e4ge gefunden, die \"Auto\" *und* \"Motorrad\" *nicht* enthalten.\n\n-- Regul\u00e4re Ausdr\u00fccke --\nEin Suchtext aus regul\u00e4ren Ausdr\u00fccken (RegExp) muss mit '#:' (ohne die ' ') beginnen.\n\nBeliebige Zeichen mit in die Suche aufnehmen (als '.+', '.*' oder '.?'') macht einen Unterschied!\n\nBeispiele:\n'#:Burger' oder '#:^burger$' -- beide finden 'Burger' und 'burger' und nichts sonst.\n'#:Burger.+' findet nicht 'Burger', aber alles was nach 'Burger' noch Zeichen enth\u00e4lt (z.B. 'Burger f\u00fcr die Straubing Tigers').\n'#:.+burger' findet alles was auf 'burger' oder 'Burger' endet (z.B. 'Der Hamburger' und '1. Burger').\n\nMehr zu regul\u00e4ren Ausdr\u00fccken:\nhttps://de.wikipedia.org/wiki/Regul%C3%A4rer_Ausdruck\n\n\n-- Besonderheiten --\nWenn bei \"Thema\" der Schalter \"Exakt\" eingeschaltet ist, darf der Suchtext nicht \"an beliebiger Stelle darin enthalten\" sein, sondern muss das gesamte Feld darstellen.\nBeispiele:\n\"Exakt\" eingeschaltet: 'Dokumentation' erfasst nur 'Dokumentation' oder 'dokumentation', nichts sonst.\n\"Exakt\" ausgeschaltet: 'Dokumentation' erfasst u.a. 'Dokumentationen und Reportagen', 'Reportage & Dokumentation', 'Geschichtsdokumentationen'.\n\n[Thema-Titel] durchsucht in der Filmliste THEMA und TITEL.\nBei einer Suche nach mehreren Suchbegriffen m\u00fcssen hier alle Suchbegriffe im selben Bereich vorkommen. Ein Film mit 'Sport' in THEMA und 'Fussball' in TITEL wird von 'Sport:Fussball' nicht erfasst.\n\n"));
    }

    private TabPane getTabPane() {
        AboAddDialogGuiAbo aboAddDialogGuiAbo = new AboAddDialogGuiAbo(this.progData, this.getStage(), this.addAboDto);
        AboAddDialogGuiSearch aboAddDialogGuiSearch = new AboAddDialogGuiSearch(this.progData, this.getStage(), this.addAboDto);
        AboAddDialogGuiPath aboAddDialogGuiPath = new AboAddDialogGuiPath(this.progData, this.getStage(), this.addAboDto);
        Tab tabAbo = new Tab("Abo");
        tabAbo.setClosable(false);
        tabAbo.setContent(aboAddDialogGuiAbo);
        Tab tabSearch = new Tab("Suche");
        tabSearch.setClosable(false);
        tabSearch.setContent(aboAddDialogGuiSearch);
        Tab tabPath = new Tab("Pfad");
        tabPath.setClosable(false);
        tabPath.setContent(aboAddDialogGuiPath);
        TabPane tabPane = new TabPane();
        tabPane.getTabs().addAll((Tab[])new Tab[]{tabAbo, tabSearch, tabPath});
        tabPane.tabMinWidthProperty().bind(tabPane.widthProperty().divide(4));
        VBox.setVgrow(tabPane, Priority.ALWAYS);
        aboAddDialogGuiPath.heightProperty().addListener((u, o, n) -> tabPane.setMinHeight((Double)n));
        return tabPane;
    }

    private void initButton() {
        this.setMaskerPane();
        this.progData.maskerPane.visibleProperty().addListener((u, o, n) -> this.setMaskerPane());
        this.addAboDto.btnPrev.setOnAction(event -> {
            this.addAboDto.actAboIsShown.setValue(this.addAboDto.actAboIsShown.getValue() - 1);
            this.addAboDto.updateAct();
        });
        this.addAboDto.btnNext.setOnAction(event -> {
            this.addAboDto.actAboIsShown.setValue(this.addAboDto.actAboIsShown.getValue() + 1);
            this.addAboDto.updateAct();
        });
        this.btnOk.disableProperty().bind(AboSearchDownloadsFactory.alreadyRunning);
        this.btnOk.setOnAction(a -> {
            if (this.check()) {
                this.apply(true);
                this.close();
            }
        });
        this.btnApply.disableProperty().bind(AboSearchDownloadsFactory.alreadyRunning);
        this.btnApply.setOnAction(a -> {
            if (this.check()) {
                this.apply(false);
            }
        });
        this.btnCancel.setOnAction(a -> this.close());
        this.btnOk.requestFocus();
    }

    private void setMaskerPane() {
        if (this.progData.maskerPane.isVisible()) {
            this.setMaskerVisible(true);
        } else {
            this.setMaskerVisible(false);
        }
    }

    private boolean check() {
        AboDataProps abo = null;
        for (AddAboData addAboData : this.addAboDto.addAboData) {
            abo = AboFactory.aboExistsAlready(addAboData.abo, true);
            if (abo != null) break;
        }
        if (abo != null && P2Alert.showAlert_yes_no(this.getStage(), "Fehler", "Abo anlegen", "Ein Abo mit den Einstellungen existiert bereits, es findet die gleichen (oder mehr) Filme:\n\nAbo-Nr: " + abo.getNo() + "\n" + (String)(abo.getChannel().isEmpty() ? "" : "Sender: " + abo.getChannel() + "\n") + (String)(abo.getTheme().isEmpty() ? "" : "Thema: " + abo.getTheme() + "\n") + (String)(abo.getThemeTitle().isEmpty() ? "" : "Thema-Titel: " + abo.getThemeTitle() + "\n") + (String)(abo.getTitle().isEmpty() ? "" : "Titel: " + abo.getTitle() + "\n") + (String)(abo.getSomewhere().isEmpty() ? "" : "Irgendwo: " + abo.getSomewhere()) + "\n\n" + (this.addAboDto.isNewAbo ? "Trotzdem anlegen?" : "Trotzdem aktualisieren?")).equals((Object)P2Alert.BUTTON.NO)) {
            return false;
        }
        boolean empty = false;
        for (AddAboData addAboData : this.addAboDto.addAboData) {
            abo = addAboData.abo;
            if (!((AboData)abo).isEmpty()) continue;
            empty = true;
            break;
        }
        if (empty) {
            P2Alert.showErrorAlert(this.getStage(), "Fehler", "Abo anlegen", "Abo-Nr: " + abo.getNo() + "\nDas Abo ist \"leer\", es enth\u00e4lt keine Filter.");
            return false;
        }
        return true;
    }

    private void apply(boolean fromOk) {
        if (this.addAboDto.isNewAbo) {
            this.addNewAbos();
        } else {
            this.updateAboList();
        }
        ProgConfig.ABO_MINUTE_MIN_SIZE.setValue(this.addAboDto.getAct().abo.getMinDurationMinute());
        ProgConfig.ABO_MINUTE_MAX_SIZE.setValue(this.addAboDto.getAct().abo.getMaxDurationMinute());
        AboSearchDownloadsFactory.searchFromDialog(fromOk);
        ProgSave.saveAll(false);
    }

    private void addNewAbos() {
        for (AddAboData addAboData : this.addAboDto.addAboData) {
            addAboData.aboOrg.copyToMe(addAboData.abo);
            this.progData.aboList.addAbo(addAboData.aboOrg);
            addAboData.abo.setNo(addAboData.aboOrg.getNo());
        }
        this.addAboDto.isNewAbo = false;
    }

    private void updateAboList() {
        for (AddAboData addAboData : this.addAboDto.addAboData) {
            addAboData.aboOrg.copyToMe(addAboData.abo);
        }
    }
}

