/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog;

import de.p2tools.mtplayer.controller.ProgQuit;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.gui.dialog.ChangeShutDownCallDialog;
import de.p2tools.p2lib.checkforactinfos.FoundHttpDownload;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2BigButton;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.pmask.P2MaskerPaneIndeterminate;
import de.p2tools.p2lib.tools.P2ShutDown;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class QuitDialogController
extends P2DialogExtra {
    private CheckBox chkShutDown = new CheckBox("Rechner anschlie\u00dfend herunterfahren");
    private CheckBox chkBlend;
    private Label lblSystemCall;
    private final StackPane stackPane;
    private final P2MaskerPaneIndeterminate maskerPane;
    private WaitTask waitTask;
    private final boolean startWithWaiting;

    public QuitDialogController(boolean startWithWaiting) {
        super(ProgData.getInstance().primaryStage, null, "Programm beenden", true, false, P2DialogExtra.DECO.BORDER);
        this.chkBlend = new CheckBox(ProgData.getInstance().progTray.getSystemTray() != null ? "Programm Ausblenden" : "Programm Minimieren");
        this.lblSystemCall = new Label("");
        this.stackPane = new StackPane();
        this.maskerPane = new P2MaskerPaneIndeterminate();
        this.waitTask = null;
        this.startWithWaiting = startWithWaiting;
        this.init(true);
    }

    @Override
    public void close() {
        this.cancelWaitTask();
        this.maskerPane.switchOffMasker();
        this.chkShutDown.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_SHUT_DOWN_CALL_ON);
        this.chkBlend.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_QUITT_DIALOG_MINIMIZE);
        super.close();
    }

    @Override
    public void make() {
        this.maskerPane.switchOffMasker();
        this.maskerPane.setButtonText("Abbrechen");
        this.maskerPane.setTxtBtnHorizontal(false);
        this.maskerPane.getButton().setOnAction(a -> this.closeMaskerPane());
        Label headerLabel = new Label("Es laufen noch Downloads!");
        headerLabel.setStyle("-fx-font-size: 1.5em;");
        P2BigButton cancelButton = new P2BigButton(ProgIcons.ICON_BUTTON_QUIT.getImageView(), "Nicht beenden", "");
        cancelButton.setOnAction(e -> this.close());
        P2BigButton quitButton = new P2BigButton(ProgIcons.ICON_BUTTON_QUIT.getImageView(), "Beenden", "Alle Downloads abbrechen und das Programm beenden.");
        quitButton.setOnAction(e -> ProgQuit.quit());
        P2BigButton waitButton = new P2BigButton(ProgIcons.ICON_BUTTON_QUIT.getImageView(), "Warten", "Alle Downloads abwarten und dann das Programm beenden.");
        waitButton.setOnAction(e -> this.startWaiting());
        this.chkShutDown.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SHUT_DOWN_CALL_ON);
        this.chkBlend.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_QUITT_DIALOG_MINIMIZE);
        this.setSystemCallText();
        ProgConfig.SYSTEM_SHUT_DOWN_CALL.addListener((u, o, n) -> this.setSystemCallText());
        Button btnHelp = P2Button.helpButton(this.getStage(), "Rechner herunterfahren", "Wird das Programm bei noch laufenden Downloads beendet, erscheint der \"Auf Downloads warten\" Dialog. Hier kann dann ausgew\u00e4hlt werden:\n\n-> Nicht beenden\n-> Beenden\n-> Warten\n\nWird \"Warten\" ausgew\u00e4hlt, beendet sich das Programm erst wenn alle Downloads erledigt sind. Nach dem Warten ist es dann m\u00f6glich, einen Systemaufruf abzusetzen. Gedacht ist das, um nach der Wartezeit das Programm zu beenden und den Rechner herunterzufahren. F\u00fcr Linux und Windows bringt das Programm die Standard-Befehle daf\u00fcr mit.\n\nDiese k\u00f6nnen aber auch angepasst werden. So ist es z.B. auch m\u00f6glich, einen ganz anderen Befehl oder ein eigenes Skript nach dem Warten auf die Downloads und dem Programmende, auszuf\u00fchren.\n");
        Button btnEdit = new Button();
        btnEdit.setGraphic(ProgIcons.ICON_BUTTON_EDIT.getImageView());
        btnEdit.setOnAction(a -> new ChangeShutDownCallDialog((Stage)this.getStageProp().getValue()));
        btnEdit.setTooltip(new Tooltip("Systembefehl nach Programmende anpassen"));
        GridPane gridPane = new GridPane();
        gridPane.setHgap(15.0);
        gridPane.setVgap(20.0);
        gridPane.setPadding(new Insets(20.0));
        int row = 0;
        gridPane.add(ProgIcons.ICON_ATTENTION_64.getImageView(), 0, 0, 1, 1);
        gridPane.add(headerLabel, 1, row);
        gridPane.add(cancelButton, 1, ++row);
        gridPane.add(quitButton, 1, ++row);
        gridPane.add(new Label(), 1, ++row);
        HBox hBoxBlend = new HBox(10.0);
        hBoxBlend.setAlignment(Pos.CENTER_LEFT);
        hBoxBlend.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVDistance(10), this.chkBlend});
        HBox hBoxQuitt = new HBox(10.0);
        hBoxQuitt.setAlignment(Pos.CENTER_LEFT);
        hBoxQuitt.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVDistance(10), this.chkShutDown, P2GuiTools.getHBoxGrower(), btnEdit, btnHelp});
        HBox hBoxCall = new HBox(0.0);
        hBoxCall.setAlignment(Pos.CENTER_LEFT);
        hBoxCall.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVDistance(25), this.lblSystemCall});
        VBox vBox = new VBox(1.0);
        vBox.getChildren().addAll((Node[])new Node[]{waitButton, P2GuiTools.getHDistance(5), hBoxBlend, hBoxQuitt, hBoxCall});
        gridPane.add(vBox, 1, ++row);
        this.stackPane.getChildren().addAll((Node[])new Node[]{gridPane, this.maskerPane});
        this.getVBoxCont().getChildren().addAll((Node[])new Node[]{this.stackPane});
        if (this.startWithWaiting) {
            this.startWaiting();
        }
    }

    private void setSystemCallText() {
        if (ProgConfig.SYSTEM_SHUT_DOWN_CALL.getValueSafe().equals(P2ShutDown.getShutDownCommand())) {
            this.chkShutDown.setText("Nach Warten und Programmende, Rechner herunterfahren");
            this.lblSystemCall.setText("");
            this.lblSystemCall.setVisible(false);
            this.lblSystemCall.setManaged(false);
        } else {
            this.chkShutDown.setText("Nach Warten und Programmende, Systembefehl aufrufen");
            this.lblSystemCall.setVisible(true);
            this.lblSystemCall.setManaged(true);
            this.lblSystemCall.setText(ProgConfig.SYSTEM_SHUT_DOWN_CALL.getValueSafe());
        }
    }

    private void startWaiting() {
        this.maskerPane.setMaskerVisible(true, this.chkShutDown.isSelected(), true);
        this.maskerPane.setMaskerText(this.chkShutDown.isSelected() ? this.chkShutDown.getText() : "");
        if (this.chkBlend.isSelected()) {
            if (ProgData.getInstance().progTray.getSystemTray() != null) {
                ProgData.getInstance().progTray.hideDialog();
            } else {
                ProgData.getInstance().primaryStage.setIconified(true);
                this.getStage().setIconified(true);
            }
        }
        Thread th = new Thread(this.getWaitTask());
        th.setName("startWaiting");
        th.start();
    }

    public void closeMaskerPane() {
        this.cancelWaitTask();
        this.maskerPane.switchOffMasker();
    }

    private WaitTask getWaitTask() {
        this.waitTask = new WaitTask();
        this.waitTask.setOnSucceeded(event -> {
            if (this.chkShutDown.isSelected()) {
                ProgQuit.quitShutDown();
            } else {
                ProgQuit.quit();
            }
        });
        return this.waitTask;
    }

    private void cancelWaitTask() {
        if (this.waitTask != null && this.waitTask.isRunning()) {
            this.waitTask.cancel();
        }
    }

    private static class WaitTask
    extends Task<Void> {
        private WaitTask() {
        }

        @Override
        protected Void call() throws Exception {
            while (!(ProgData.getInstance().downloadList.countStartedAndRunningDownloads() <= 0 && FoundHttpDownload.downloadRunning <= 0 || this.isCancelled())) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            return null;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

