/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.setdata.SetImportFactory;
import de.p2tools.mtplayer.gui.configdialog.panesetdata.ControllerSet;
import de.p2tools.mtplayer.gui.startdialog.StartPaneDownloadPath;
import de.p2tools.mtplayer.gui.startdialog.StartPanePath;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ImportSetDialogController
extends P2DialogExtra {
    private final ProgData progData;
    Button btnCancel = new Button("_Abbrechen");
    Button btnImport = new Button("_Set importieren");
    private final VBox vBoxPath = new VBox();
    private ControllerSet controllerSet;

    public ImportSetDialogController(ProgData progData) {
        super(progData.primaryStage, ProgConfig.CONFIG_DIALOG_IMPORT_SET_SIZE, "Set importieren", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.progData = progData;
        this.init(true);
    }

    @Override
    public void close() {
        this.controllerSet.close();
        super.close();
    }

    @Override
    public void make() {
        this.btnCancel.setOnAction(a -> this.close());
        Button btnHelp = P2Button.helpButton(this.getStage(), "Set zur\u00fccksetzen", "Es werden die Standard-Sets eingerichtet, bestehende werden durch neue ersetzen\n\nDamit werden die Sets die zum Abspielen und Aufzeichnen der Filme gebraucht werden angelegt.\nEventuell noch bestehende Sets werden gel\u00f6scht. Es wird der Standard-Zustand wie nach dem ersten Start wieder hergestellt. Damit kann dann direkt weitergearbeitet werden.");
        this.btnImport.setOnAction(event -> this.importSet());
        TitledPane tpDownPath = new StartPaneDownloadPath(this.getStage()).makePath();
        tpDownPath.setMaxHeight(Double.MAX_VALUE);
        tpDownPath.setCollapsible(false);
        TitledPane tpPath = new StartPanePath(this.getStage()).makePath();
        tpPath.setMaxHeight(Double.MAX_VALUE);
        tpPath.setCollapsible(false);
        this.vBoxPath.setSpacing(10.0);
        this.vBoxPath.getChildren().addAll((Node[])new Node[]{tpDownPath, tpPath});
        this.vBoxPath.setStyle("-fx-background-color: -fx-background;");
        this.controllerSet = new ControllerSet(this.getStage());
        this.controllerSet.setMaxWidth(Double.MAX_VALUE);
        this.controllerSet.setMaxHeight(Double.MAX_VALUE);
        this.controllerSet.setStyle("-fx-background-color: -fx-background;");
        StackPane stackPane = new StackPane();
        stackPane.getChildren().addAll((Node[])new Node[]{this.vBoxPath, this.controllerSet});
        this.vBoxPath.toFront();
        VBox.setVgrow(stackPane, Priority.ALWAYS);
        this.getVBoxCont().getChildren().add(stackPane);
        this.addOkButton(this.btnImport);
        this.addCancelButton(this.btnCancel);
        this.addHlpButton(btnHelp);
    }

    private void importSet() {
        this.btnCancel.setText("Ok");
        this.btnImport.setVisible(false);
        this.btnImport.setManaged(false);
        this.progData.setDataList.clear();
        if (SetImportFactory.getStandardSet(this.getStage())) {
            P2Alert.showInfoAlert(this.getStage(), "Set", "Set importieren", "Sets wurden importiert!", false);
        } else {
            P2Alert.showErrorAlert(this.getStage(), "Set importieren", "Sets konnten nicht importiert werden!");
        }
        this.controllerSet.toFront();
    }
}

