/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.mv.LoadMV;
import de.p2tools.mtplayer.controller.mv.MVFactory;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import java.nio.file.Path;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class ImportMVDialog
extends P2DialogExtra {
    private final ProgData progData;
    private final Button btnOk = new Button("_Ok");
    private final TextField txtMVPath = new TextField();
    private final ObservableList<AboData> aboList = FXCollections.observableArrayList();
    private final ObservableList<BlackData> blackList = FXCollections.observableArrayList();

    public ImportMVDialog(ProgData progData) {
        super(progData.primaryStage, ProgConfig.IMPORT_MV_DIALOG_SIZE, "MediathekView Einstellungen importieren", true, true, P2DialogExtra.DECO.BORDER_SMALL, true);
        this.progData = progData;
        this.initDialog();
        this.init(false);
        super.showDialog();
    }

    @Override
    public void close() {
        super.close();
    }

    private void initDialog() {
        VBox vBox = this.getVBoxCont();
        vBox.setSpacing(20.0);
        vBox.setPadding(new Insets(10.0));
        Text text = new Text("1. Pfad zum Konfigfile");
        text.setFont(Font.font(null, FontWeight.BOLD, 16.0));
        text.getStyleClass().add("downloadGuiMediaText");
        vBox.getChildren().add(text);
        this.addPath(vBox);
        vBox.getChildren().add(P2GuiTools.getHDistance(20));
        text = new Text("2. Einstellungen suchen");
        text.setFont(Font.font(null, FontWeight.BOLD, 16.0));
        text.getStyleClass().add("downloadGuiMediaText");
        vBox.getChildren().add(text);
        this.addLoad(vBox);
        vBox.getChildren().add(P2GuiTools.getHDistance(20));
        text = new Text("3. Einstellungen anf\u00fcgen");
        text.setFont(Font.font(null, FontWeight.BOLD, 16.0));
        text.getStyleClass().add("downloadGuiMediaText");
        vBox.getChildren().add(text);
        this.importLoads(vBox);
        this.addOkButton(this.btnOk);
        this.btnOk.setOnAction(a -> this.close());
    }

    private void addPath(VBox vBox) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        this.txtMVPath.setText(MVFactory.getSettingsDirectory());
        Button btnFile = new Button();
        btnFile.setTooltip(new Tooltip("Den Konfig-Ordner f\u00fcr MediathekView ausw\u00e4hlen"));
        btnFile.setOnAction(event -> P2DirFileChooser.DirChooser(this.getStage(), this.txtMVPath));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        Button btnHelp = P2Button.helpButton(this.getStageProp(), "Konfigordner", "Der Konfig-Ordner von MediathekView muss hier eingetragen werden. Normalerweise ist er im Benutzerverzeichnis und heist \".mediathek3\"\n");
        int row = 0;
        gridPane.add(new Label("Den Pfad zum MediathekView Konfig-Ordner ausw\u00e4hlen"), 0, row);
        gridPane.add(btnHelp, 1, row);
        gridPane.add(this.txtMVPath, 0, ++row);
        gridPane.add(btnFile, 1, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }

    private void addLoad(VBox vBox) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        Button btnHelp = P2Button.helpButton(this.getStageProp(), "Konfigordner", "Hier wird versucht, im MediathekView Konfig-Ordner die Einstellungen zu suchen. Die gefundenen Einstellungen werden damit aber noch nicht importiert.\n");
        Button btnLoad = new Button();
        btnLoad.setTooltip(new Tooltip("Die Einstellungen suchen"));
        btnLoad.setOnAction(event -> new LoadMV(this.aboList, this.blackList).readConfiguration(Path.of(this.txtMVPath.getText(), new String[0])));
        btnLoad.setGraphic(ProgIcons.ICON_BUTTON_PLAY.getImageView());
        GridPane.setHalignment(btnLoad, HPos.RIGHT);
        Label lblAbo = new Label();
        this.aboList.addListener(c -> lblAbo.setText("" + this.aboList.size()));
        Label lblBlack = new Label();
        this.blackList.addListener(c -> lblBlack.setText("" + this.blackList.size()));
        int row = 0;
        gridPane.add(new Label("Suchen:"), 0, row);
        gridPane.add(btnLoad, 1, row);
        gridPane.add(btnHelp, 2, row);
        ++row;
        gridPane.add(new Label("Gefundene Abos:"), 0, ++row);
        gridPane.add(lblAbo, 1, row);
        gridPane.add(new Label("Gefundene Blacks:"), 0, ++row);
        gridPane.add(lblBlack, 1, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize()});
    }

    private void importLoads(VBox vBox) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        Button btnHelp = P2Button.helpButton(this.getStageProp(), "Config-Ordner", "Hier k\u00f6nnen die gefundenen Einstellungen im Programm importiert werden. Es wird aber kontrolliert, ob es die gleichen Abos/Blacks bereits gibt. Es werden also nur neue Abos/Blacks importiert. Dr\u00fcckt man den Button mehrfach, werden nicht ein weiteres mal, die Abos/Blacks importiert.\n");
        Label lblFoundAbos = new Label("");
        Button btnAddAbo = new Button();
        btnAddAbo.setTooltip(new Tooltip("Gefundene Abos an die eigenen Abos anh\u00e4ngen"));
        btnAddAbo.setOnAction(event -> {
            int found = MVFactory.importAbosMediathekView(this.getStage(), this.aboList);
            lblFoundAbos.setText("" + found);
        });
        btnAddAbo.setGraphic(ProgIcons.ICON_BUTTON_RESET.getImageView());
        GridPane.setHalignment(btnAddAbo, HPos.RIGHT);
        Label lblFoundBlacks = new Label("");
        Button btnAddBlack = new Button();
        btnAddBlack.setTooltip(new Tooltip("Gefundene Blacks an die eigenen Blacks anh\u00e4ngen"));
        btnAddBlack.setOnAction(event -> {
            int found = MVFactory.addBlacks(this.blackList);
            lblFoundBlacks.setText("" + found);
        });
        btnAddBlack.setGraphic(ProgIcons.ICON_BUTTON_RESET.getImageView());
        GridPane.setHalignment(btnAddBlack, HPos.RIGHT);
        int row = 0;
        gridPane.add(new Label("Hier k\u00f6nnen die gefundenen Einstellungen importiert werden"), 0, row);
        gridPane.add(btnHelp, 1, row);
        ++row;
        gridPane.add(new Label("Abos importieren:"), 0, ++row);
        gridPane.add(btnAddAbo, 1, row);
        gridPane.add(new Label("Abos eingef\u00fcgt:"), 0, ++row);
        gridPane.add(lblFoundAbos, 1, row);
        ++row;
        gridPane.add(new Label("Blacks importieren:"), 0, ++row);
        gridPane.add(btnAddBlack, 1, row);
        gridPane.add(new Label("Blacks eingef\u00fcgt:"), 0, ++row);
        gridPane.add(lblFoundBlacks, 1, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize()});
    }
}

