/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.mtfilm.film.FilmDataXml;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class FilmInfoDialogController
extends P2DialogExtra {
    private static FilmInfoDialogController instance;
    private final Text[] textTitle = new Text[23];
    private final Label[] lblCont = new Label[23];
    private final TextArea textArea = new TextArea();
    private final GridPane gridPane = new GridPane();
    private final Button btnOk = new Button("_Ok");
    private final ImageView ivHD = new ImageView();
    private final ImageView ivUT = new ImageView();
    private final ImageView ivNew = new ImageView();
    private final P2Hyperlink p2HyperlinkUrlSmall = new P2Hyperlink("", ProgConfig.SYSTEM_PROG_OPEN_URL);
    private final P2Hyperlink p2HyperlinkUrlHeight = new P2Hyperlink("", ProgConfig.SYSTEM_PROG_OPEN_URL);
    private final P2Hyperlink p2HyperlinkUrlHd = new P2Hyperlink("", ProgConfig.SYSTEM_PROG_OPEN_URL);
    private final P2Hyperlink p2HyperlinkWebsite = new P2Hyperlink("", ProgConfig.SYSTEM_PROG_OPEN_URL);

    private FilmInfoDialogController() {
        super(ProgData.getInstance().primaryStage, ProgConfig.FILM_INFO_DIALOG_SIZE, "Filminfos", false, false, P2DialogExtra.DECO.BORDER_SMALL, true);
        this.init(false);
    }

    public void showFilmInfo() {
        this.showDialog();
    }

    public void setFilm(FilmDataMTP film) {
        Platform.runLater(() -> {
            block10: for (int i = 0; i < 23; ++i) {
                if (film == null) {
                    this.lblCont[i].setText("");
                    this.textArea.setText("");
                    this.ivHD.setImage(null);
                    this.ivUT.setImage(null);
                    this.ivNew.setImage(null);
                    this.p2HyperlinkUrlSmall.setUrl("");
                    this.p2HyperlinkUrlHeight.setUrl("");
                    this.p2HyperlinkUrlHd.setUrl("");
                    this.p2HyperlinkWebsite.setUrl("");
                    continue;
                }
                switch (i) {
                    case 0: {
                        this.lblCont[i].setText("" + film.getNo());
                        continue block10;
                    }
                    case 8: {
                        this.lblCont[i].setText("" + film.getDurationMinute());
                        continue block10;
                    }
                    case 14: {
                        this.p2HyperlinkUrlSmall.setUrl(film.isSmall() ? film.getUrlForResolution("small") : "");
                        this.p2HyperlinkUrlHeight.setUrl(film.arr[14]);
                        this.p2HyperlinkUrlHd.setUrl(film.isHd() ? film.getUrlForResolution("hd") : "");
                        continue block10;
                    }
                    case 15: {
                        this.p2HyperlinkWebsite.setUrl(film.arr[15]);
                        continue block10;
                    }
                    case 12: {
                        this.textArea.setText(film.arr[i]);
                        continue block10;
                    }
                    case 10: {
                        if (film.isHd()) {
                            this.ivHD.setImage(ProgIcons.ICON_BOOLEAN_IS_ON.getImage());
                            continue block10;
                        }
                        this.ivHD.setImage(null);
                        continue block10;
                    }
                    case 11: {
                        if (film.isUt()) {
                            this.ivUT.setImage(ProgIcons.ICON_BOOLEAN_IS_ON.getImage());
                            continue block10;
                        }
                        this.ivUT.setImage(null);
                        continue block10;
                    }
                    case 21: {
                        if (film.isNewFilm()) {
                            this.ivNew.setImage(ProgIcons.ICON_BOOLEAN_IS_ON.getImage());
                            continue block10;
                        }
                        this.ivNew.setImage(null);
                        continue block10;
                    }
                    default: {
                        this.lblCont[i].setText(film.arr[i]);
                    }
                }
            }
        });
    }

    @Override
    public void updateCss() {
        super.updateCss();
        for (int i = 0; i < 23; ++i) {
            if (this.textTitle[i] == null) {
                return;
            }
            this.textTitle[i].getStyleClass().add("downloadGuiMediaText");
        }
    }

    @Override
    public void make() {
        this.getMaskerPane().visibleProperty().bind(ProgData.getInstance().maskerPane.visibleProperty());
        this.addOkButton(this.btnOk);
        this.btnOk.setOnAction(a -> this.close());
        this.getVBoxCont().getChildren().add(this.gridPane);
        this.gridPane.setHgap(10.0);
        this.gridPane.setVgap(10.0);
        this.gridPane.setPadding(new Insets(5.0));
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        int row = 0;
        block9: for (int i = 0; i < 23; ++i) {
            this.textTitle[i] = new Text(FilmDataXml.COLUMN_NAMES[i] + ":");
            this.textTitle[i].setFont(Font.font(null, FontWeight.BOLD, -1.0));
            this.textTitle[i].getStyleClass().add("downloadGuiMediaText");
            this.lblCont[i] = new Label("");
            this.lblCont[i].setWrapText(true);
            switch (i) {
                case 4: 
                case 5: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: {
                    continue block9;
                }
                case 10: {
                    this.gridPane.add(this.textTitle[i], 0, row);
                    this.gridPane.add(this.ivHD, 1, row++);
                    continue block9;
                }
                case 11: {
                    this.gridPane.add(this.textTitle[i], 0, row);
                    this.gridPane.add(this.ivUT, 1, row++);
                    continue block9;
                }
                case 21: {
                    this.gridPane.add(this.textTitle[i], 0, row);
                    this.gridPane.add(this.ivNew, 1, row++);
                    continue block9;
                }
                case 14: {
                    this.p2HyperlinkUrlSmall.setWrapText(true);
                    this.p2HyperlinkUrlHeight.setWrapText(true);
                    this.p2HyperlinkUrlHd.setWrapText(true);
                    TitledPane tpUrl = new TitledPane("", new HBox());
                    tpUrl.expandedProperty().bindBidirectional(ProgConfig.FILM_INFO_DIALOG_SHOW_URL);
                    GridPane gUrl = new GridPane();
                    gUrl.setHgap(10.0);
                    gUrl.setVgap(0.0);
                    gUrl.setPadding(new Insets(0.0));
                    gUrl.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
                    gUrl.add(new Label("Niedrig:"), 0, 0);
                    gUrl.add(this.p2HyperlinkUrlSmall, 1, 0);
                    gUrl.add(new Label("Hoch:"), 0, 1);
                    gUrl.add(this.p2HyperlinkUrlHeight, 1, 1);
                    gUrl.add(new Label("HD:"), 0, 2);
                    gUrl.add(this.p2HyperlinkUrlHd, 1, 2);
                    tpUrl.setContent(gUrl);
                    this.gridPane.add(this.textTitle[i], 0, row);
                    this.gridPane.add(tpUrl, 1, row++, 2, 1);
                    continue block9;
                }
                case 15: {
                    this.p2HyperlinkWebsite.setWrapText(true);
                    TitledPane tpUrl = new TitledPane("", new HBox());
                    tpUrl.expandedProperty().bindBidirectional(ProgConfig.FILM_INFO_DIALOG_SHOW_WEBSITE_URL);
                    GridPane gWeb = new GridPane();
                    gWeb.add(this.textTitle[i], 0, 0);
                    gWeb.add(this.p2HyperlinkWebsite, 1, 1, 3, 1);
                    tpUrl.setContent(gWeb);
                    this.gridPane.add(this.textTitle[i], 0, row);
                    this.gridPane.add(tpUrl, 1, row++, 2, 1);
                    continue block9;
                }
                case 12: {
                    this.textArea.setMaxHeight(Double.MAX_VALUE);
                    this.textArea.setPrefRowCount(6);
                    this.textArea.setWrapText(true);
                    this.textArea.setEditable(false);
                    TitledPane tpUrl = new TitledPane("", new HBox());
                    tpUrl.expandedProperty().bindBidirectional(ProgConfig.FILM_INFO_DIALOG_SHOW_DESCRIPTION);
                    GridPane gDescription = new GridPane();
                    gDescription.add(this.textTitle[i], 0, 0);
                    gDescription.add(this.textArea, 1, 1, 3, 1);
                    tpUrl.setContent(gDescription);
                    this.gridPane.add(this.textTitle[i], 0, row);
                    this.gridPane.add(tpUrl, 1, row++);
                    continue block9;
                }
                default: {
                    this.gridPane.add(this.textTitle[i], 0, row);
                    this.gridPane.add(this.lblCont[i], 1, row++);
                    int ii = i;
                    this.lblCont[i].setOnContextMenuRequested(event -> this.getMenu(this.lblCont[ii], (ContextMenuEvent)event));
                }
            }
        }
    }

    private void getMenu(Label lbl, ContextMenuEvent event) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem menuItem = new MenuItem("Kopieren");
        menuItem.setOnAction(a -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(lbl.getText());
            clipboard.setContent(content);
        });
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{menuItem});
        contextMenu.show(lbl, event.getScreenX(), event.getScreenY());
    }

    public static synchronized FilmInfoDialogController getInstance() {
        if (instance == null) {
            instance = new FilmInfoDialogController();
        }
        return instance;
    }

    public static synchronized FilmInfoDialogController getInstanceAndShow() {
        if (instance == null) {
            instance = new FilmInfoDialogController();
        }
        if (!instance.isShowing()) {
            instance.showDialog();
        }
        instance.getStage().toFront();
        return instance;
    }
}

