/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;

public class DownloadSubtitleDialog
extends P2DialogExtra {
    private final ProgData progData;
    private final Button btnOk = new Button("_Ok");
    private final Button btnCancel = new Button("_Abbrechen");
    private final TextField txtPath = new TextField();
    private final TextField txtFileName = new TextField();
    private final StringProperty pathProp;
    private final StringProperty nameProp;
    private final BooleanProperty okProp;
    private final boolean subtitel;

    public DownloadSubtitleDialog(ProgData progData, boolean subtitel, StringProperty pathProp, StringProperty nameProp, BooleanProperty okProp) {
        super(progData.primaryStage, ProgConfig.DOWNLOAD_SUBTITLE_DIALOG_SIZE, "Untertitel laden", true, false, P2DialogExtra.DECO.BORDER_SMALL, true);
        this.subtitel = subtitel;
        this.progData = progData;
        this.pathProp = pathProp;
        this.nameProp = nameProp;
        this.okProp = okProp;
        okProp.set(false);
        this.initDialog();
        this.init(false);
    }

    @Override
    public void close() {
        this.txtPath.textProperty().unbindBidirectional(this.pathProp);
        this.txtFileName.textProperty().unbindBidirectional(this.nameProp);
        super.close();
    }

    private void initDialog() {
        VBox vBox = this.getVBoxCont();
        vBox.setSpacing(20.0);
        vBox.setPadding(new Insets(10.0));
        this.addPathName(vBox);
        this.txtPath.textProperty().bindBidirectional(this.pathProp);
        this.txtFileName.textProperty().bindBidirectional(this.nameProp);
        this.addOkCancelButtons(this.btnOk, this.btnCancel);
        this.btnOk.setOnAction(a -> {
            this.okProp.set(true);
            this.close();
        });
        this.btnCancel.setOnAction(a -> this.close());
    }

    private void addPathName(VBox vBox) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        Button btnFile = new Button();
        btnFile.setTooltip(new Tooltip("Ordner zum Speichern ausw\u00e4hlen"));
        btnFile.setOnAction(event -> P2DirFileChooser.DirChooser(this.getStage(), this.txtPath));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        int row = 0;
        gridPane.add(new Label("Pfad"), 0, row);
        gridPane.add(this.txtPath, 0, ++row);
        gridPane.add(btnFile, 1, row);
        gridPane.add(new Label("Dateiname"), 0, ++row);
        gridPane.add(this.txtFileName, 0, ++row);
        if (this.subtitel) {
            gridPane.add(new Label(".srt  .ttml"), 1, row);
        } else {
            gridPane.add(new Label(".txt"), 1, row);
        }
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }
}

