/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class AutomodeContinueDialogController
extends P2DialogExtra {
    private final VBox vBoxCont;
    private final Button btnCancel;
    private final Button btnContinue;
    private GridPane gridPane = new GridPane();
    private boolean continueAutomode = true;
    private Timeline timeline = null;
    private Integer timeSeconds = ProgConfig.SYSTEM_PARAMETER_AUTOMODE_QUITT_IN_SECONDS.getValue();

    public AutomodeContinueDialogController() {
        super(ProgData.getInstance().primaryStage, null, "Automodus", true, false);
        this.vBoxCont = this.getVBoxCont();
        this.btnCancel = new Button("_Programm nicht beenden");
        this.btnContinue = new Button("_Beenden in " + this.timeSeconds + " s");
        this.init(true);
    }

    @Override
    public void make() {
        this.initCont();
        this.initButton();
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        this.timeline.getKeyFrames().add(new KeyFrame(Duration.seconds(1.0), event -> this.handleCountDownAction(), new KeyValue[0]));
        this.timeline.playFromStart();
    }

    private void initCont() {
        this.gridPane.setHgap(10.0);
        this.gridPane.setVgap(10.0);
        VBox.setVgrow(this.gridPane, Priority.ALWAYS);
        this.gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Label lblHeader1 = new Label("Automodus und keine Downloads,");
        Label lblHeader2 = new Label("das Programm wird sofort wieder beendet.");
        GridPane.setHalignment(lblHeader1, HPos.CENTER);
        GridPane.setHalignment(lblHeader2, HPos.CENTER);
        int row = 0;
        this.gridPane.add(lblHeader1, 0, row);
        this.gridPane.add(lblHeader2, 0, ++row);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        this.vBoxCont.setPadding(new Insets(15.0));
        this.vBoxCont.getChildren().addAll((Node[])new Node[]{this.gridPane});
        this.getHboxLeft().getChildren().add(new Label("Wie m\u00f6chten Sie forfahren?"));
        this.addOkCancelButtons(this.btnContinue, this.btnCancel);
    }

    public boolean isContinueAutomode() {
        return this.continueAutomode;
    }

    private void handleCountDownAction() {
        Integer n = this.timeSeconds;
        this.timeSeconds = this.timeSeconds - 1;
        if (this.timeSeconds > 0) {
            this.btnContinue.setText("_Beenden in " + this.timeSeconds + " s");
        } else {
            this.timeline.stop();
            this.continueAutomode = true;
            this.quit();
        }
    }

    private void stopCounter() {
        if (this.timeline != null) {
            this.timeline.stop();
        }
    }

    private void quit() {
        this.stopCounter();
        this.close();
    }

    private void initButton() {
        this.btnCancel.setOnAction(event -> {
            this.continueAutomode = false;
            this.quit();
        });
        this.btnContinue.setOnAction(event -> {
            this.continueAutomode = true;
            this.quit();
        });
    }
}

