/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2MenuButton;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;

public class AddBlackListDialogController
extends P2DialogExtra {
    private boolean ok = false;
    private Button btnOk = new Button("_Ok");
    private Button btnCancel = new Button("_Abbrechen");
    private final GridPane gridPane = new GridPane();
    private final Button btnCount = new Button("Treffer z\u00e4hlen");
    private final Label lblCount = new Label();
    private final P2MenuButton mbChannel;
    private final TextField txtTheme = new TextField();
    private final P2ToggleSwitch tgTheme = new P2ToggleSwitch("exakt:");
    private final TextField txtTitle = new TextField();
    private final TextField txtThemeTitle = new TextField();
    private final Button btnChannel = new Button();
    private final Button btnTheme = new Button();
    private final Button btnTitel = new Button();
    private final Button btnClearChannel = new Button();
    private final Button btnClearTheme = new Button();
    private final Button btnClearTitel = new Button();
    private final Button btnClearThemeTitel = new Button();
    private final String channel;
    private final String theme;
    private final String title;
    private final BlackData blackData;

    public AddBlackListDialogController(BlackData blackData) {
        super(ProgData.getInstance().primaryStage, ProgConfig.ADD_BLACK_DIALOG_SIZE, "Blacklist-Eintrag erstellen", true, false);
        this.channel = blackData.getChannel();
        this.theme = blackData.getTheme();
        this.title = blackData.getTitle();
        this.blackData = blackData;
        this.mbChannel = new P2MenuButton(this.blackData.channelProperty(), ThemeListFactory.allChannelList, true);
        this.init(true);
    }

    @Override
    public void make() {
        this.addOkCancelButtons(this.btnOk, this.btnCancel);
        this.getHboxLeft().getChildren().addAll((Node[])new Node[]{this.btnCount, this.lblCount});
        this.getVBoxCont().getChildren().add(this.gridPane);
        this.initButton();
        this.initGridPane();
    }

    public boolean isOk() {
        return this.ok;
    }

    private void initButton() {
        this.btnOk.setOnAction(event -> {
            this.ok = true;
            this.close();
        });
        this.btnOk.disableProperty().bind(this.blackData.channelProperty().isEmpty().and(this.blackData.themeProperty().isEmpty().and(this.blackData.titleProperty().isEmpty().and(this.blackData.themeTitleProperty().isEmpty()))));
        this.btnCancel.setOnAction(event -> {
            this.ok = false;
            this.close();
        });
    }

    private void initGridPane() {
        this.btnCount.setOnAction(a -> {
            BlacklistFilterFactory.countHits(this.blackData);
            this.lblCount.setText("" + this.blackData.getCountHits());
        });
        this.btnChannel.setOnAction(a -> this.blackData.setChannel(this.channel));
        this.btnChannel.setTooltip(new Tooltip("Daten vom Film eintragen"));
        this.btnChannel.setGraphic(ProgIcons.ICON_BUTTON_RESET.getImageView());
        this.btnTheme.setOnAction(a -> this.blackData.setTheme(this.theme));
        this.btnTheme.setTooltip(new Tooltip("Daten vom Film eintragen"));
        this.btnTheme.setGraphic(ProgIcons.ICON_BUTTON_RESET.getImageView());
        this.btnTitel.setOnAction(a -> this.blackData.setTitle(this.title));
        this.btnTitel.setTooltip(new Tooltip("Daten vom Film eintragen"));
        this.btnTitel.setGraphic(ProgIcons.ICON_BUTTON_RESET.getImageView());
        this.btnClearChannel.setOnAction(a -> this.blackData.channelProperty().setValue(""));
        this.btnClearChannel.setTooltip(new Tooltip("Feld l\u00f6schen"));
        this.btnClearChannel.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        this.btnClearTheme.setOnAction(a -> this.blackData.setTheme(""));
        this.btnClearTheme.setTooltip(new Tooltip("Feld l\u00f6schen"));
        this.btnClearTheme.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        this.btnClearTitel.setOnAction(a -> this.blackData.setTitle(""));
        this.btnClearTitel.setTooltip(new Tooltip("Feld l\u00f6schen"));
        this.btnClearTitel.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        this.btnClearThemeTitel.setOnAction(a -> this.blackData.setThemeTitle(""));
        this.btnClearThemeTitel.setTooltip(new Tooltip("Feld l\u00f6schen"));
        this.btnClearThemeTitel.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        this.txtTheme.textProperty().bindBidirectional(this.blackData.themeProperty());
        this.tgTheme.selectedProperty().bindBidirectional(this.blackData.themeExactProperty());
        this.txtTitle.textProperty().bindBidirectional(this.blackData.titleProperty());
        this.txtThemeTitle.textProperty().bindBidirectional(this.blackData.themeTitleProperty());
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize()});
        this.gridPane.setHgap(10.0);
        this.gridPane.setVgap(10.0);
        this.gridPane.setPadding(new Insets(5.0));
        int row = 0;
        this.gridPane.add(new Label("Sender:"), 0, row);
        this.gridPane.add(this.mbChannel, 1, row);
        this.gridPane.add(this.btnChannel, 2, row);
        this.gridPane.add(this.btnClearChannel, 3, row);
        this.gridPane.add(new Label("Thema:"), 0, ++row);
        this.gridPane.add(this.txtTheme, 1, row);
        this.gridPane.add(this.btnTheme, 2, row);
        this.gridPane.add(this.btnClearTheme, 3, row);
        this.gridPane.add(this.tgTheme, 1, ++row);
        this.gridPane.add(new Label("Thema-Titel:"), 0, ++row);
        this.gridPane.add(this.txtThemeTitle, 1, row);
        this.gridPane.add(this.btnClearThemeTitel, 3, row);
        this.gridPane.add(new Label("Titel:"), 0, ++row);
        this.gridPane.add(this.txtTitle, 1, row);
        this.gridPane.add(this.btnTitel, 2, row);
        this.gridPane.add(this.btnClearTitel, 3, row);
    }
}

