/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.panesetdata;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneSetName {
    private final TextField txtVisibleName = new TextField("");
    private final TextArea txtDescription = new TextArea("");
    private ChangeListener<String> changeListener;
    private SetData setData = null;
    private final ObjectProperty<SetData> setDataObjectProperty;

    PaneSetName(Stage stage, ObjectProperty<SetData> setDataObjectProperty) {
        this.setDataObjectProperty = setDataObjectProperty;
    }

    public void close() {
        this.unBindProgData();
        for (int i = 0; i < ProgData.getInstance().setDataList.size(); ++i) {
            SetData sd = (SetData)ProgData.getInstance().setDataList.get(i);
            if (!sd.getVisibleName().trim().isEmpty()) continue;
            sd.setVisibleName("Set " + (i + 1));
        }
    }

    public void makePane(Collection<TitledPane> result) {
        this.changeListener = (observable2, oldValue, newValue) -> ProgData.getInstance().setDataList.setListChanged();
        VBox vBox = new VBox(10.0);
        vBox.setFillWidth(true);
        vBox.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Einstellungen", vBox);
        result.add(tpConfig);
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        gridPane.add(new Label("Set Name:"), 0, 0);
        gridPane.add(this.txtVisibleName, 1, 0);
        gridPane.add(new Label("Beschreibung:"), 0, 1);
        gridPane.add(this.txtDescription, 1, 1);
        for (int i = 0; i < gridPane.getRowCount(); ++i) {
            RowConstraints rowC = new RowConstraints();
            rowC.setValignment(VPos.CENTER);
            gridPane.getRowConstraints().add(rowC);
        }
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        this.setDataObjectProperty.addListener((u, o, n) -> {
            tpConfig.setDisable(this.setDataObjectProperty.getValue() == null);
            this.bindProgData();
        });
        tpConfig.setDisable(this.setDataObjectProperty.getValue() == null);
        this.bindProgData();
    }

    private void bindProgData() {
        this.unBindProgData();
        this.setData = (SetData)this.setDataObjectProperty.getValue();
        if (this.setData != null) {
            this.txtVisibleName.textProperty().bindBidirectional(this.setData.visibleNameProperty());
            this.txtVisibleName.textProperty().addListener(this.changeListener);
            this.txtDescription.textProperty().bindBidirectional(this.setData.descriptionProperty());
        }
    }

    private void unBindProgData() {
        if (this.setData != null) {
            this.txtVisibleName.textProperty().unbindBidirectional(this.setData.visibleNameProperty());
            this.txtVisibleName.textProperty().removeListener(this.changeListener);
            this.txtVisibleName.setText("");
            this.txtDescription.textProperty().unbindBidirectional(this.setData.descriptionProperty());
            this.txtDescription.setText("");
        }
        this.setData = null;
    }
}

