/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.panesetdata;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.controller.data.setdata.SetFactory;
import de.p2tools.mtplayer.controller.data.setdata.SetImportFactory;
import de.p2tools.mtplayer.gui.configdialog.panesetdata.SetDataTableContextMenu;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2GuiTools;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PaneSetList
extends VBox {
    private final TableView<SetData> tableView = new TableView();
    static int newCounter = 1;
    private final Stage stage;
    private final ProgData progData;
    private final ObjectProperty<SetData> setDataObjectProperty;
    private Callback<TableColumn<SetData, String>, TableCell<SetData, String>> cellFactoryName = param -> {
        TableCell<SetData, String> cell = new TableCell<SetData, String>(){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                SetData setData = (SetData)this.getTableView().getItems().get(this.getIndex());
                Label lbl = new Label(setData.getVisibleName());
                if (setData.isPlay()) {
                    lbl.getStyleClass().add("markSetPlay");
                } else {
                    lbl.getStyleClass().removeAll((String[])new String[]{"markSetPlay"});
                }
                this.setGraphic(lbl);
            }
        };
        return cell;
    };

    public PaneSetList(Stage stage, ObjectProperty<SetData> setDataObjectProperty) {
        this.stage = stage;
        this.setDataObjectProperty = setDataObjectProperty;
        this.progData = ProgData.getInstance();
        this.make();
    }

    public void close() {
        this.progData.setDataList.getUndoList().clear();
        this.progData.setDataList.forEach(setData -> setData.getProgramList().getUndoList().clear());
    }

    public Optional<SetData> getSel(boolean show) {
        int selectedTableRow = this.tableView.getSelectionModel().getSelectedIndex();
        if (selectedTableRow >= 0) {
            return Optional.of((SetData)this.tableView.getSelectionModel().getSelectedItem());
        }
        if (show) {
            P2Alert.showInfoNoSelection(this.stage);
        }
        return Optional.empty();
    }

    private void make() {
        VBox vBox = new VBox(10.0);
        vBox.setFillWidth(true);
        this.initTable(vBox);
        this.initButton(vBox);
        TitledPane tpSet = new TitledPane("Sets", vBox);
        tpSet.setMaxHeight(Double.MAX_VALUE);
        tpSet.setCollapsible(false);
        VBox.setVgrow(tpSet, Priority.ALWAYS);
        this.getChildren().addAll((Node[])new Node[]{tpSet});
    }

    private void initTable(VBox vBox) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        scrollPane.setContent(this.tableView);
        vBox.getChildren().addAll((Node[])new Node[]{scrollPane});
        VBox.setVgrow(scrollPane, Priority.ALWAYS);
        TableColumn visibleNameColumn = new TableColumn("Name");
        visibleNameColumn.setCellValueFactory(new PropertyValueFactory("visibleName"));
        visibleNameColumn.setCellFactory(this.cellFactoryName);
        this.tableView.getColumns().addAll(visibleNameColumn);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableView.setItems(this.progData.setDataList);
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                Optional<SetData> optionalSetData = this.getSel(false);
                SetData setData = optionalSetData.orElse(null);
                ContextMenu contextMenu = new SetDataTableContextMenu(this.progData).getContextMenu(setData);
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.getSelectionModel().selectedItemProperty().addListener((u, o, n) -> this.setDataObjectProperty.setValue((SetData)n));
        this.progData.setDataList.listChangedProperty().addListener((u, o, n) -> this.tableView.refresh());
        this.setDataObjectProperty.setValue((SetData)this.tableView.getSelectionModel().getSelectedItem());
        this.tableView.getSelectionModel().selectFirst();
    }

    private void initButton(VBox vBox) {
        Button btnDel = new Button("");
        btnDel.setTooltip(new Tooltip("Markiertes Set l\u00f6schen"));
        btnDel.setGraphic(ProgIcons.ICON_BUTTON_REMOVE.getImageView());
        btnDel.setOnAction(event -> {
            SetData setData = this.getSelectedSelData();
            if (setData != null) {
                this.progData.setDataList.addDataToUndoList(setData);
                this.progData.setDataList.removeSetData(setData);
            }
        });
        Button btnNew = new Button("");
        btnNew.setTooltip(new Tooltip("Ein neues Set anlegen"));
        btnNew.setGraphic(ProgIcons.ICON_BUTTON_ADD.getImageView());
        btnNew.setOnAction(event -> {
            SetData setData = new SetData("Neu-" + ++newCounter);
            this.progData.setDataList.addSetData(setData);
        });
        Button btnUp = new Button("");
        btnUp.setTooltip(new Tooltip("Markiertes Set nach oben schieben"));
        btnUp.setGraphic(ProgIcons.ICON_BUTTON_MOVE_UP.getImageView());
        btnUp.setOnAction(event -> {
            int sel = this.getSelectedLine();
            if (sel >= 0) {
                int newSel = this.progData.setDataList.up(sel, true);
                this.tableView.getSelectionModel().select(newSel);
            }
        });
        Button btnDown = new Button("");
        btnDown.setTooltip(new Tooltip("Markiertes Set nach unten schieben"));
        btnDown.setGraphic(ProgIcons.ICON_BUTTON_MOVE_DOWN.getImageView());
        btnDown.setOnAction(event -> {
            int sel = this.getSelectedLine();
            if (sel >= 0) {
                int newSel = this.progData.setDataList.up(sel, false);
                this.tableView.getSelectionModel().select(newSel);
            }
        });
        Button btnDup = new Button("_Duplizieren");
        btnDup.setTooltip(new Tooltip("Eine Kopie des markierten Sets erstellen"));
        btnDup.setOnAction(event -> {
            SetData setData = this.getSelectedSelData();
            if (setData != null) {
                this.progData.setDataList.addSetData(setData.getCopy());
            }
        });
        btnDup.setMaxWidth(Double.MAX_VALUE);
        Button btnNewSet = new Button("Standardsets _anf\u00fcgen");
        btnNewSet.setTooltip(new Tooltip("Standardsets erstellen und der Liste anf\u00fcgen"));
        btnNewSet.setOnAction(event -> {
            if (!SetImportFactory.getStandardSet(this.stage)) {
                P2Alert.showErrorAlert(this.stage, "Set importieren", "Set konnten nicht importiert werden!");
            }
        });
        btnNewSet.setMaxWidth(Double.MAX_VALUE);
        Button btnCheck = new Button("_Pr\u00fcfen");
        btnCheck.setTooltip(new Tooltip("Die angelegten Sets \u00fcberpr\u00fcfen"));
        btnCheck.setOnAction(event -> SetFactory.checkPrograms(this.stage, this.progData, true));
        btnCheck.setMaxWidth(Double.MAX_VALUE);
        Button btnHelp = P2Button.helpButton(this.stage, "Set", "Ein Set ist ein Satz von Einstellungen mit dem ein Film angesehen oder gespeichert werden kann. Im Set k\u00f6nnen Hilfsprogramme angegeben werden, die den Film weiter verarbeiten k\u00f6nnen z.B. herunterladen, abspielen, konvertieren,\u2026\n\nMTPlayer ben\u00f6tigt mindestens ein Set zum Abspielen und eins zum Aufzeichnen. Diese zwei Sets werden beim ersten Programmstart mit Standardeinstellungen angelegt.\n\n-- Set-Funktionen --\nDie Funktion eines Sets kann im Kontextmen\u00fc der Tabelle oder in \"Funktionen\" angegeben werden.\n\n\"Abspielen\" ruft ein Programm zum Ansehen der Filme auf. Es kann nur ein Set daf\u00fcr zust\u00e4ndig sein. In der Tabelle erscheint das Set zum Abspielen in roter Schrift.\n\n\"Speichern\" ist f\u00fcr das Speichern eines Films zust\u00e4ndig. Wenn mehrere Sets zum Speichern angelegt sind, muss f\u00fcr jeden Film in einem Dialog das Set ausgew\u00e4hlt werden.\n\n\"Abo\": Wenn Abos genutzt werden, muss daf\u00fcr ein Set bereitstehen, bei dem dies eingeschaltet ist. In der Regel eignet sich das Set \"Speichern\" auch f\u00fcr die Abos, es muss also meist f\u00fcr die Abos kein eigenes Set angelegt werden. Beim Speichern-Set wird dann \"Speichern\" und \"Abo\" eingeschaltet.\n\n\"Button\" stellt einen Button f\u00fcr dieses Set in der Ansicht \"Filme\" zur Verf\u00fcgung (unter der Tabelle, im Tab \"Startbutton\"). Mit dem Button kann dann direkt ein Film aus der Filmtabelle mit diesem Set gestartet werden.\n\nSoll ein Film mit einem Set aufgezeichnet werden, m\u00fcssen [Zielpfad] und [Zieldateiname] in \"Speicherziel\" ausgef\u00fcllt werden.");
        HBox hBoxButton = new HBox(5.0);
        hBoxButton.getChildren().addAll((Node[])new Node[]{btnNew, btnDel, P2GuiTools.getHBoxGrower(), btnUp, btnDown});
        HBox hBoxHelp = new HBox();
        hBoxHelp.setAlignment(Pos.CENTER_RIGHT);
        hBoxHelp.getChildren().add(btnHelp);
        VBox vb = new VBox(5.0);
        vb.getChildren().addAll((Node[])new Node[]{hBoxButton, btnDup, btnNewSet, btnCheck, P2GuiTools.getVBoxGrower(), hBoxHelp});
        vBox.getChildren().addAll((Node[])new Node[]{vb});
    }

    private int getSelectedLine() {
        int sel = this.tableView.getSelectionModel().getSelectedIndex();
        if (sel < 0) {
            P2Alert.showInfoNoSelection(this.stage);
        }
        return sel;
    }

    private SetData getSelectedSelData() {
        SetData sel = (SetData)this.tableView.getSelectionModel().getSelectedItem();
        if (sel == null) {
            P2Alert.showInfoNoSelection(this.stage);
        }
        return sel;
    }
}

