/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.panesetdata;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneSetFunction {
    private final Button btnPlay = new Button("Abspielen setzen");
    private final P2ToggleSwitch tglSave = new P2ToggleSwitch("Speichern:");
    private final P2ToggleSwitch tglButton = new P2ToggleSwitch("Button:");
    private final P2ToggleSwitch tglAbo = new P2ToggleSwitch("Abo:");
    private final ColorPicker colorPicker = new ColorPicker();
    private final Label lblPlay = new Label("Abspielen:");
    private ChangeListener changeListener;
    private final Stage stage;
    private final ProgData progData;
    private SetData setData = null;
    private final ObjectProperty<SetData> setDataObjectProperty;

    PaneSetFunction(Stage stage, ObjectProperty<SetData> setDataObjectProperty) {
        this.stage = stage;
        this.progData = ProgData.getInstance();
        this.setDataObjectProperty = setDataObjectProperty;
    }

    public void close() {
        this.unBindProgData();
    }

    public void makePane(Collection<TitledPane> result) {
        this.changeListener = (observable2, oldValue, newValue) -> ProgData.getInstance().setDataList.setListChanged();
        VBox vBox = new VBox(10.0);
        vBox.setFillWidth(true);
        vBox.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Funktionen", vBox);
        result.add(tpConfig);
        this.btnPlay.setTooltip(new Tooltip("Dieses Set zum Abspielen ausw\u00e4hlen"));
        this.btnPlay.setOnAction(event -> {
            this.progData.setDataList.setPlay((SetData)this.setDataObjectProperty.getValue());
            this.playSetText();
        });
        this.playSetText();
        int row = 0;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        gridPane.add(new Label("Funktionen des Sets:"), 0, row, 3, 1);
        HBox hBox = new HBox(15.0);
        HBox hBoxSpace = new HBox();
        HBox.setHgrow(hBoxSpace, Priority.ALWAYS);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().addAll((Node[])new Node[]{this.lblPlay, hBoxSpace, this.btnPlay});
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(hBox, 1, row);
        gridPane.add(P2Button.helpButton(this.stage, "Funktion des Sets", "\"Abspielen\" ruft ein Programm zur Wiedergabe auf, wenn ein Film zum Abspielen gestartet wird. Es kann nur ein Set daf\u00fcr zust\u00e4ndig sein."), 2, row);
        gridPane.add(this.tglSave, 1, ++row);
        gridPane.add(P2Button.helpButton(this.stage, "Funktion des Sets", "\"Speichern\" ist f\u00fcr das Speichern eines Films zust\u00e4ndig. Wenn mehrere Sets zum Speichern angelegt sind, muss f\u00fcr jeden Film in einem Dialog das Set ausgew\u00e4hlt werden."), 2, row);
        gridPane.add(this.tglAbo, 1, ++row);
        gridPane.add(P2Button.helpButton(this.stage, "Funktion des Sets", "\"Abo\": Wenn Abos genutzt werden, muss daf\u00fcr ein Set bereitstehen, bei dem dies eingeschaltet ist.\n\nIn der Regel eignet sich das Set \"Speichern\" auch f\u00fcr die Abos, es muss also meist f\u00fcr die Abos kein eigenes Set angelegt werden. Bei diesem Set (Speichern-Set) wird dann also  \"Speichern\" und \"Abo\" eingeschaltet."), 2, row);
        gridPane.add(this.tglButton, 1, ++row);
        gridPane.add(P2Button.helpButton(this.stage, "Funktion des Sets", "\"Button\" stellt einen Button f\u00fcr dieses Set in der Ansicht \"Filme\" zur Verf\u00fcgung (unter der Tabelle, im Tab \"Startbutton\"), mit dem es direkt aus der Filmtabelle gestartet werden kann."), 2, row);
        this.colorPicker.setOnAction(a -> this.progData.pEventHandler.notifyListener(PEvents.EVENT_FILM_BUTTON_CHANGED));
        Label lblColor = new Label("Farbe:");
        Button btnResetColor = new Button("_Standardfarbe");
        btnResetColor.setOnAction(event -> {
            ((SetData)this.setDataObjectProperty.getValue()).setColor(SetData.RESET_COLOR);
            this.progData.pEventHandler.notifyListener(PEvents.EVENT_FILM_BUTTON_CHANGED);
        });
        Button btnHelpColor = P2Button.helpButton(this.stage, "Schriftfarbe ausw\u00e4hlen", "Wenn das Set in der Ansicht \"Filme\" als Button gestartet werden kann (\"Button\" im Set ist eingeschaltet), kann hier die Schriftfarbe des Buttons festgelegt werden.\n");
        lblColor.disableProperty().bind(this.tglButton.selectedProperty().not());
        this.colorPicker.disableProperty().bind(this.tglButton.selectedProperty().not());
        btnResetColor.disableProperty().bind(this.tglButton.selectedProperty().not());
        HBox hBoxColor = new HBox(10.0);
        hBoxColor.getChildren().addAll((Node[])new Node[]{lblColor, this.colorPicker, btnResetColor});
        hBoxColor.setAlignment(Pos.CENTER_LEFT);
        gridPane.add(hBoxColor, 1, ++row);
        gridPane.add(btnHelpColor, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        this.setDataObjectProperty.addListener((u, o, n) -> {
            tpConfig.setDisable(this.setDataObjectProperty.getValue() == null);
            this.bindProgData();
        });
        tpConfig.setDisable(this.setDataObjectProperty.getValue() == null);
        this.bindProgData();
    }

    private void playSetText() {
        if (this.setData != null && this.setData.isPlay()) {
            this.lblPlay.getStyleClass().add("markSetPlay");
        } else {
            this.lblPlay.getStyleClass().removeAll((String[])new String[]{"markSetPlay"});
        }
    }

    private void bindProgData() {
        this.unBindProgData();
        this.setData = (SetData)this.setDataObjectProperty.getValue();
        if (this.setData != null) {
            this.playSetText();
            this.tglSave.selectedProperty().bindBidirectional(this.setData.saveProperty());
            this.tglAbo.selectedProperty().bindBidirectional(this.setData.aboProperty());
            this.tglButton.selectedProperty().bindBidirectional(this.setData.buttonProperty());
            this.tglButton.selectedProperty().addListener(this.changeListener);
            this.colorPicker.valueProperty().bindBidirectional(this.setData.colorProperty());
            this.colorPicker.valueProperty().addListener(this.changeListener);
        }
    }

    private void unBindProgData() {
        if (this.setData != null) {
            this.playSetText();
            this.tglSave.selectedProperty().unbindBidirectional(this.setData.saveProperty());
            this.tglAbo.selectedProperty().unbindBidirectional(this.setData.aboProperty());
            this.tglButton.selectedProperty().unbindBidirectional(this.setData.buttonProperty());
            this.tglButton.selectedProperty().removeListener(this.changeListener);
            this.colorPicker.valueProperty().unbindBidirectional(this.setData.colorProperty());
            this.colorPicker.valueProperty().removeListener(this.changeListener);
        }
    }
}

