/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.panesetdata;

import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneSetDownload {
    private final TextField txtPrefix = new TextField();
    private final TextField txtSuffix = new TextField();
    private final RadioButton rbHd = new RadioButton("Film in HD laden");
    private final RadioButton rbHeight = new RadioButton("Film in hoher Aufl\u00f6sung laden");
    private final RadioButton rbLow = new RadioButton("Film in kleiner Aufl\u00f6sung laden");
    private final P2ToggleSwitch tglInfo = new P2ToggleSwitch("Infodatei anlegen: \"Filmname.txt\"");
    private final P2ToggleSwitch tglSubtitle = new P2ToggleSwitch("Untertitel speichern: \"Filmname.xxx\"");
    private final Stage stage;
    private SetData setData = null;
    private final ObjectProperty<SetData> setDataObjectProperty;

    PaneSetDownload(Stage stage, ObjectProperty<SetData> setDataObjectProperty) {
        this.stage = stage;
        this.setDataObjectProperty = setDataObjectProperty;
    }

    public void close() {
        this.unBindProgData();
    }

    public void makePane(Collection<TitledPane> result) {
        VBox vBox = new VBox(25.0);
        vBox.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Download", vBox);
        result.add(tpConfig);
        this.makePraef(vBox);
        this.makeResolution(vBox);
        this.makeInfo(vBox);
        this.setDataObjectProperty.addListener((u, o, n) -> {
            tpConfig.setDisable(this.setDataObjectProperty.getValue() == null);
            this.bindProgData();
        });
        tpConfig.setDisable(this.setDataObjectProperty.getValue() == null);
        this.bindProgData();
    }

    private void makePraef(VBox vBox) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        Button btnHelpPrefix = P2Button.helpButton(this.stage, "Direkt speichern", "Wenn die URL eines Films mit <Pr\u00e4fix> beginnt bzw. mit <Suffix> endet wird der Film von MTPlayer selbst geladen und nicht mit einem Hilfsprogramm gespeichert.\n\nMehrere Eintr\u00e4ge sind m\u00f6glich, wenn sie durch Kommas getrennt sind (z.B. 'mp4,mp3,m4v,m4a').\n");
        Label lbl = new Label("Direkt Speichern (Download durch dieses Programm):");
        int row = 0;
        gridPane.add(lbl, 0, row, 2, 1);
        gridPane.add(btnHelpPrefix, 2, row);
        gridPane.add(new Label("Pr\u00e4fix (z.B. http):"), 0, ++row);
        gridPane.add(this.txtPrefix, 1, row);
        gridPane.add(new Label("Suffix (z.B. mp4,mp3):"), 0, ++row);
        gridPane.add(this.txtSuffix, 1, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }

    private void makeResolution(VBox vBox) {
        ToggleGroup tg = new ToggleGroup();
        this.rbHd.setToggleGroup(tg);
        this.rbHeight.setToggleGroup(tg);
        this.rbLow.setToggleGroup(tg);
        this.rbHd.setOnAction(event -> this.setResolution());
        this.rbHeight.setOnAction(event -> this.setResolution());
        this.rbLow.setOnAction(event -> this.setResolution());
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        Button btnHelpRes = P2Button.helpButton(this.stage, "Aufl\u00f6sung", "Nicht jede Aufl\u00f6sung wird von jedem Sender angeboten. Wenn die gew\u00fcnschte Aufl\u00f6sung nicht verf\u00fcgbar ist wird automatisch die hohe Aufl\u00f6sung heruntergeladen.\n\nDie Aufl\u00f6sung gilt nur f\u00fcr manuell gestartete Downloads und zum Abspielen von Filmen. F\u00fcr Abos wird die im Abo ausgew\u00e4hlte Aufl\u00f6sung verwendet.\n");
        int row = 0;
        gridPane.add(this.rbHd, 0, ++row);
        gridPane.add(btnHelpRes, 1, row, 1, 2);
        gridPane.add(this.rbHeight, 0, ++row);
        gridPane.add(this.rbLow, 0, ++row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrowRight()});
    }

    private void makeInfo(VBox vBox) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        int row = 0;
        gridPane.add(this.tglInfo, 0, ++row);
        gridPane.add(this.tglSubtitle, 0, ++row);
        vBox.getChildren().add(gridPane);
    }

    private void setResolution() {
        if (this.rbHeight.isSelected()) {
            ((SetData)this.setDataObjectProperty.getValue()).setResolution("normal");
        }
        if (this.rbHd.isSelected()) {
            ((SetData)this.setDataObjectProperty.getValue()).setResolution("hd");
        }
        if (this.rbLow.isSelected()) {
            ((SetData)this.setDataObjectProperty.getValue()).setResolution("small");
        }
    }

    private void bindProgData() {
        this.unBindProgData();
        this.setData = (SetData)this.setDataObjectProperty.getValue();
        if (this.setData != null) {
            this.txtPrefix.textProperty().bindBidirectional(this.setData.prefixProperty());
            this.txtSuffix.textProperty().bindBidirectional(this.setData.suffixProperty());
            switch (this.setData.getResolution()) {
                case "hd": {
                    this.rbHd.setSelected(true);
                    break;
                }
                case "small": {
                    this.rbLow.setSelected(true);
                    break;
                }
                default: {
                    this.rbHeight.setSelected(true);
                }
            }
            this.tglInfo.selectedProperty().bindBidirectional(this.setData.infoFileProperty());
            this.tglSubtitle.selectedProperty().bindBidirectional(this.setData.subtitleProperty());
        }
    }

    private void unBindProgData() {
        if (this.setData != null) {
            this.txtPrefix.textProperty().unbindBidirectional(this.setData.prefixProperty());
            this.txtSuffix.textProperty().unbindBidirectional(this.setData.suffixProperty());
            this.txtPrefix.setText("");
            this.txtSuffix.setText("");
            this.tglInfo.selectedProperty().unbindBidirectional(this.setData.infoFileProperty());
            this.tglSubtitle.selectedProperty().unbindBidirectional(this.setData.subtitleProperty());
        }
    }
}

