/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.panesetdata;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.gui.configdialog.panesetdata.AboSubDir;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2ComboBoxObject;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneSetDestination {
    private final P2ToggleSwitch tglSubdir = new P2ToggleSwitch("Bei Abos Unterordner anlegen:");
    private final P2ComboBoxObject<AboSubDir.ENSubDir> cboDest = new P2ComboBoxObject();
    private final TextField txtDestPath = new TextField();
    private final TextField txtDestName = new TextField();
    private final Slider slCut = new Slider();
    private final Slider slCutField = new Slider();
    private boolean changeTgl = false;
    private final Stage stage;
    private SetData setData = null;
    private final ObjectProperty<SetData> setDataObjectProperty;

    PaneSetDestination(Stage stage, ObjectProperty<SetData> setDataObjectProperty) {
        this.stage = stage;
        this.setDataObjectProperty = setDataObjectProperty;
    }

    public void close() {
        this.unBindProgData();
    }

    public void makePane(Collection<TitledPane> result) {
        VBox vBox = new VBox(25.0);
        vBox.setFillWidth(true);
        vBox.setPadding(new Insets(10.0));
        TitledPane titledPane = new TitledPane("Speicherziel", vBox);
        result.add(titledPane);
        Button btnFile = new Button();
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.setTooltip(new Tooltip("Einen Ordner zum Speichern der Filme ausw\u00e4hlen"));
        btnFile.setOnAction(event -> P2DirFileChooser.DirChooser(ProgData.getInstance().primaryStage, this.txtDestPath));
        Button btnHelSubDir = P2Button.helpButton(this.stage, "Unterordner anlegen", "Downloads aus Abos werden in einem Abo-eigenen Unterordner gespeichert, wenn hier \"bei Abos Unterordner anlegen\" eingeschaltet ist. Der Name des Unterordners kann mit dem Auswahlmen\u00fc festgelegt werden.\n\nDiese Einstellung wird \u00fcberschrieben, wenn im Abo ein eigener Abozielpfad angegeben ist. Der Download wird dann immer in einem Unterordner mit dem im Abozielpfad angegebenen Namen gespeichert.\n");
        Button btnHelpDestName = P2Button.helpButton(this.stage, "Zieldateiname", "Diese Parameter sind m\u00f6glich:\n\n%D Sendedatum des Films, wenn leer von 'heute'\n%d Sendezeit des Films, wenn leer von 'jetzt'\n%H 'heute', aktuelles Datum im Format JJJJMMTT, z.B. '20090815' am 15.08.2009\n%h 'jetzt', aktuelle Uhrzeit im Format HHMMss, z.B. '152059' um 15:20:59 Uhr\n\n%1 Tag, vom Sendedatum des Films, wenn leer von 'heute'\n%2 Monat, ebenso\n%3 Jahr, ebenso\n\n%4 Stunde, von der Sendezeit des Films, wenn leer von 'jetzt'\n%5 Minute, ebenso\n%6 Sekunde, ebenso\n\n%s Sender des Films\n%T Titel des Films\n%t Thema des Films\n\n%N Originaldateiname des Films (der kann sehr kryptisch und lang sein)\n%S Suffix des Originaldateinamens des Films (z.B. 'mp4')\n\n%i Filmnummer (\u00e4ndert sich beim Neuladen der Filmliste!)\n%q Qualit\u00e4t des Films ('HD', 'H', 'L')\n\n%Z Hashwert der URL, z.B.: '1433245578'\n%z Hashwert der URL, angeh\u00e4ngtes Suffix (entspricht '%Z.%S'), z.B.: '1433245578.mp4'\n\n\nIm Set kann eine maximale L\u00e4nge eines \"Elements\". z.B. %T und die maximale L\u00e4nge des gesamten Namens vorgegeben werden. Ist ein \"Element\" oder der gesamte Name l\u00e4nger, wird gek\u00fcrzt.\n\nBeispiele:\nAm 10.05.2021 liefert '%H__%t__%T' z.B. '20210510__Natur__Wildes Shetland' (kein Suffix)\nund '%H__%t__%T.%S' liefert z.B. '20210510__Natur__Wildes Shetland.xxx' (mit dem Originalsuffix)");
        this.cboDest.init(FXCollections.observableArrayList(AboSubDir.ENSubDir.values()));
        this.cboDest.getSelValueProperty().addListener((m, o, n) -> {
            if (this.changeTgl) {
                this.tglSubdir.setSelected(true);
            }
            if (this.setDataObjectProperty.getValue() != null && this.cboDest.getSelValue() != null) {
                ((SetData)this.setDataObjectProperty.getValue()).setAboSubDir_ENSubDirNo(this.cboDest.getSelValue().getNo());
            }
        });
        this.cboDest.setMaxWidth(Double.MAX_VALUE);
        this.cboDest.disableProperty().bind(this.tglSubdir.selectedProperty().not());
        int row = 0;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        gridPane.add(this.tglSubdir, 0, row, 2, 1);
        gridPane.add(btnHelSubDir, 2, row);
        gridPane.add(new Label("Ordnername:"), 0, ++row);
        gridPane.add(this.cboDest, 1, row);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(new Label("Zielpfad:"), 0, ++row);
        gridPane.add(this.txtDestPath, 1, row);
        gridPane.add(btnFile, 2, row);
        gridPane.add(new Label("Zieldateiname:"), 0, ++row);
        gridPane.add(this.txtDestName, 1, row);
        gridPane.add(btnHelpDestName, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        this.makeCut(vBox);
        this.setDataObjectProperty.addListener((u, o, n) -> {
            titledPane.setDisable(this.setDataObjectProperty.getValue() == null);
            this.bindProgData();
        });
        this.bindProgData();
        titledPane.setDisable(this.setDataObjectProperty.getValue() == null);
    }

    private void makeCut(VBox vBox) {
        Label lblTxtAll = new Label("L\u00e4nge\nganzer Dateiname:");
        Label lblSizeAll = new Label();
        Label lblTxtField = new Label("L\u00e4nge\neinzelne Felder:");
        Label lblSizeField = new Label();
        Button btnHelpDestSize = P2Button.helpButton(this.stage, "L\u00e4nge des Zieldateinamens", "Die L\u00e4nge des Dateinamens eines Downloads kann beschr\u00e4nkt werden.\n\n\"L\u00e4nge des ganzen Dateinamens:\" Der gesamte Dateiname wird ermittelt und falls n\u00f6tig gek\u00fcrzt.\n\n\"L\u00e4nge einzelner Felder:\" Die L\u00e4nge einzelner Felder (Parameter) des Dateinamens wird begrenzt.\nDas bezieht sich nur auf die Felder mit variabler L\u00e4nge:\n%t, %T, %s, %N (Thema, Titel, Sender, Originaldateiname).\n");
        this.slCut.setMin(0.0);
        this.slCut.setMax(200.0);
        this.slCut.setShowTickLabels(true);
        this.slCut.setMinorTickCount(50);
        this.slCut.setMajorTickUnit(100.0);
        this.slCut.setBlockIncrement(10.0);
        this.slCut.setSnapToTicks(true);
        this.slCutField.setMin(0.0);
        this.slCutField.setMax(100.0);
        this.slCutField.setShowTickLabels(true);
        this.slCutField.setMinorTickCount(25);
        this.slCutField.setMajorTickUnit(50.0);
        this.slCutField.setBlockIncrement(10.0);
        this.slCutField.setSnapToTicks(true);
        this.setValueSlider(this.slCut, lblSizeAll, "");
        this.slCut.valueProperty().addListener((observable2, oldValue, newValue) -> this.setValueSlider(this.slCut, lblSizeAll, ""));
        this.setValueSlider(this.slCutField, lblSizeField, "");
        this.slCutField.valueProperty().addListener((observable2, oldValue, newValue) -> this.setValueSlider(this.slCutField, lblSizeField, ""));
        GridPane.setValignment(btnHelpDestSize, VPos.CENTER);
        GridPane.setValignment(lblTxtAll, VPos.CENTER);
        GridPane.setValignment(lblSizeAll, VPos.CENTER);
        GridPane.setValignment(this.slCutField, VPos.CENTER);
        GridPane.setValignment(lblTxtField, VPos.CENTER);
        GridPane.setValignment(lblSizeField, VPos.CENTER);
        GridPane.setValignment(this.slCutField, VPos.CENTER);
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        int row = 0;
        gridPane.add(lblTxtAll, 0, ++row);
        gridPane.add(this.slCut, 1, row);
        gridPane.add(lblSizeAll, 2, row);
        gridPane.add(btnHelpDestSize, 3, row);
        ++row;
        gridPane.add(lblTxtField, 0, ++row);
        gridPane.add(this.slCutField, 1, row);
        gridPane.add(lblSizeField, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }

    private void setValueSlider(Slider sl, Label lb, String pre) {
        int days = (int)sl.getValue();
        lb.setText(pre + (String)(days == 0 ? "nicht\nbeschr\u00e4nken" : "auf " + days + "\nZeichen beschr\u00e4nken"));
    }

    private void bindProgData() {
        this.unBindProgData();
        this.setData = (SetData)this.setDataObjectProperty.getValue();
        if (this.setData != null) {
            this.tglSubdir.selectedProperty().bindBidirectional(this.setData.genAboSubDirProperty());
            this.txtDestPath.textProperty().bindBidirectional(this.setData.destPathProperty());
            this.txtDestName.textProperty().bindBidirectional(this.setData.destNameProperty());
            this.slCut.valueProperty().bindBidirectional(this.setData.maxSizeProperty());
            this.slCutField.valueProperty().bindBidirectional(this.setData.maxFieldProperty());
            this.cboDest.getSelectionModel().select(this.setData.getAboSubDir_ENSubDir());
            this.changeTgl = true;
        }
    }

    private void unBindProgData() {
        this.changeTgl = false;
        if (this.setData != null) {
            this.tglSubdir.selectedProperty().unbindBidirectional(this.setData.genAboSubDirProperty());
            this.txtDestPath.textProperty().unbindBidirectional(this.setData.destPathProperty());
            this.txtDestName.textProperty().unbindBidirectional(this.setData.destNameProperty());
            this.txtDestPath.setText("");
            this.txtDestName.setText("");
            this.slCut.valueProperty().unbindBidirectional(this.setData.maxSizeProperty());
            this.slCutField.valueProperty().unbindBidirectional(this.setData.maxFieldProperty());
        }
    }
}

