/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.paneblacklist;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackList;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2GuiTools;
import javafx.beans.property.BooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PanelMoveButton {
    PanelMoveButton() {
    }

    static void addMoveButton(Stage stage, VBox vBox, TableView<BlackData> tableView, ProgData progData, boolean controlBlackListNotFilmFilter, BooleanProperty blackDataChanged, BlackList list) {
        Button btnHelpCount = P2Button.helpButton(stage, "Filter kopieren oder verschieben", "Beim \"Kopieren\" oder \"Verschieben\" werden die markierten Filter in den anderen Filmfilter \"Filme laden\" oder \"Blacklist\" kopiert oder verschoben.");
        Button btnCopy = new Button(controlBlackListNotFilmFilter ? "_Kopieren nach \"Filmliste laden\"" : "_Kopieren nach \"Blacklist\"");
        btnCopy.setTooltip(new Tooltip("Damit werden die markierten Filter in den anderen Filter (Filmfilter/Blacklist) kopiert"));
        btnCopy.setOnAction(a -> {
            ObservableList selected = tableView.getSelectionModel().getSelectedItems();
            if (selected == null || selected.isEmpty()) {
                P2Alert.showInfoNoSelection();
            } else {
                for (BlackData bl : selected) {
                    BlackData cpy = bl.getCopy();
                    if (controlBlackListNotFilmFilter) {
                        progData.filmListFilter.addAll(cpy);
                        continue;
                    }
                    blackDataChanged.set(true);
                    progData.blackList.addAll(cpy);
                }
            }
        });
        Button btnMove = new Button(controlBlackListNotFilmFilter ? "_Verschieben zu \"Filmliste laden\"" : "_Verschieben zu \"Blacklist\"");
        btnMove.setTooltip(new Tooltip("Damit werden die markierten Filter in den anderen Filter (Filmfilter/Blacklist) verschoben"));
        btnMove.setOnAction(a -> {
            ObservableList selected = tableView.getSelectionModel().getSelectedItems();
            if (selected == null || selected.isEmpty()) {
                P2Alert.showInfoNoSelection();
            } else {
                blackDataChanged.set(true);
                if (controlBlackListNotFilmFilter) {
                    progData.filmListFilter.addAll(selected);
                } else {
                    progData.blackList.addAll(selected);
                }
                list.removeAll(selected);
                tableView.getSelectionModel().clearSelection();
            }
        });
        Button btnLoad = new Button("_Filmliste mit diesen Einstellungen neu laden");
        btnLoad.setTooltip(new Tooltip("Eine komplette neue Filmliste laden.\nGe\u00e4nderte Einstellungen f\u00fcr das Laden der Filmliste werden so sofort \u00fcbernommen"));
        btnLoad.setOnAction(event -> progData.loadFilmListWorker.loadNewListFromWeb(true));
        HBox hBoxButton = new HBox(5.0);
        if (!controlBlackListNotFilmFilter) {
            hBoxButton.getChildren().addAll((Node[])new Node[]{btnLoad});
        }
        hBoxButton.getChildren().addAll((Node[])new Node[]{P2GuiTools.getHBoxGrower(), btnCopy, btnMove, btnHelpCount});
        VBox.setVgrow(tableView, Priority.ALWAYS);
        VBox vb = new VBox(5.0);
        vb.getChildren().addAll((Node[])new Node[]{hBoxButton});
        vBox.getChildren().add(vb);
    }
}

