/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.update.SearchProgramUpdate;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneUpdate {
    private final P2ToggleSwitch tglSearch = new P2ToggleSwitch("Einmal am Tag nach einer neuen Programmversion suchen");
    private final P2ToggleSwitch tglSearchBeta = new P2ToggleSwitch("Auch nach neuen Vorabversionen suchen");
    private final CheckBox chkDaily = new CheckBox("Zwischenschritte (Dailys) mit einbeziehen");
    private final Button btnNow = new Button("_Jetzt suchen");
    private Button btnHelpBeta;
    private final P2ToggleSwitch tglEnableLog = new P2ToggleSwitch("Ein Logfile anlegen:");
    private final Stage stage;
    private final ProgData progData;

    public PaneUpdate(Stage stage) {
        this.stage = stage;
        this.progData = ProgData.getInstance();
    }

    public void close() {
        this.tglEnableLog.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_LOG_ON);
        this.tglSearch.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_SEARCH_UPDATE);
        this.tglSearchBeta.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_UPDATE_SEARCH_BETA);
        this.chkDaily.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_UPDATE_SEARCH_DAILY);
    }

    public void make(Collection<TitledPane> result) {
        VBox vBox = new VBox(5.0);
        vBox.setPadding(new Insets(10.0));
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(0.0));
        this.tglSearch.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SEARCH_UPDATE);
        Button btnHelp = P2Button.helpButton(this.stage, "Programmupdate suchen", "Beim Programmstart wird gepr\u00fcft, ob es eine neue Version des Programms gibt. Ist eine aktualisierte Version vorhanden, dann wird das gemeldet." + P2LibConst.LINE_SEPARATOR + "Das Programm wird aber nicht ungefragt ersetzt.");
        this.tglSearchBeta.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_UPDATE_SEARCH_BETA);
        this.chkDaily.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_UPDATE_SEARCH_DAILY);
        this.btnHelpBeta = P2Button.helpButton(this.stage, "Vorabversionen suchen", "Beim Programmstart wird gepr\u00fcft, ob es eine neue Vorabversion des Programms gibt. " + P2LibConst.LINE_SEPARATORx2 + "Das sind \"Zwischenschritte\" auf dem Weg zur n\u00e4chsten Version. Hier ist die Entwicklung noch nicht abgeschlossen und das Programm kann noch Fehler enthalten. Wer Lust hat einen Blick auf die n\u00e4chste Version zu werfen, ist eingeladen, die Vorabversionen zu testen." + P2LibConst.LINE_SEPARATORx2 + "Ist eine aktualisierte Vorabversion vorhanden, dann wird das gemeldet." + P2LibConst.LINE_SEPARATOR + "Das Programm wird aber nicht ungefragt ersetzt.");
        this.checkBeta();
        this.tglSearch.selectedProperty().addListener((ob, ol, ne) -> this.checkBeta());
        this.tglSearchBeta.selectedProperty().addListener((ob, ol, ne) -> this.checkBeta());
        this.btnNow.setOnAction(event -> new SearchProgramUpdate(this.progData).searchNewProgramVersion(this.stage, true, false));
        P2Hyperlink hyperlink = new P2Hyperlink("https://www.p2tools.de/mtplayer/", ProgConfig.SYSTEM_PROG_OPEN_URL);
        int row = 0;
        gridPane.add(this.tglSearch, 0, row);
        gridPane.add(btnHelp, 1, row);
        gridPane.add(this.tglSearchBeta, 0, ++row);
        gridPane.add(this.btnHelpBeta, 1, row);
        gridPane.add(this.chkDaily, 0, ++row, 2, 1);
        GridPane.setHalignment(this.chkDaily, HPos.RIGHT);
        ++row;
        ++row;
        gridPane.add(this.btnNow, 0, ++row, 3, 1);
        GridPane.setHalignment(this.btnNow, HPos.RIGHT);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        HBox hBoxHyper = new HBox();
        hBoxHyper.setAlignment(Pos.CENTER_LEFT);
        hBoxHyper.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        hBoxHyper.setSpacing(10.0);
        hBoxHyper.getChildren().addAll((Node[])new Node[]{new Label("Infos auch auf der Website:"), hyperlink});
        vBox.getChildren().addAll((Node[])new Node[]{gridPane, P2GuiTools.getVBoxGrower(), hBoxHyper});
        TitledPane tpConfig = new TitledPane("Programmupdate", vBox);
        result.add(tpConfig);
    }

    private void checkBeta() {
        this.tglSearchBeta.setDisable(!this.tglSearch.isSelected());
        this.btnHelpBeta.setDisable(!this.tglSearch.isSelected());
        if (!this.tglSearchBeta.isSelected()) {
            this.chkDaily.setSelected(false);
        }
        this.chkDaily.setDisable(!this.tglSearchBeta.isSelected() || this.tglSearchBeta.isDisabled());
    }
}

