/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PaneStatusBar {
    private final Stage stage;
    private final P2ToggleSwitch tglOn = new P2ToggleSwitch("Statusleiste anzeigen");
    private final P2ToggleSwitch tglSelOn = new P2ToggleSwitch("Anzeige der Anzahl der markierten Zeilen");
    private final P2ToggleSwitch tglLeftOn = new P2ToggleSwitch("Anzeige des Infobereichs links");
    private final P2ToggleSwitch tglDotOn = new P2ToggleSwitch("Anzeige eines Farbpunktes f\u00fcr den Zustand der Downloads");
    private final P2ToggleSwitch tglRightOn = new P2ToggleSwitch("Anzeige der Infos \u00fcber die Filmliste");
    private final GridPane gridPane = new GridPane();

    public PaneStatusBar(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.tglOn.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_ON);
        this.tglSelOn.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.tglLeftOn.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.tglDotOn.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.tglRightOn.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
    }

    public void make(Collection<TitledPane> result) {
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Statusleiste", this.gridPane);
        result.add(tpConfig);
        this.make();
    }

    private void make() {
        this.tglOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_ON);
        this.tglSelOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.tglLeftOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.tglDotOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.tglRightOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        Button btnHelp = P2Button.helpButton(this.stage, "Statusleiste anpassen", "Hier kann die Statusleiste ein-/ausgeschaltet werden. Die angezeigten Infos k\u00f6nnen ein-/ausgeschaltet werden.\n\nDer Farbpunkt zeigt den Zustand der Downloads an:\n  Der Farbpunkt blinkt: Es sind noch nicht gestartete Downloads vorhanden\n  Der Farbpunkt ist gr\u00fcn: Es sind fertige Downloads vorhanden\n  Der Farbpunkt ist rot: Es sind Downloads mit Fehler vorhanden\n  Der Farbpunkt ist grau: Es sind keine fertigen oder fehlerhaften Downloads vorhanden");
        int row = 0;
        this.gridPane.add(this.tglOn, 0, row);
        this.gridPane.add(btnHelp, 1, row);
        ++row;
        this.gridPane.add(this.tglSelOn, 0, ++row);
        this.gridPane.add(this.tglLeftOn, 0, ++row);
        this.gridPane.add(this.tglDotOn, 0, ++row);
        this.gridPane.add(this.tglRightOn, 0, ++row);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }
}

