/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.download.ReplaceData;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.ptable.P2CellCheckBox;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2lib.mtfilter.FilterCheckRegEx;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneReplace {
    private final TextField txtFrom = new TextField();
    private final TextField txtTo = new TextField();
    private final CheckBox chkActive = new CheckBox();
    private final CheckBox chkStop = new CheckBox();
    private final Label lblStop = new Label();
    private final Label lblActive = new Label();
    private final GridPane gridPane = new GridPane();
    private final TableView<ReplaceData> tableView = new TableView();
    private final ObjectProperty<ReplaceData> replaceDateProp = new SimpleObjectProperty<Object>(null);
    private final P2ToggleSwitch tglAscii = new P2ToggleSwitch("Nur ASCII-Zeichen erlauben");
    private final P2ToggleSwitch tglReplace = new P2ToggleSwitch("Ersetzungstabelle");
    private final Stage stage;

    public PaneReplace(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        ProgData.getInstance().replaceList.getUndoList().clear();
        this.unbindText();
        this.tglAscii.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_ONLY_ASCII);
        this.tglReplace.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_USE_REPLACETABLE);
    }

    public void makeReplaceListTable(Collection<TitledPane> result) {
        VBox vBox = new VBox(10.0);
        vBox.setFillWidth(true);
        vBox.setPadding(new Insets(10.0));
        this.makeAscii(vBox);
        this.initTable(vBox);
        this.initBtn(vBox);
        this.addConfigs(vBox);
        TitledPane tpReplace = new TitledPane("Ersetzungstabelle", vBox);
        result.add(tpReplace);
        tpReplace.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(tpReplace, Priority.ALWAYS);
    }

    private void makeAscii(VBox vBox) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        vBox.getChildren().add(gridPane);
        Button btnHelp = P2Button.helpButton(this.stage, "Ersetzungstabelle", "Datei- und Pfadnamen werden f\u00fcr Downloads nach den Vorgaben des Sets oder Abos erstellt. Danach wird die Ersetzungstabelle abgearbeitet. Hier k\u00f6nnen dann noch unerw\u00fcnschte Zeichen entfernt werden.\n\n## Nur ASCII-Zeichen ##\nEs werden alle Zeichen \u00fcber ASCII 127 ersetzt. Umlaute werden aufgel\u00f6st (z.B. '\u00f6' -> 'oe'). Wenn die Ersetzungstabelle aktiv ist, wird sie vorher abgearbeitet.\n\n## Ersetzungstabelle ##\nDie Tabelle wird von oben nach unten abgearbeitet. Es ist also m\u00f6glich, dass eine Ersetzung durch eine weitere ganz oder teilweise r\u00fcckg\u00e4ngig gemacht wird!\n\nIn der Ersetzungstabelle wird Gro\u00df- und Kleinschreibung beachtet.\n\n# Aktiv #\nEs werden nur Eintr\u00e4ge verwendet, die \"Aktiv\" sind.\n\n# Abbrechen nach Treffer #\nHat ein Eintrag \"Abbrechen nach Treffer\", wird beim Abarbeiten der Liste (von oben nach unten und wenn der Eintrag ein Treffer ist) hier abgebrochen, die weiteren Eintr\u00e4ge in der Liste werden also nicht mehr angewendet.\n\nRegEx: Im Feld \"Von\" sind auch RegEx erlaubt. Diese m\u00fcssen mit \"#:\" eingeleitet werden. Z.B.:\n#:[+]\nersetzt alle \"+\" Zeichen mit dem angegebenen \"Nach\" Zeichen.\n");
        this.tglAscii.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_ONLY_ASCII);
        this.tglReplace.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_USE_REPLACETABLE);
        gridPane.add(this.tglAscii, 0, 0);
        gridPane.add(btnHelp, 1, 0, 1, 2);
        GridPane.setValignment(btnHelp, VPos.TOP);
        gridPane.add(this.tglReplace, 0, 1);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }

    private void initTable(VBox vBox) {
        TableColumn fromColumn = new TableColumn("Von");
        fromColumn.setCellValueFactory(new PropertyValueFactory("from"));
        TableColumn toColumn = new TableColumn("Nach");
        toColumn.setCellValueFactory(new PropertyValueFactory("to"));
        TableColumn activeColumn = new TableColumn("Aktiv");
        activeColumn.setCellValueFactory(new PropertyValueFactory("active"));
        activeColumn.setCellFactory(new P2CellCheckBox<S, T>().cellFactory);
        TableColumn stopColumn = new TableColumn("Abbrechen nach Treffer");
        stopColumn.setCellValueFactory(new PropertyValueFactory("stop"));
        stopColumn.setCellFactory(new P2CellCheckBox<S, T>().cellFactory);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.setMinHeight(200.0);
        this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.tableView.getColumns().addAll(fromColumn, toColumn, activeColumn, stopColumn);
        this.tableView.setItems(ProgData.getInstance().replaceList);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> Platform.runLater(this::setActReplaceData));
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                ContextMenu contextMenu = this.getContextMenu();
                this.tableView.setContextMenu(contextMenu);
            }
        });
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setContent(this.tableView);
        this.tableView.disableProperty().bind(ProgConfig.SYSTEM_USE_REPLACETABLE.not());
        VBox.setVgrow(scrollPane, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{scrollPane});
    }

    private void initBtn(VBox vBox) {
        this.chkActive.selectedProperty().addListener((u, o, n) -> this.setLblText());
        this.chkStop.selectedProperty().addListener((u, o, n) -> this.setLblText());
        FilterCheckRegEx regEx = new FilterCheckRegEx(this.txtFrom);
        this.txtFrom.textProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            regEx.checkPattern();
        });
        Button btnDel = new Button("");
        btnDel.setTooltip(new Tooltip("Eintrag l\u00f6schen"));
        btnDel.setGraphic(ProgIcons.ICON_BUTTON_REMOVE.getImageView());
        btnDel.setOnAction(event -> {
            ObservableList sels = this.tableView.getSelectionModel().getSelectedItems();
            if (sels == null || sels.isEmpty()) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                ProgData.getInstance().replaceList.addDataToUndoList(sels);
                ProgData.getInstance().replaceList.removeAll(sels);
                this.tableView.getSelectionModel().clearSelection();
            }
        });
        Button btnNew = new Button("");
        btnNew.setTooltip(new Tooltip("Einen neuen Eintrag erstellen"));
        btnNew.setGraphic(ProgIcons.ICON_BUTTON_ADD.getImageView());
        btnNew.setOnAction(event -> {
            ReplaceData replaceData = new ReplaceData();
            ProgData.getInstance().replaceList.add(replaceData);
            this.tableView.getSelectionModel().clearSelection();
            this.tableView.getSelectionModel().select(replaceData);
            this.tableView.scrollTo(replaceData);
        });
        Button btnUp = new Button("");
        btnUp.setTooltip(new Tooltip("Eintrag nach oben schieben"));
        btnUp.setGraphic(ProgIcons.ICON_BUTTON_MOVE_UP.getImageView());
        btnUp.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                int res = ProgData.getInstance().replaceList.up(sel, true);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(res);
                this.tableView.scrollTo(res);
            }
        });
        Button btnDown = new Button("");
        btnDown.setTooltip(new Tooltip("Eintrag nach unten schieben"));
        btnDown.setGraphic(ProgIcons.ICON_BUTTON_MOVE_DOWN.getImageView());
        btnDown.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                int res = ProgData.getInstance().replaceList.up(sel, false);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(res);
                this.tableView.scrollTo(res);
            }
        });
        Button btnTop = new Button();
        btnTop.setTooltip(new Tooltip("Eintrag an den Anfang verschieben"));
        btnTop.setGraphic(ProgIcons.ICON_BUTTON_MOVE_TOP.getImageView());
        btnTop.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                int res = ProgData.getInstance().replaceList.top(sel, true);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(res);
                this.tableView.scrollTo(res);
            }
        });
        Button btnBottom = new Button();
        btnBottom.setTooltip(new Tooltip("Eintrag an das Ende verschieben"));
        btnBottom.setGraphic(ProgIcons.ICON_BUTTON_MOVE_BOTTOM.getImageView());
        btnBottom.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                int res = ProgData.getInstance().replaceList.top(sel, false);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(res);
                this.tableView.scrollTo(res);
            }
        });
        Button btnReset = new Button("_Tabelle zur\u00fccksetzen");
        btnReset.setTooltip(new Tooltip("Alle Eintr\u00e4ge l\u00f6schen und Standardeintr\u00e4ge wieder herstellen"));
        btnReset.setOnAction(event -> ProgData.getInstance().replaceList.init());
        HBox hBox = new HBox();
        hBox.setSpacing(5.0);
        hBox.disableProperty().bind(ProgConfig.SYSTEM_USE_REPLACETABLE.not());
        hBox.getChildren().addAll((Node[])new Node[]{btnNew, btnDel, P2GuiTools.getVDistance(10), btnTop, btnUp, btnDown, btnBottom, P2GuiTools.getHBoxGrower(), btnReset});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
    }

    private ContextMenu getContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem miUndo = new MenuItem("Gel\u00f6schte wieder anlegen");
        miUndo.setOnAction(a -> ProgData.getInstance().replaceList.undoData());
        miUndo.setDisable(ProgData.getInstance().replaceList.getUndoList().isEmpty());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miUndo});
        return contextMenu;
    }

    private void addConfigs(VBox vBox) {
        this.gridPane.getStyleClass().add("extra-pane");
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(10.0));
        int row = 0;
        this.gridPane.add(new Label("Von: "), 0, row);
        this.gridPane.add(this.txtFrom, 1, row);
        this.gridPane.add(new Label("Nach: "), 0, ++row);
        this.gridPane.add(this.txtTo, 1, row);
        this.gridPane.setAlignment(Pos.CENTER_RIGHT);
        this.gridPane.add(new Label("Aktiv:"), 0, ++row);
        HBox hBox = new HBox(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.chkActive, this.lblActive});
        this.gridPane.add(hBox, 1, row);
        this.gridPane.add(new Label("Abbrechen:"), 0, ++row);
        hBox = new HBox(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.chkStop, this.lblStop});
        this.gridPane.add(hBox, 1, row);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        vBox.getChildren().add(this.gridPane);
        this.gridPane.setDisable(true);
        this.gridPane.disableProperty().bind(Bindings.createBooleanBinding(() -> this.replaceDateProp.getValue() == null, this.replaceDateProp).or(ProgConfig.SYSTEM_USE_REPLACETABLE.not()));
    }

    private void setActReplaceData() {
        ReplaceData replaceDataAct = (ReplaceData)this.tableView.getSelectionModel().getSelectedItem();
        if (replaceDataAct == this.replaceDateProp.getValue()) {
            return;
        }
        this.unbindText();
        this.replaceDateProp.setValue(replaceDataAct);
        if (this.replaceDateProp.getValue() != null) {
            this.txtFrom.textProperty().bindBidirectional(((ReplaceData)this.replaceDateProp.getValue()).fromProperty());
            this.txtTo.textProperty().bindBidirectional(((ReplaceData)this.replaceDateProp.getValue()).toProperty());
            this.chkActive.selectedProperty().bindBidirectional(((ReplaceData)this.replaceDateProp.getValue()).activeProperty());
            this.chkStop.selectedProperty().bindBidirectional(((ReplaceData)this.replaceDateProp.getValue()).stopProperty());
        }
        this.setLblText();
    }

    private void unbindText() {
        if (this.replaceDateProp.getValue() != null) {
            this.txtFrom.textProperty().unbindBidirectional(((ReplaceData)this.replaceDateProp.getValue()).fromProperty());
            this.txtTo.textProperty().unbindBidirectional(((ReplaceData)this.replaceDateProp.getValue()).toProperty());
            this.chkActive.selectedProperty().unbindBidirectional(((ReplaceData)this.replaceDateProp.getValue()).activeProperty());
            this.chkStop.selectedProperty().unbindBidirectional(((ReplaceData)this.replaceDateProp.getValue()).stopProperty());
        }
        this.txtFrom.setText("");
        this.txtTo.setText("");
        this.chkActive.setSelected(false);
        this.chkStop.setSelected(false);
    }

    private void setLblText() {
        if (this.replaceDateProp.getValue() != null) {
            this.lblStop.setText(((ReplaceData)this.replaceDateProp.getValue()).isStop() ? "Bei einem Treffer wird hier abgebrochen" : "");
            this.lblActive.setText(((ReplaceData)this.replaceDateProp.getValue()).isActive() ? "" : "Der Eintrag wird nicht verwendet");
        } else {
            this.lblStop.setText("");
            this.lblActive.setText("");
        }
    }
}

