/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.MTPlayerFactory;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PaneIcon {
    private final P2ToggleSwitch tglOwnProgIcon = new P2ToggleSwitch("Ein eigenes Programmicon anzeigen");
    private final TextField txtProgIconPath = new TextField();
    private final P2ToggleSwitch tglTray = new P2ToggleSwitch("Programm im System Tray anzeigen");
    private final P2ToggleSwitch tglOwnTrayIcon = new P2ToggleSwitch("Ein eigenes Icon anzeigen");
    private final TextField txtTrayIconPath = new TextField();
    private final Stage stage;

    public PaneIcon(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.tglOwnProgIcon.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_USE_OWN_PROGRAM_ICON);
        this.txtProgIconPath.textProperty().unbindBidirectional(ProgConfig.SYSTEM_PROGRAM_ICON_PATH);
        this.tglTray.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_TRAY);
        this.tglOwnTrayIcon.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_TRAY_USE_OWN_ICON);
        this.txtTrayIconPath.textProperty().unbindBidirectional(ProgConfig.SYSTEM_TRAY_ICON_PATH);
    }

    public void make(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        TitledPane tpConfig = new TitledPane("Programm Icons", gridPane);
        result.add(tpConfig);
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        int row = 0;
        row = this.addProgIcon(gridPane, row);
        gridPane.add(new Label(), 0, ++row);
        gridPane.add(new Label(), 0, ++row);
        this.addTryIcon(gridPane, ++row);
    }

    private int addProgIcon(GridPane gridPane, int row) {
        this.tglOwnProgIcon.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_USE_OWN_PROGRAM_ICON);
        Button btnHelpProgramIcon = P2Button.helpButton(this.stage, "Eigenes Bild als Programmicon anzeigen", "Das verwendete Programmicon kann damit ge\u00e4ndert werden. Damit kann ein eigens Bild daf\u00fcr verwendet werden.\n");
        GridPane.setHalignment(btnHelpProgramIcon, HPos.RIGHT);
        Button btnProgIconFile = new Button();
        btnProgIconFile.setTooltip(new Tooltip("Eine Programmicon ausw\u00e4hlen"));
        btnProgIconFile.setOnAction(event -> {
            String s = P2DirFileChooser.FileChooserSelect(ProgData.getInstance().primaryStage, "", "");
            if (!s.isEmpty()) {
                this.txtProgIconPath.setText(s);
            }
        });
        btnProgIconFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        this.txtProgIconPath.textProperty().bindBidirectional(ProgConfig.SYSTEM_PROGRAM_ICON_PATH);
        this.tglOwnProgIcon.selectedProperty().addListener((v, o, n) -> MTPlayerFactory.setProgramIcon());
        this.txtProgIconPath.textProperty().addListener((v, o, n) -> MTPlayerFactory.setProgramIcon());
        btnProgIconFile.disableProperty().bind(this.tglOwnProgIcon.selectedProperty().not());
        this.txtProgIconPath.disableProperty().bind(this.tglOwnProgIcon.selectedProperty().not());
        Label lblIcon = new Label("Datei (png, jpg):");
        lblIcon.disableProperty().bind(this.tglOwnProgIcon.selectedProperty().not());
        gridPane.add(this.tglOwnProgIcon, 0, row, 2, 1);
        gridPane.add(btnHelpProgramIcon, 2, row);
        gridPane.add(lblIcon, 0, ++row);
        gridPane.add(this.txtProgIconPath, 1, row);
        gridPane.add(btnProgIconFile, 2, row);
        return row;
    }

    private int addTryIcon(GridPane gridPane, int row) {
        this.tglTray.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_TRAY);
        Button btnHelpTray = P2Button.helpButton(this.stage, "Programm im System Tray anzeigen", "Im System Tray wird f\u00fcr das Programm ein Symbol angezeigt. Damit kann das Programm auf dem Desktop ausgeblendet werden.\n");
        GridPane.setHalignment(btnHelpTray, HPos.RIGHT);
        this.tglOwnTrayIcon.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_TRAY_USE_OWN_ICON);
        this.tglOwnTrayIcon.disableProperty().bind(this.tglTray.selectedProperty().not());
        Button btnHelpTrayOwnIcon = P2Button.helpButton(this.stage, "Eigenes Bild im Tray anzeigen", "Im System Tray wird f\u00fcr das Programm ein Symbol angezeigt. Damit kann ein eigens Bild daf\u00fcr verwendet werden.\n");
        GridPane.setHalignment(btnHelpTrayOwnIcon, HPos.RIGHT);
        btnHelpTrayOwnIcon.disableProperty().bind(this.tglTray.selectedProperty().not());
        Button btnTrayFile = new Button();
        btnTrayFile.setTooltip(new Tooltip("Eine Datei f\u00fcr das Icon ausw\u00e4hlen"));
        btnTrayFile.setOnAction(event -> {
            String s = P2DirFileChooser.FileChooserSelect(ProgData.getInstance().primaryStage, "", "");
            if (!s.isEmpty()) {
                this.txtTrayIconPath.setText(s);
            }
        });
        btnTrayFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnTrayFile.disableProperty().bind(this.tglOwnTrayIcon.selectedProperty().not().or(this.tglTray.selectedProperty().not()));
        this.txtTrayIconPath.textProperty().bindBidirectional(ProgConfig.SYSTEM_TRAY_ICON_PATH);
        this.txtTrayIconPath.disableProperty().bind(this.tglOwnTrayIcon.selectedProperty().not().or(this.tglTray.selectedProperty().not()));
        Label lblFile = new Label("Datei (png, jpg):");
        lblFile.disableProperty().bind(this.tglOwnTrayIcon.selectedProperty().not().or(this.tglTray.selectedProperty().not()));
        gridPane.add(this.tglTray, 0, row, 2, 1);
        gridPane.add(btnHelpTray, 2, row);
        gridPane.add(this.tglOwnTrayIcon, 0, ++row, 2, 1);
        gridPane.add(btnHelpTrayOwnIcon, 2, row);
        gridPane.add(lblFile, 0, ++row);
        gridPane.add(this.txtTrayIconPath, 1, row);
        gridPane.add(btnTrayFile, 2, row);
        return row;
    }
}

