/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PaneGeo {
    private final RadioButton rbDe = new RadioButton("DE - Deutschland");
    private final RadioButton rbFr = new RadioButton("FR - Frankreich");
    private final RadioButton rbCh = new RadioButton("CH - Schweiz");
    private final RadioButton rbAt = new RadioButton("AT - \u00d6sterreich");
    private final RadioButton rbEu = new RadioButton("EU (EBU - European Broadcasting Union)");
    private final RadioButton rbSonst = new RadioButton("sonst");
    private final P2ToggleSwitch tglGeo = new P2ToggleSwitch("Geblockte Sendungen gelb markieren");
    private final Stage stage;

    public PaneGeo(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.tglGeo.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_MARK_GEO);
    }

    public TitledPane make() {
        return this.make(null);
    }

    public TitledPane make(Collection<TitledPane> result) {
        this.tglGeo.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_MARK_GEO);
        Button btnHelpGeo = P2Button.helpButton(this.stage, "Geogeblockte Filme", "Nicht alle Filme lassen sich aus allen L\u00e4ndern abrufen (Geoblocking). Man kann hier seinen Standort angeben, wenn geblockte Filme in der Liste markiert werden sollen oder um sie per Blacklist auszuschlie\u00dfen.\n\nManche Sender \u00fcberpr\u00fcfen die abfragende URL, so dass man trotz zum Senderland passender Einstellung nicht auf geblockte Downloads zugreifen kann.\n\nEin Downloadversuch geblockter Sendungen bricht sofort ab und der Download wird als 'fehlerhaft' angezeigt.\n\nMTPlayer kennt aber nicht alle Muster f\u00fcr geogeblockte Sendungen. Ob ein fehlerhafter Download auf Geoblocking zur\u00fcckzuf\u00fchren ist zeigt sich beim Klick auf den Link zur Sendung ('zur Website' ganz unten in der Ansicht 'Filme'). Wenn die Sendung auch auf der Website des Senders nicht abgespielt werden kann liegt fast immer Geoblocking vor.\n");
        ToggleGroup tg = new ToggleGroup();
        tg.getToggles().addAll((Toggle[])new Toggle[]{this.rbDe, this.rbFr, this.rbCh, this.rbAt, this.rbEu, this.rbSonst});
        switch ((String)ProgConfig.SYSTEM_GEO_HOME_PLACE.get()) {
            case "FR": {
                this.rbFr.setSelected(true);
                break;
            }
            case "CH": {
                this.rbCh.setSelected(true);
                break;
            }
            case "AT": {
                this.rbAt.setSelected(true);
                break;
            }
            case "EU": {
                this.rbEu.setSelected(true);
                break;
            }
            case "WELT": {
                this.rbSonst.setSelected(true);
                break;
            }
            default: {
                this.rbDe.setSelected(true);
            }
        }
        this.rbDe.setOnAction(e -> ProgConfig.SYSTEM_GEO_HOME_PLACE.setValue("DE"));
        this.rbFr.setOnAction(e -> ProgConfig.SYSTEM_GEO_HOME_PLACE.setValue("FR"));
        this.rbCh.setOnAction(e -> ProgConfig.SYSTEM_GEO_HOME_PLACE.setValue("CH"));
        this.rbAt.setOnAction(e -> ProgConfig.SYSTEM_GEO_HOME_PLACE.setValue("AT"));
        this.rbEu.setOnAction(e -> ProgConfig.SYSTEM_GEO_HOME_PLACE.setValue("EU"));
        this.rbSonst.setOnAction(e -> ProgConfig.SYSTEM_GEO_HOME_PLACE.setValue("WELT"));
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        int row = 0;
        gridPane.add(this.tglGeo, 0, row, 2, 1);
        gridPane.add(btnHelpGeo, 2, row);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(new Label("Mein Standort:"), 0, ++row);
        gridPane.add(this.rbDe, 1, row);
        gridPane.add(this.rbFr, 1, ++row);
        gridPane.add(this.rbCh, 1, ++row);
        gridPane.add(this.rbAt, 1, ++row);
        gridPane.add(this.rbEu, 1, ++row);
        gridPane.add(this.rbSonst, 1, ++row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        TitledPane tpConfig = new TitledPane("Geogeblockte Filme", gridPane);
        if (result != null) {
            result.add(tpConfig);
        }
        return tpConfig;
    }
}

