/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.film.FilmToolsFactory;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.mtfilm.tools.LoadFactoryConst;
import java.util.ArrayList;
import java.util.Collection;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneFilmSender {
    private final Slider slDays = new Slider();
    private final Slider slDuration = new Slider();
    private final Label lblDays = new Label("");
    private final Label lblDuration = new Label("");
    final Button btnClearAll = new Button("_Wieder alle Sender laden");
    private final Stage stage;

    public PaneFilmSender(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.slDays.valueProperty().unbindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_MAX_DAYS);
        this.slDuration.valueProperty().unbindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_MIN_DURATION);
    }

    public TitledPane make(Collection<TitledPane> result) {
        this.initSlider();
        VBox vBox = new VBox(20.0);
        vBox.setPadding(new Insets(10.0));
        this.makeOnly(vBox);
        this.makeSender(vBox);
        TitledPane tpConfig = new TitledPane("Filmliste bereits beim Laden filtern", vBox);
        if (result != null) {
            result.add(tpConfig);
        }
        return tpConfig;
    }

    private void makeOnly(VBox vBox) {
        Button btnHelpDouble = P2Button.helpButton(this.stage, "Filmliste beim Laden filtern", "In der Filmliste sind ~150.000 Filme doppelt enthalten (z.B. bei ARD und BR).\n\nDoppelte k\u00f6nnen bereits beim Laden der Filmliste ausgefiltert werden. Da die Filmliste inzwischen sehr lang ist, w\u00e4re das eine sehr gute Entscheidung. In den Einstellungen kann das auch wieder ge\u00e4ndert werden.\n");
        Button btnHelpDays = P2Button.helpButton(this.stage, "Filmliste beim Laden filtern", "\"Nur Filme der letzten Tage laden\"\nDie Filmliste enth\u00e4lt dann nur Filme aus diesem Zeitraum. Filme ohne Datum sind immer enthalten.\n\n\"Nur Filme mit Mindestl\u00e4nge laden\"\nDie Filmliste enth\u00e4lt dann nur Filme von mindestens dieser Dauer. Filme ohne L\u00e4ngenangabe sind immer enthalten.\n\nBei 'alles laden' sind alle Filme enthalten.\n\nDas Filtern der Filmliste kann bei \u00e4lteren Rechnern mit wenig Speicher hilfreich sein: Bei 'maximal 250 Tage' oder 'mindestens 5 Minuten' ist die Filmliste nur etwa halb so gro\u00df (~300.000 Filme).\n\nAuswirkung hat das Filtern erst nach dem Neuladen der Filmliste.\n");
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(0.0));
        int row = 0;
        gridPane.add(new Label("Nur Filme der letzten Tage laden:"), 0, row, 2, 1);
        gridPane.add(new Label("Filme laden:"), 0, ++row);
        gridPane.add(this.slDays, 1, row);
        gridPane.add(this.lblDays, 2, row);
        gridPane.add(btnHelpDays, 3, row, 1, 2);
        gridPane.add(new Label(), 0, ++row);
        gridPane.add(new Label("Nur Filme mit Mindestl\u00e4nge laden:"), 0, ++row, 2, 1);
        gridPane.add(new Label("Filme laden:"), 0, ++row);
        gridPane.add(this.slDuration, 1, row);
        gridPane.add(this.lblDuration, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        vBox.getChildren().add(gridPane);
    }

    private void makeSender(VBox vBox) {
        Button btnHelpSender = P2Button.helpButton(this.stage, "Filmliste beim Laden filtern", "Filme der markierten Sender werden beim Laden der Filmliste ausgeschlossen.\n\n\nWirksam erst nach dem Neuladen der kompletten Filmliste.\n");
        HBox hBox = new HBox(5.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        Label lbl = new Label("Diese Sender  *nicht*  laden:");
        hBox.getChildren().addAll((Node[])new Node[]{lbl, P2GuiTools.getHBoxGrower(), this.btnClearAll, btnHelpSender});
        vBox.getChildren().add(new Label(" "));
        vBox.getChildren().add(hBox);
        TilePane tilePaneSender = this.getTilePaneSender();
        vBox.getChildren().addAll((Node[])new Node[]{tilePaneSender});
        Button btnLoad = new Button("_Filmliste mit diesen Einstellungen neu laden");
        btnLoad.setTooltip(new Tooltip("Eine komplette neue Filmliste laden.\nGe\u00e4nderte Einstellungen f\u00fcr das Laden der Filmliste werden so sofort \u00fcbernommen"));
        btnLoad.setOnAction(event -> ProgData.getInstance().loadFilmListWorker.loadNewListFromWeb(true));
        hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.getChildren().add(btnLoad);
        vBox.getChildren().addAll((Node[])new Node[]{P2GuiTools.getHDistance(5), hBox});
    }

    private TilePane getTilePaneSender() {
        TilePane tilePaneSender = new TilePane();
        tilePaneSender.setHgap(5.0);
        tilePaneSender.setVgap(5.0);
        ArrayList<String> aListChannel = FilmToolsFactory.getSenderListNotToLoad();
        ArrayList<CheckBox> aListCb = new ArrayList<CheckBox>();
        for (String s : LoadFactoryConst.SENDER) {
            CheckBox cb = new CheckBox(s);
            aListCb.add(cb);
            cb.setSelected(aListChannel.contains(s));
            cb.setOnAction(a -> {
                this.makePropSender(aListCb);
                FilmToolsFactory.checkAllSenderSelectedNotToLoad(this.stage);
            });
            tilePaneSender.getChildren().add(cb);
            TilePane.setAlignment(cb, Pos.CENTER_LEFT);
        }
        this.btnClearAll.setMinWidth(Double.NEGATIVE_INFINITY);
        this.btnClearAll.setOnAction(a -> {
            aListCb.stream().forEach(checkBox -> checkBox.setSelected(false));
            this.makePropSender(aListCb);
        });
        this.checkPropSender(aListCb);
        return tilePaneSender;
    }

    private void initSlider() {
        this.slDays.setMin(0.0);
        this.slDays.setMax(300.0);
        this.slDays.setShowTickLabels(false);
        this.slDays.setMajorTickUnit(100.0);
        this.slDays.setBlockIncrement(5.0);
        this.slDays.valueProperty().bindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_MAX_DAYS);
        this.slDays.valueProperty().addListener((observable2, oldValue, newValue) -> this.setValueSlider());
        this.slDuration.setMin(0.0);
        this.slDuration.setMax(30.0);
        this.slDuration.setShowTickLabels(false);
        this.slDuration.setMajorTickUnit(10.0);
        this.slDuration.setBlockIncrement(1.0);
        this.slDuration.valueProperty().bindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_MIN_DURATION);
        this.slDuration.valueProperty().addListener((observable2, oldValue, newValue) -> this.setValueSlider());
        this.setValueSlider();
    }

    private void setValueSlider() {
        int days = (int)this.slDays.getValue();
        this.lblDays.setText((String)(days == 0 ? "alles laden" : "nur Filme der letzten " + days + " Tage"));
        int duration = (int)this.slDuration.getValue();
        this.lblDuration.setText((String)(duration == 0 ? "alles laden" : "nur Filme mit mindestens " + duration + " Minuten L\u00e4nge"));
    }

    private void checkPropSender(ArrayList<CheckBox> aListCb) {
        boolean noneChecked = true;
        for (CheckBox cb : aListCb) {
            if (!cb.isSelected()) continue;
            noneChecked = false;
            break;
        }
        this.btnClearAll.setDisable(noneChecked);
    }

    private void makePropSender(ArrayList<CheckBox> aListCb) {
        String str = "";
        for (CheckBox cb : aListCb) {
            if (!cb.isSelected()) continue;
            String s = cb.getText();
            str = str.isEmpty() ? s : str + "," + s;
        }
        ProgConfig.SYSTEM_LOAD_NOT_SENDER.setValue(str);
        this.checkPropSender(aListCb);
    }
}

