/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneFilmLoad {
    private final P2ToggleSwitch tglLoad = new P2ToggleSwitch("Beim Programmstart eine neue Filmliste laden");
    private final P2ToggleSwitch tglLoadNewList = new P2ToggleSwitch("Neue Filmlisten sofort laden");
    private final BooleanProperty diacriticChanged;
    private final ProgData progData;
    private final Stage stage;

    public PaneFilmLoad(Stage stage, ProgData progData, BooleanProperty diacriticChanged) {
        this.stage = stage;
        this.diacriticChanged = diacriticChanged;
        this.progData = progData;
    }

    public void close() {
        this.tglLoad.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_ON_PROGRAMSTART);
        this.tglLoadNewList.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_LOAD_NEW_FILMLIST_IMMEDIATELY);
    }

    public TitledPane make(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        this.tglLoad.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_ON_PROGRAMSTART);
        this.tglLoadNewList.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_LOAD_NEW_FILMLIST_IMMEDIATELY);
        Button btnHelpLoad = P2Button.helpButton(this.stage, "Filmliste laden", "Die Filmliste wird beim Programmstart automatisch geladen, wenn sie \u00e4lter als 3 Stunden ist. Sie kann auch \u00fcber den Button \"Filmliste\" aktualisiert werden.\n\nZum Update werden dann nur noch Differenzlisten geladen (diese enthalten nur neu hinzugekommene Filme).\n");
        Button btnHelpNewList = P2Button.helpButton(this.stage, "Filmliste laden", "Wenn es eine neue Filmliste gibt, wird sie automatisch sofort geladen. Die Filmliste wird also sofort aktualisiert wenn es ein Update gibt.\n");
        P2ToggleSwitch tglRemoveDiacritic = new P2ToggleSwitch("Diakritische Zeichen \u00e4ndern");
        tglRemoveDiacritic.setMaxWidth(Double.MAX_VALUE);
        tglRemoveDiacritic.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_REMOVE_DIACRITICS);
        tglRemoveDiacritic.selectedProperty().addListener((u, o, n) -> this.diacriticChanged.setValue(true));
        Button btnHelpDia = P2Button.helpButton(this.stage, "Diakritische Zeichen", "\"Diakritische Zeichen \u00e4ndern\" meint, dass bestimmte Zeichen in den Filmfeldern: \"Titel, Thema und Beschreibung\" angepasst werden. Aus z.B.\n\"\u00e4\u00f6\u00fc \u0144 \u01f9 \u0148 \u00f1 \u1e45 \u0146 \u1e47 \u1e4b \u00e7 \u010d c\" wird dann\n\"\u00e4\u00f6\u00fc n n n n n n n n c c c\".\n\nDas Programm arbeitet dann mit der angepassten Filmliste. Beim Suchen nach Filmen, Downloads und Abos werden die *angepassten Zeichen* in Titel, Thema und Beschreibung verwendet. Dann werden z.B. \"Dvo\u0159ak\", \"No\u00ebl\" und \"Ni\u00f1o\" nicht mehr gefunden, aber stattdessen \"Dvorak\", \"Noel\" und \"Nino\".\n\nBeim Suchen und Anlegen von Abos, muss also klar sein, ob die Funktion ein/ausgeschaltet ist, ob man die Funktion nutzt oder nicht.\n\nDas \u00c4ndern wird sofort nach Beenden des Dialogs gemacht. Sollen Diakritische Zeichen aber wieder eingeschaltet (also angezeigt) werden, muss dazu eine neue Filmliste geladen werden!\n");
        Button btnLoad = new Button("_Filmliste mit diesen Einstellungen neu laden");
        btnLoad.setTooltip(new Tooltip("Eine komplette neue Filmliste laden.\nGe\u00e4nderte Einstellungen f\u00fcr das Laden der Filmliste werden so sofort \u00fcbernommen"));
        btnLoad.setOnAction(event -> this.progData.loadFilmListWorker.loadNewListFromWeb(true));
        Separator sp2 = new Separator();
        sp2.getStyleClass().add("pseperator2");
        sp2.setMinHeight(0.0);
        int row = 0;
        gridPane.add(this.tglLoad, 0, row, 2, 1);
        gridPane.add(btnHelpLoad, 2, row);
        gridPane.add(this.tglLoadNewList, 0, ++row, 2, 1);
        gridPane.add(btnHelpNewList, 2, row);
        gridPane.add(tglRemoveDiacritic, 0, ++row, 2, 1);
        gridPane.add(btnHelpDia, 2, row);
        gridPane.add(new Label(), 0, ++row, 3, 1);
        gridPane.add(btnLoad, 0, ++row, 3, 1);
        GridPane.setHalignment(btnLoad, HPos.RIGHT);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize()});
        HBox hBox = new HBox();
        hBox.getStyleClass().add("extra-pane");
        hBox.setPadding(new Insets(10.0));
        hBox.setMaxWidth(Double.MAX_VALUE);
        hBox.setMinHeight(Double.NEGATIVE_INFINITY);
        hBox.getChildren().add(new Label("\u00c4nderungen in diesem Tab\nwirken sich erst nach dem Neuladen einer Filmliste aus"));
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        vBox.getChildren().addAll((Node[])new Node[]{hBox, gridPane});
        TitledPane tpConfig = new TitledPane("Filmliste laden", vBox);
        result.add(tpConfig);
        return tpConfig;
    }
}

