/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneFilmDouble {
    private final P2ToggleSwitch tglRemove = new P2ToggleSwitch("Doppelte Filme beim Laden der Filmliste ausschlie\u00dfen");
    private final P2ToggleSwitch tglTT = new P2ToggleSwitch("Filme sind nur gleich, wenn auch Thema und Titel gleich sind");
    private final VBox vBox = new VBox(10.0);
    private final ListView<String> lvSender = new ListView();
    private final HBox hBoxButton = new HBox();
    private final Label lblDouble = new Label();
    private final ObservableList<String> selList = FXCollections.observableArrayList();
    private final ProgData progData;
    private final Stage stage;

    public PaneFilmDouble(Stage stage, ProgData progData) {
        this.stage = stage;
        this.progData = progData;
    }

    public void close() {
        this.tglRemove.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_FILMLIST_REMOVE_DOUBLE);
        this.tglTT.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_FILMLIST_DOUBLE_WITH_THEME_TITLE);
    }

    public TitledPane make(Collection<TitledPane> result) {
        this.tglRemove.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_FILMLIST_REMOVE_DOUBLE);
        this.tglTT.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_FILMLIST_DOUBLE_WITH_THEME_TITLE);
        Button btnHelpMark = P2Button.helpButton(this.stage, "Doppelte Filme markieren", "In der Filmliste sind gleiche Filme bei verschiedenen Sendern enthalten. Doppelte Filme werden markiert. Es gibt einen Filmfilter um sie nicht anzuzeigen. Sie k\u00f6nnen auch mit der Blacklist ausgeschlossen werden. Es ist auch m\u00f6glich, sie bereits beim Laden der Filmliste auszuschlie\u00dfen.\n\nHier kann auch eingestellt werden, wann ein Film als Doppelt gilt. Bei doppelten Filmen muss immer die URL des Films gleich sein. Ist die Option \"Thema und Titel\" eingeschaltet, muss der Film zus\u00e4tzlich auch noch das gleiche Thema und den gleichen Titel haben (das ist aber nur bei sehr wenigen Doppelten nicht der Fall).\n\nHier kann vorgegeben werden, welche Sender bevorzugt werden sollen. D.h. Filme dieser Sender werden zuerst genommen. Taucht der gleiche Film bei einem anderen Sendern nochmal auf, wird er dann dort als \"Doppelt\" markiert.\n\nWerden doppelte Filme beim Laden der Filmliste ausgeschlossen, ist bei Abos evtl. zu beachten, dass der Film dann m\u00f6glicherweise von einem anderen Sender kommt.");
        Button btnLoad = new Button("_Filmliste mit diesen Einstellungen neu laden");
        btnLoad.setTooltip(new Tooltip("Eine komplette neue Filmliste laden.\nGe\u00e4nderte Einstellungen f\u00fcr das Laden der Filmliste werden so sofort \u00fcbernommen"));
        btnLoad.setOnAction(event -> this.progData.loadFilmListWorker.loadNewListFromWeb(true));
        Separator sp2 = new Separator();
        sp2.getStyleClass().add("pseperator2");
        sp2.setMinHeight(0.0);
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        int row = 0;
        gridPane.add(this.tglRemove, 0, row);
        gridPane.add(btnHelpMark, 1, row, 1, 2);
        GridPane.setValignment(btnHelpMark, VPos.TOP);
        gridPane.add(this.tglTT, 0, ++row);
        gridPane.add(this.lvSender, 0, ++row, 2, 1);
        gridPane.add(this.hBoxButton, 0, ++row, 2, 1);
        gridPane.add(new Label(), 0, ++row);
        gridPane.add(btnLoad, 0, ++row, 2, 1);
        GridPane.setHalignment(btnLoad, HPos.RIGHT);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize()});
        this.vBox.setPadding(new Insets(10.0));
        this.vBox.getChildren().addAll((Node[])new Node[]{gridPane});
        this.addSenderList();
        TitledPane tpConfig = new TitledPane("Doppelte Filme markieren", this.vBox);
        result.add(tpConfig);
        return tpConfig;
    }

    private void addSenderList() {
        String[] markArr;
        String mark = ProgConfig.SYSTEM_MARK_DOUBLE_CHANNEL_LIST.getValueSafe();
        for (String s : markArr = mark.split(",")) {
            if (s.isEmpty()) continue;
            this.selList.add(s);
        }
        this.lvSender.setItems(this.selList);
        ComboBox<String> cboSender = new ComboBox<String>();
        cboSender.setItems(ThemeListFactory.allChannelList);
        cboSender.getSelectionModel().select(0);
        Button btnAdd = new Button("");
        btnAdd.setTooltip(new Tooltip("Einen neuen Sender hinzuf\u00fcgen"));
        btnAdd.setGraphic(ProgIcons.ICON_BUTTON_ADD.getImageView());
        btnAdd.setOnAction(event -> {
            String str = (String)cboSender.getSelectionModel().getSelectedItem();
            if (str != null && !str.isEmpty() && !this.selList.contains(str)) {
                this.selList.add((String)cboSender.getSelectionModel().getSelectedItem());
                this.lvSender.getSelectionModel().select(str);
            }
            this.addSelList();
        });
        Button btnDel = new Button("");
        btnDel.setTooltip(new Tooltip("Markierten Sender l\u00f6schen"));
        btnDel.setGraphic(ProgIcons.ICON_BUTTON_REMOVE.getImageView());
        btnDel.setOnAction(event -> {
            String str = (String)this.lvSender.getSelectionModel().getSelectedItem();
            if (str != null) {
                this.selList.remove(this.lvSender.getSelectionModel().getSelectedItem());
            }
            this.addSelList();
        });
        Button btnUp = new Button("");
        btnUp.setTooltip(new Tooltip("Markierten Sender nach oben schieben"));
        btnUp.setGraphic(ProgIcons.ICON_BUTTON_MOVE_UP.getImageView());
        btnUp.setOnAction(event -> {
            int sel = this.getSelectedLine();
            if (sel >= 0) {
                int newSel = this.up(sel, true);
                this.lvSender.getSelectionModel().select(newSel);
            }
            this.addSelList();
        });
        Button btnDown = new Button("");
        btnDown.setTooltip(new Tooltip("Markierten Sender nach unten schieben"));
        btnDown.setGraphic(ProgIcons.ICON_BUTTON_MOVE_DOWN.getImageView());
        btnDown.setOnAction(event -> {
            int sel = this.getSelectedLine();
            if (sel >= 0) {
                int newSel = this.up(sel, false);
                this.lvSender.getSelectionModel().select(newSel);
            }
            this.addSelList();
        });
        ProgConfig.SYSTEM_FILMLIST_COUNT_DOUBLE.addListener((u, o, n) -> Platform.runLater(this::setLblDouble));
        this.setLblDouble();
        this.hBoxButton.setSpacing(10.0);
        this.hBoxButton.getChildren().addAll((Node[])new Node[]{cboSender, btnAdd, btnDel, P2GuiTools.getHDistance(20), btnUp, btnDown, P2GuiTools.getHBoxGrower(), new Label("Anzahl Doppelte: "), this.lblDouble});
    }

    private void setLblDouble() {
        this.lblDouble.setText("" + ProgConfig.SYSTEM_FILMLIST_COUNT_DOUBLE.getValue());
    }

    private void addSelList() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String ss : this.selList) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(",");
            }
            stringBuilder.append(ss);
        }
        ProgConfig.SYSTEM_MARK_DOUBLE_CHANNEL_LIST.setValue(stringBuilder.toString());
    }

    private int getSelectedLine() {
        int sel = this.lvSender.getSelectionModel().getSelectedIndex();
        if (sel < 0) {
            P2Alert.showInfoNoSelection(this.stage);
        }
        return sel;
    }

    private int up(int idx, boolean up) {
        String prog = (String)this.selList.remove(idx);
        int newIdx = idx;
        if (up) {
            if (newIdx > 0) {
                --newIdx;
            }
        } else if (newIdx < this.selList.size()) {
            ++newIdx;
        }
        this.selList.add(newIdx, prog);
        return newIdx;
    }
}

