/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.gui.tools.HelpText;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import java.util.Collection;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class PaneDownloadStop {
    private final ToggleGroup groupOnlyStop = new ToggleGroup();
    private final RadioButton rbOnlyStopAsk = new RadioButton("Vorher fragen");
    private final RadioButton rbOnlyStopDelete = new RadioButton("Download immer l\u00f6schen");
    private final ToggleGroup groupDelStop = new ToggleGroup();
    private final RadioButton rbDelStopAsk = new RadioButton("Vorher fragen");
    private final RadioButton rbDelStopDelete = new RadioButton("Download und angefangene Dateien immer l\u00f6schen");
    private final RadioButton rbDelStopNothing = new RadioButton("Download immer l\u00f6schen, keine Dateien l\u00f6schen");
    private final ToggleGroup groupRestart = new ToggleGroup();
    private final RadioButton rbRestartAsk = new RadioButton("Vorher fragen");
    private final RadioButton rbRestartContinue = new RadioButton("Immer weiterf\u00fchren");
    private final RadioButton rbRestartRestart = new RadioButton("Immer neu starten");
    private final Stage stage;

    public PaneDownloadStop(Stage stage) {
        this.stage = stage;
        this.initRadio();
    }

    public void close() {
    }

    public void makeDownload(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        TitledPane tpConfig = new TitledPane("Download stoppen", gridPane);
        result.add(tpConfig);
        Button btnHelpStop = P2Button.helpButton(this.stage, "Download", HelpText.DOWNLOAD_STOP);
        Button btnHelpContinue = P2Button.helpButton(this.stage, "Download", HelpText.DOWNLOAD_CONTINUE);
        GridPane.setHalignment(btnHelpStop, HPos.RIGHT);
        GridPane.setHalignment(btnHelpContinue, HPos.RIGHT);
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        Text text = new Text("Downloads abbrechen oder l\u00f6schen");
        text.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text.getStyleClass().add("downloadGuiMediaText");
        int row = 0;
        gridPane.add(text, 0, row);
        gridPane.add(btnHelpStop, 1, row, 1, 2);
        String LEER = "     ";
        VBox vBox = new VBox(5.0);
        HBox hBox = new HBox(20.0);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("     wenn noch keine geladenen Filme vorhanden sind:")});
        hBox.getChildren().addAll((Node[])new Node[]{new Label("     "), this.rbOnlyStopAsk});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
        hBox = new HBox(20.0);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("     "), this.rbOnlyStopDelete});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
        gridPane.add(vBox, 0, ++row);
        GridPane.setValignment(btnHelpStop, VPos.TOP);
        vBox = new VBox(5.0);
        hBox = new HBox(20.0);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("     wenn schon geladene Filme vorhanden sind:")});
        hBox.getChildren().addAll((Node[])new Node[]{new Label("     "), this.rbDelStopAsk});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
        hBox = new HBox(20.0);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("     "), this.rbDelStopDelete, this.rbDelStopNothing});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
        gridPane.add(vBox, 0, ++row);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("")});
        vBox = new VBox(5.0);
        hBox = new HBox(20.0);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("Beim Neustart bereits angefangener Downloads:")});
        hBox.getChildren().addAll((Node[])new Node[]{new Label("     "), this.rbRestartAsk});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
        hBox = new HBox(20.0);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("     "), this.rbRestartContinue, this.rbRestartRestart});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
        gridPane.add(vBox, 0, ++row);
        gridPane.add(btnHelpContinue, 1, row, 1, 2);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }

    private void initRadio() {
        this.setRadio();
        this.rbOnlyStopAsk.setToggleGroup(this.groupOnlyStop);
        this.rbOnlyStopDelete.setToggleGroup(this.groupOnlyStop);
        this.rbDelStopAsk.setToggleGroup(this.groupDelStop);
        this.rbDelStopDelete.setToggleGroup(this.groupDelStop);
        this.rbDelStopNothing.setToggleGroup(this.groupDelStop);
        this.rbRestartAsk.setToggleGroup(this.groupRestart);
        this.rbRestartContinue.setToggleGroup(this.groupRestart);
        this.rbRestartRestart.setToggleGroup(this.groupRestart);
        ProgConfig.DOWNLOAD_ONLY_STOP.addListener((v, o, n) -> this.setRadio());
        ProgConfig.DOWNLOAD_STOP.addListener((v, o, n) -> this.setRadio());
        ProgConfig.DOWNLOAD_CONTINUE.addListener((v, o, n) -> this.setRadio());
        this.rbOnlyStopAsk.setOnAction(a -> ProgConfig.DOWNLOAD_ONLY_STOP.setValue(0));
        this.rbOnlyStopDelete.setOnAction(a -> ProgConfig.DOWNLOAD_ONLY_STOP.setValue(1));
        this.rbDelStopAsk.setOnAction(a -> ProgConfig.DOWNLOAD_STOP.setValue(0));
        this.rbDelStopDelete.setOnAction(a -> ProgConfig.DOWNLOAD_STOP.setValue(1));
        this.rbDelStopNothing.setOnAction(a -> ProgConfig.DOWNLOAD_STOP.setValue(2));
        this.rbRestartAsk.setOnAction(a -> ProgConfig.DOWNLOAD_CONTINUE.setValue(0));
        this.rbRestartContinue.setOnAction(a -> ProgConfig.DOWNLOAD_CONTINUE.setValue(1));
        this.rbRestartRestart.setOnAction(a -> ProgConfig.DOWNLOAD_CONTINUE.setValue(2));
    }

    private void setRadio() {
        switch (ProgConfig.DOWNLOAD_ONLY_STOP.getValue()) {
            case 1: {
                this.rbOnlyStopDelete.setSelected(true);
                break;
            }
            default: {
                this.rbOnlyStopAsk.setSelected(true);
            }
        }
        switch (ProgConfig.DOWNLOAD_STOP.getValue()) {
            case 1: {
                this.rbDelStopDelete.setSelected(true);
                break;
            }
            case 2: {
                this.rbDelStopNothing.setSelected(true);
                break;
            }
            default: {
                this.rbDelStopAsk.setSelected(true);
            }
        }
        switch (ProgConfig.DOWNLOAD_CONTINUE.getValue()) {
            case 1: {
                this.rbRestartContinue.setSelected(true);
                break;
            }
            case 2: {
                this.rbRestartRestart.setSelected(true);
                break;
            }
            default: {
                this.rbRestartAsk.setSelected(true);
            }
        }
    }
}

