/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.download.DownloadInfosFactory;
import de.p2tools.mtplayer.gui.tools.HelpText;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.awt.Toolkit;
import java.util.Collection;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;

public class PaneDownload {
    private final P2ToggleSwitch tglFinished = new P2ToggleSwitch("Benachrichtigung wenn abgeschlossen");
    private final P2ToggleSwitch tglError = new P2ToggleSwitch("Bei Downloadfehler Fehlermeldung anzeigen");
    private final P2ToggleSwitch tglSSL = new P2ToggleSwitch("SSL-Download-URLs: Bei Problemen SSL abschalten");
    private final P2ToggleSwitch tglBeep = new P2ToggleSwitch("Nach jedem Download einen \"Beep\" ausgeben");
    private final Spinner<Integer> spinnerAnz = new Spinner(1, 9, 1);
    private final Slider sliderBandwidth = new Slider();
    private final Label lblBandwidth = new Label();
    private final Stage stage;

    public PaneDownload(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.tglFinished.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_SHOW_NOTIFICATION);
        this.tglError.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ERROR_SHOW);
        this.tglSSL.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_SSL_ALWAYS_TRUE);
        this.tglBeep.selectedProperty().unbindBidirectional(ProgConfig.DOWNLOAD_BEEP);
        this.sliderBandwidth.valueProperty().unbindBidirectional(ProgConfig.DOWNLOAD_MAX_BANDWIDTH_BYTE);
    }

    public void makeDownload(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        TitledPane tpConfig = new TitledPane("Download", gridPane);
        result.add(tpConfig);
        this.tglFinished.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_SHOW_NOTIFICATION);
        Button btnHelpFinished = P2Button.helpButton(this.stage, "Download", "Wenn ein Download erfolgreich beendet ist, wird mit einem Fenster informiert.\n");
        this.tglError.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_DIALOG_ERROR_SHOW);
        Button btnHelpError = P2Button.helpButton(this.stage, "Download", "Wenn ein Download mit einem Fehler endet, wird mit einem Dialog dar\u00fcber informiert. Die Fehlermeldung wird aber auch zus\u00e4tzlich im Tab \"Downloadfehler\" unter der Tabelle Downloads angezeigt.\n");
        Button btnHelpStop = P2Button.helpButton(this.stage, "Download", HelpText.DOWNLOAD_STOP);
        Button btnHelpContinue = P2Button.helpButton(this.stage, "Download", HelpText.DOWNLOAD_CONTINUE);
        this.tglSSL.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SSL_ALWAYS_TRUE);
        Button btnHelpSSL = P2Button.helpButton(this.stage, "Download", HelpText.DOWNLOAD_SSL_ALWAYS_TRUE);
        this.tglBeep.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_BEEP);
        Button btnBeep = new Button("_Test");
        btnBeep.setOnAction(a -> Toolkit.getDefaultToolkit().beep());
        Button btnBandwidth = P2Button.helpButton(this.stage, "Download", "Mit den Schiebereglern \"gleichzeitige Downloads\" und \"max. Bandbreite\" kann die Anzahl der gleichzeitigen Downloads die geladen werden und die maximale Bandbreite, festgelegt werden.\n\nDie vorgegebene maximale Bandbreite gilt pro Download. Es sind kByte oder MByte pro Sekunde.\n1 MByte\\s braucht eine Internetbandbreite von ~ 10 MBit.\n10 MByte\\s braucht eine Internetbandbreite von ~ 100 MBit.\n\n");
        GridPane.setHalignment(btnHelpFinished, HPos.RIGHT);
        GridPane.setHalignment(btnHelpError, HPos.RIGHT);
        GridPane.setHalignment(btnHelpStop, HPos.RIGHT);
        GridPane.setHalignment(btnHelpContinue, HPos.RIGHT);
        GridPane.setHalignment(btnHelpSSL, HPos.RIGHT);
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        int row = 0;
        gridPane.add(this.tglFinished, 0, ++row, 2, 1);
        gridPane.add(btnHelpFinished, 2, row);
        GridPane.setValignment(btnHelpFinished, VPos.TOP);
        gridPane.add(this.tglError, 0, ++row, 2, 1);
        gridPane.add(btnHelpError, 2, row);
        gridPane.add(this.tglSSL, 0, ++row, 2, 1);
        gridPane.add(btnHelpSSL, 2, row);
        gridPane.add(this.tglBeep, 0, ++row, 2, 1);
        gridPane.add(btnBeep, 2, row);
        GridPane.setHalignment(btnBeep, HPos.RIGHT);
        gridPane.add(new Label(), 0, ++row);
        gridPane.add(new Label("Gleichzeitige Downloads"), 0, ++row);
        gridPane.add(btnBandwidth, 2, row, 1, 2);
        gridPane.add(this.spinnerAnz, 0, ++row);
        Label lblText = new Label("Max. Bandbreite: ");
        lblText.setMinWidth(0.0);
        lblText.setTooltip(new Tooltip("Maximale Bandbreite die ein einzelner Download beanspruchen darf \noder unbegrenzt wenn \"aus\""));
        this.sliderBandwidth.setTooltip(new Tooltip("Maximale Bandbreite die ein einzelner Download beanspruchen darf \noder unbegrenzt wenn \"aus\""));
        HBox hh = new HBox();
        HBox.setHgrow(hh, Priority.ALWAYS);
        HBox h = new HBox();
        h.getChildren().addAll((Node[])new Node[]{lblText, hh, this.lblBandwidth});
        ++row;
        gridPane.add(h, 0, ++row);
        gridPane.add(this.sliderBandwidth, 0, ++row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        this.initNumberDownloads();
        DownloadInfosFactory.initBandwidth(this.sliderBandwidth, this.lblBandwidth);
    }

    private void initNumberDownloads() {
        this.spinnerAnz.valueProperty().addListener((u, o, n) -> ProgConfig.DOWNLOAD_MAX_DOWNLOADS.setValue(this.spinnerAnz.getValue()));
        ProgConfig.DOWNLOAD_MAX_DOWNLOADS.addListener((u, o, n) -> this.spinnerAnz.getValueFactory().setValue(ProgConfig.DOWNLOAD_MAX_DOWNLOADS.getValue()));
        this.spinnerAnz.getValueFactory().setValue(ProgConfig.DOWNLOAD_MAX_DOWNLOADS.getValue());
    }
}

