/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2lib.tools.P2StringUtils;
import java.util.Collection;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PaneConfig {
    private final P2ToggleSwitch tglOnlyOneInstance = new P2ToggleSwitch("Nur eine Instanz des Programms \u00f6ffnen");
    private final P2ToggleSwitch tglStartMaximised = new P2ToggleSwitch("Programm immer \"Maximiert\" starten");
    private final P2ToggleSwitch tglSmallFilm = new P2ToggleSwitch("In der Tabelle \"Film\" nur kleine Button anzeigen:");
    private final P2ToggleSwitch tglSmallDownload = new P2ToggleSwitch("In der Tabelle \"Download\" nur kleine Button anzeigen:");
    private final P2ToggleSwitch tglSmallAbo = new P2ToggleSwitch("In der Tabelle \"Abo\" nur kleine Button anzeigen:");
    private final P2ToggleSwitch tglCheckStart = new P2ToggleSwitch("Einstellungen zum Speichern beim Programmstart pr\u00fcfen:");
    private final P2ToggleSwitch tglTipOfDay = new P2ToggleSwitch("Tip des Tages anzeigen");
    private TextField txtUserAgent;
    private final Stage stage;

    public PaneConfig(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.tglOnlyOneInstance.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_ONLY_ONE_INSTANCE);
        this.tglStartMaximised.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_GUI_START_ALWAYS_MAXIMISED);
        this.tglSmallFilm.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_SMALL_ROW_TABLE_FILM);
        this.tglSmallDownload.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_SMALL_ROW_TABLE_DOWNLOAD);
        this.tglSmallAbo.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_SMALL_ROW_TABLE_ABO);
        this.tglCheckStart.selectedProperty().unbindBidirectional(ProgConfig.CHECK_SET_PROGRAM_START);
        this.tglTipOfDay.selectedProperty().unbindBidirectional(ProgConfig.TIP_OF_DAY_SHOW);
        this.txtUserAgent.textProperty().unbindBidirectional(ProgConfig.SYSTEM_USERAGENT);
    }

    public void make(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Allgemein", gridPane);
        result.add(tpConfig);
        this.tglOnlyOneInstance.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_ONLY_ONE_INSTANCE);
        Button btnHelpOnlyOneInstance = P2Button.helpButton(this.stage, "Nur eine Instanz des Programms \u00f6ffnen", "Werden mehre Instanzen mit dem gleichen Konfig-Ordner ge\u00f6ffnet, \u00fcberschreiben sie ihre Einstellungen. Die Einstellungen der Instanz die zuletzt geschlossen wird, speichert dann die Einstellungen.\n\nUm das zu erkennen, wird im Konfig-Ordner eine Lock-Datei erstellt. Ist diese bei einem weiteren Programmstart bereits vorhanden, wird eine Meldung ausgegeben, dass das Programm bereits l\u00e4uft.\n\n(Es ist m\u00f6glich, das Programm mit unterschiedlichen Konfig-Ordnern zu starten -> Anleitung. Dann kann man mehrere Instanzen parallel mit unterschiedlichen Einstellungen betreiben.)\n");
        GridPane.setHalignment(btnHelpOnlyOneInstance, HPos.RIGHT);
        this.tglStartMaximised.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_GUI_START_ALWAYS_MAXIMISED);
        Button btnHelpStartMaximised = P2Button.helpButton(this.stage, "Programm immer \"Maximiert\" starten", "Das Programmfenster wird immer maximiert gestartet, egal wie die Gr\u00f6\u00dfe beim Beenden war. Ansonsten wird es in der Gr\u00f6\u00dfe gestartet, die es beim Beenden hatte.\n");
        GridPane.setHalignment(btnHelpStartMaximised, HPos.RIGHT);
        this.tglSmallFilm.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SMALL_ROW_TABLE_FILM);
        this.tglSmallDownload.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SMALL_ROW_TABLE_DOWNLOAD);
        this.tglSmallAbo.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SMALL_ROW_TABLE_ABO);
        this.tglCheckStart.selectedProperty().bindBidirectional(ProgConfig.CHECK_SET_PROGRAM_START);
        Button btnHelpSize = P2Button.helpButton(this.stage, "Nur kleine Button anzeigen", "In den Tabellen der Ansichten \"Filme\", \"Downloads\" und \"Abos\" k\u00f6nnen kleinere Buttons gew\u00e4hlt werden, um die Zeilenh\u00f6he zu verringern.\n");
        Button btnHelpCheck = P2Button.helpButton(this.stage, "Download-Einstellungen pr\u00fcfen", "Beim Programmstart werden die Programmeinstellungen zum Ansehen und Aufzeichnen der Filme, gepr\u00fcft. Bei einem Fehler wird eine Meldung angezeigt.\n");
        this.tglTipOfDay.selectedProperty().bindBidirectional(ProgConfig.TIP_OF_DAY_SHOW);
        Button btnHelpTipOfDay = P2Button.helpButton(this.stage, "Tip des Tages anzeigen", "Beim Programmstart wird (einmal t\u00e4glich) ein Tip zur Verwendung des Programms angezeigt. Das passiert so oft, bis alle Tips einmal angezeigt wurden.\n");
        GridPane.setHalignment(btnHelpTipOfDay, HPos.RIGHT);
        Button btnHelpUserAgent = P2Button.helpButton(this.stage, "User Agent festlegen", "Hier kann ein User Agent angegeben werden, der bei Downloads als Absender verwendet wird. Bleibt das Feld leer, wird kein User Agent verwendet.\n\nSolange alles funktioniert, kann das Feld leer bleiben. Ansonsten w\u00e4re das z.B. eine M\u00f6glichkeit: 'Mozilla/5.0'.\n\nEs sind nur ASCII-Zeichen erlaubt und die Textl\u00e4nge ist begrenzt auf 100 Zeichen.\n");
        GridPane.setHalignment(btnHelpUserAgent, HPos.RIGHT);
        this.txtUserAgent = new TextField(){

            @Override
            public void replaceText(int start, int end, String text) {
                if (this.check(text)) {
                    super.replaceText(start, end, text);
                }
            }

            @Override
            public void replaceSelection(String text) {
                if (this.check(text)) {
                    super.replaceSelection(text);
                }
            }

            private boolean check(String text) {
                String str = P2StringUtils.convertToASCIIEncoding(text);
                int size = this.getText().length() + text.length();
                return text.isEmpty() || size < 100 && text.equals(str);
            }
        };
        this.txtUserAgent.textProperty().bindBidirectional(ProgConfig.SYSTEM_USERAGENT);
        int row = 0;
        gridPane.add(this.tglOnlyOneInstance, 0, ++row, 2, 1);
        gridPane.add(btnHelpOnlyOneInstance, 2, row);
        gridPane.add(this.tglStartMaximised, 0, ++row, 2, 1);
        gridPane.add(btnHelpStartMaximised, 2, row);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(this.tglSmallFilm, 0, ++row, 2, 1);
        gridPane.add(btnHelpSize, 2, row, 1, 2);
        gridPane.add(this.tglSmallDownload, 0, ++row, 2, 1);
        gridPane.add(this.tglSmallAbo, 0, ++row, 2, 1);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(this.tglCheckStart, 0, ++row, 2, 1);
        gridPane.add(btnHelpCheck, 2, row);
        GridPane.setHalignment(btnHelpSize, HPos.RIGHT);
        GridPane.setValignment(btnHelpSize, VPos.TOP);
        GridPane.setHalignment(btnHelpCheck, HPos.RIGHT);
        GridPane.setValignment(btnHelpCheck, VPos.CENTER);
        gridPane.add(this.tglTipOfDay, 0, ++row, 2, 1);
        gridPane.add(btnHelpTipOfDay, 2, row);
        gridPane.add(new Label("User Agent:"), 0, ++row);
        gridPane.add(this.txtUserAgent, 1, row);
        gridPane.add(btnHelpUserAgent, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }
}

