/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.configpanes;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.p2lib.colordata.P2ColorData;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2lib.tools.P2ColorFactory;
import java.util.Collection;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PaneColor {
    private final Stage stage;
    private final P2ToggleSwitch tglDarkTheme = new P2ToggleSwitch("Dunkles Erscheinungsbild der Programmoberfl\u00e4che");
    private final P2ToggleSwitch tglBlackWhiteIcon = new P2ToggleSwitch("Schwarz-Wei\u00dfe Icons");
    private final TableView<P2ColorData> tableViewFont = new TableView();
    private final TableView<P2ColorData> tableViewBackground = new TableView();
    private final Callback<TableColumn<P2ColorData, String>, TableCell<P2ColorData, String>> cellFactoryChange = param -> new TableCell<P2ColorData, String>(){

        @Override
        public void updateItem(String item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            P2ColorData pColorData = (P2ColorData)this.getTableView().getItems().get(this.getIndex());
            if (pColorData == null) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            HBox hbox = new HBox();
            hbox.setSpacing(5.0);
            hbox.setAlignment(Pos.CENTER);
            hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
            ColorPicker colorPicker = new ColorPicker();
            colorPicker.getStyleClass().add("split-button");
            colorPicker.setValue(pColorData.getColor());
            colorPicker.setOnAction(a -> {
                Color color = (Color)colorPicker.getValue();
                pColorData.setColor(color);
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_REFRESH_TABLE);
            });
            hbox.getChildren().addAll((Node[])new Node[]{colorPicker});
            this.setGraphic(hbox);
        }
    };
    private final Callback<TableColumn<P2ColorData, String>, TableCell<P2ColorData, String>> cellFactoryReset = param -> new TableCell<P2ColorData, String>(){

        @Override
        public void updateItem(String item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            P2ColorData pColorData = (P2ColorData)this.getTableView().getItems().get(this.getIndex());
            if (pColorData == null) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            HBox hbox = new HBox();
            hbox.setSpacing(5.0);
            hbox.setAlignment(Pos.CENTER);
            hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
            Button button = new Button("Reset");
            button.setOnAction(a -> {
                pColorData.resetColor();
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_REFRESH_TABLE);
            });
            hbox.getChildren().add(button);
            this.setGraphic(hbox);
        }
    };
    private final Callback<TableColumn<P2ColorData, Color>, TableCell<P2ColorData, Color>> cellFactoryColor = param -> new TableCell<P2ColorData, Color>(){

        @Override
        public void updateItem(Color item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            P2ColorData pColorData = (P2ColorData)this.getTableView().getItems().get(this.getIndex());
            if (pColorData == null) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            Button btn = new Button("      ");
            btn.setStyle("-fx-background-color: " + pColorData.getColorSelectedToWeb());
            this.setGraphic(btn);
        }
    };
    private final Callback<TableColumn<P2ColorData, Color>, TableCell<P2ColorData, Color>> cellFactoryResetColor = param -> {
        TableCell<P2ColorData, Color> cell = new TableCell<P2ColorData, Color>(){

            @Override
            public void updateItem(Color item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                P2ColorData pColorData = (P2ColorData)this.getTableView().getItems().get(this.getIndex());
                if (pColorData == null) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                Button btn = new Button("      ");
                btn.setStyle("-fx-background-color:" + P2ColorFactory.getColorToWeb(pColorData.getResetColor()));
                this.setGraphic(btn);
            }
        };
        return cell;
    };

    public PaneColor(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.tglDarkTheme.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_DARK_THEME);
        this.tglBlackWhiteIcon.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_BLACK_WHITE_ICON);
    }

    public void make(Collection<TitledPane> result) {
        this.tglDarkTheme.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_DARK_THEME);
        Button btnHelpTheme = P2Button.helpButton(this.stage, "Erscheinungsbild der Programmoberfl\u00e4che", "Das Programm wird damit mit einer dunklen Programmoberfl\u00e4che angezeigt. F\u00fcr einige Elemente kann ein Programmneustart notwendig sein.\n");
        this.tglBlackWhiteIcon.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_BLACK_WHITE_ICON);
        Button btnHelpIcon = P2Button.helpButton(this.stage, "Erscheinungsbild der Programmoberfl\u00e4che", "Die Programmicons werden in Schwarz-Wei\u00df angezeigt. F\u00fcr einige Elemente kann ein Programmneustart notwendig sein.\n");
        this.initTableColor(this.tableViewFont);
        this.tableViewFont.setPrefHeight(200.0);
        this.tableViewFont.setItems(ProgColorList.getColorListFront());
        this.initTableColor(this.tableViewBackground);
        this.tableViewBackground.setPrefHeight(200.0);
        this.tableViewBackground.setItems(ProgColorList.getColorListBackground());
        ProgConfig.SYSTEM_DARK_THEME.addListener((u, o, n) -> {
            ProgColorList.setColorTheme();
            P2TableFactory.refreshTable(this.tableViewFont);
            P2TableFactory.refreshTable(this.tableViewBackground);
        });
        Button button = new Button("Alle _Farben zur\u00fccksetzen");
        button.setOnAction(event -> {
            ProgColorList.resetAllColor();
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_REFRESH_TABLE);
        });
        int row = 0;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        gridPane.add(this.tglDarkTheme, 0, row);
        gridPane.add(btnHelpTheme, 1, row);
        GridPane.setHalignment(btnHelpTheme, HPos.RIGHT);
        gridPane.add(this.tglBlackWhiteIcon, 0, ++row);
        gridPane.add(btnHelpIcon, 1, row);
        GridPane.setHalignment(btnHelpIcon, HPos.RIGHT);
        gridPane.add(new Label("Schriftfarben"), 0, ++row, 2, 1);
        gridPane.add(this.tableViewFont, 0, ++row, 2, 1);
        gridPane.add(new Label("Hintergrundfarben"), 0, ++row, 2, 1);
        gridPane.add(this.tableViewBackground, 0, ++row, 2, 1);
        gridPane.add(button, 0, ++row, 2, 1);
        GridPane.setHalignment(button, HPos.RIGHT);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        TitledPane tpColor = new TitledPane("Farben", gridPane);
        result.add(tpColor);
    }

    private void initTableColor(TableView<P2ColorData> tableView) {
        tableView.setMinHeight(200.0);
        tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        TableColumn textColumn = new TableColumn("Beschreibung");
        textColumn.setCellValueFactory(new PropertyValueFactory("text"));
        textColumn.getStyleClass().add("alignCenterLeft");
        TableColumn changeColumn = new TableColumn("Farbe");
        changeColumn.setCellFactory(this.cellFactoryChange);
        changeColumn.getStyleClass().add("alignCenter");
        TableColumn resetColumn = new TableColumn("Reset");
        resetColumn.setCellFactory(this.cellFactoryReset);
        resetColumn.getStyleClass().add("alignCenter");
        TableColumn colorColumn = new TableColumn("Farbe");
        colorColumn.setCellValueFactory(new PropertyValueFactory("color"));
        colorColumn.setCellFactory(this.cellFactoryColor);
        colorColumn.getStyleClass().add("alignCenter");
        TableColumn colorOrgColumn = new TableColumn("Original");
        colorOrgColumn.setCellValueFactory(new PropertyValueFactory("resetColor"));
        colorOrgColumn.setCellFactory(this.cellFactoryResetColor);
        colorOrgColumn.getStyleClass().add("alignCenter");
        tableView.getColumns().addAll(textColumn, changeColumn, colorColumn, colorOrgColumn, resetColumn);
    }
}

