/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.gui.configdialog.ControllerBlackList;
import de.p2tools.mtplayer.gui.configdialog.ControllerConfig;
import de.p2tools.mtplayer.gui.configdialog.ControllerDownload;
import de.p2tools.mtplayer.gui.configdialog.ControllerLoadFilmList;
import de.p2tools.mtplayer.gui.configdialog.ControllerMedia;
import de.p2tools.mtplayer.gui.configdialog.panesetdata.ControllerSet;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.mtfilm.film.FilmFactory;
import de.p2tools.p2lib.mtfilm.tools.LoadFactoryConst;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class ConfigDialogController
extends P2DialogExtra {
    private final TabPane tabPane = new TabPane();
    private final Button btnOk = new Button("_Ok");
    private final Button btnApply = new Button("_Anwenden");
    private final String geo = (String)ProgConfig.SYSTEM_GEO_HOME_PLACE.get();
    private final BooleanProperty blackChanged = new SimpleBooleanProperty(false);
    private final BooleanProperty diacriticChanged = new SimpleBooleanProperty(false);
    private ControllerConfig controllerConfig;
    private ControllerLoadFilmList controllerLoadFilmList;
    private ControllerBlackList controllerBlackList;
    private ControllerDownload controllerDownload;
    private ControllerMedia controllerMedia;
    private ControllerSet controllerSet;
    private IntegerProperty propSelectedTab = ProgConfig.SYSTEM_CONFIG_DIALOG_TAB;
    private final ProgData progData;
    private boolean blackListDialog = false;
    public static BooleanProperty dialogIsRunning = new SimpleBooleanProperty(false);

    public ConfigDialogController(ProgData progData) {
        super(progData.primaryStage, ProgConfig.CONFIG_DIALOG_SIZE, "Einstellungen", true, false, P2DialogExtra.DECO.NO_BORDER, true);
        this.progData = progData;
        dialogIsRunning.setValue(true);
        this.btnApply.setVisible(false);
        this.init(true);
    }

    public ConfigDialogController(ProgData progData, boolean blackListDialog) {
        super(progData.primaryStage, ProgConfig.BLACK_DIALOG_SIZE, "Blacklist bearbeiten", false, false, P2DialogExtra.DECO.NO_BORDER, true);
        this.progData = progData;
        this.blackListDialog = blackListDialog;
        dialogIsRunning.setValue(true);
        if (blackListDialog) {
            this.propSelectedTab = ProgConfig.SYSTEM_CONFIG_DIALOG_BLACKLIST_TAB;
        } else {
            this.btnApply.setVisible(false);
        }
        this.init(true);
    }

    @Override
    public void make() {
        this.getMaskerPane().visibleProperty().bind(ProgData.getInstance().maskerPane.visibleProperty());
        VBox.setVgrow(this.tabPane, Priority.ALWAYS);
        this.getVBoxCont().getChildren().add(this.tabPane);
        this.getVBoxCont().setPadding(new Insets(0.0));
        if (this.btnApply.isVisible()) {
            this.addOkCancelApplyButtons(this.btnOk, null, this.btnApply);
            this.btnApply.setOnAction(a -> this.onlyApply());
        } else {
            this.addOkButton(this.btnOk);
        }
        this.btnOk.setOnAction(a -> this.onlyClose());
        this.initPanel();
    }

    private void onlyApply() {
        if (!this.progData.loadFilmListWorker.loadFilmlist.getPropLoadFilmlist()) {
            new Thread(() -> {
                BlacklistFilterFactory.markFilmBlack(true);
                this.blackChanged.setValue(false);
            }).start();
        }
    }

    private void onlyClose() {
        if (!this.geo.equals(ProgConfig.SYSTEM_GEO_HOME_PLACE.get())) {
            LoadFactoryConst.GEO_HOME_PLACE = ProgConfig.SYSTEM_GEO_HOME_PLACE.getValue();
            this.progData.filmList.markGeoBlocked();
        }
        if (this.blackChanged.get() && !this.progData.loadFilmListWorker.loadFilmlist.getPropLoadFilmlist()) {
            new Thread(() -> BlacklistFilterFactory.markFilmBlack(true)).start();
        }
        if (this.diacriticChanged.getValue().booleanValue() && ProgConfig.SYSTEM_REMOVE_DIACRITICS.getValue().booleanValue()) {
            new Thread(() -> {
                ProgData.getInstance().maskerPane.setMaskerText("Diakritika entfernen");
                ProgData.getInstance().maskerPane.setMaskerVisible(true, true, false);
                FilmFactory.flattenDiacritic(this.progData.filmList);
                this.progData.pEventHandler.notifyListener(PEvents.EVENT_DIACRITIC_CHANGED);
                ProgData.getInstance().maskerPane.switchOffMasker();
            }).start();
        }
        this.close();
    }

    @Override
    public void close() {
        this.controllerConfig.close();
        this.controllerLoadFilmList.close();
        this.controllerBlackList.close();
        this.controllerDownload.close();
        this.controllerMedia.close();
        this.controllerSet.close();
        this.progData.pEventHandler.notifyListener(PEvents.EVENT_SET_DATA_CHANGED);
        dialogIsRunning.setValue(false);
        super.close();
    }

    private void initPanel() {
        try {
            this.controllerConfig = new ControllerConfig(this.getStage());
            Tab tab = new Tab("Allgemein");
            tab.setClosable(false);
            tab.setContent(this.controllerConfig);
            if (!this.blackListDialog) {
                this.tabPane.getTabs().add(tab);
            }
            this.controllerLoadFilmList = new ControllerLoadFilmList(this.getStage(), this.diacriticChanged);
            tab = new Tab("Filmliste laden");
            tab.setClosable(false);
            tab.setContent(this.controllerLoadFilmList);
            this.tabPane.getTabs().add(tab);
            this.controllerBlackList = new ControllerBlackList(this.getStage(), this.blackChanged);
            tab = new Tab("Blacklist");
            tab.setClosable(false);
            tab.setContent(this.controllerBlackList);
            this.tabPane.getTabs().add(tab);
            this.controllerDownload = new ControllerDownload(this.getStage());
            tab = new Tab("Download");
            tab.setClosable(false);
            tab.setContent(this.controllerDownload);
            if (!this.blackListDialog) {
                this.tabPane.getTabs().add(tab);
            }
            this.controllerMedia = new ControllerMedia(this.getStage());
            tab = new Tab("Mediensammlung");
            tab.setClosable(false);
            tab.setContent(this.controllerMedia);
            if (!this.blackListDialog) {
                this.tabPane.getTabs().add(tab);
            }
            this.controllerSet = new ControllerSet(this.getStage());
            tab = new Tab("Aufzeichnen/Abspielen");
            tab.setClosable(false);
            tab.setContent(this.controllerSet);
            if (!this.blackListDialog) {
                this.tabPane.getTabs().add(tab);
            }
            this.tabPane.getSelectionModel().select(this.propSelectedTab.get());
            this.tabPane.getSelectionModel().selectedIndexProperty().addListener((observable2, oldValue, newValue) -> this.propSelectedTab.setValue((Number)newValue));
        }
        catch (Exception ex) {
            P2Log.errorLog(784459510, ex);
        }
    }
}

