/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.chart;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.gui.chart.BandwidthData;
import de.p2tools.mtplayer.gui.chart.BandwidthDataFactory;
import de.p2tools.mtplayer.gui.chart.ChartData;
import javafx.geometry.Side;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.util.StringConverter;

public class ChartFactory {
    private ChartFactory() {
    }

    public static NumberAxis createXAxis() {
        NumberAxis xAxis = new NumberAxis();
        xAxis.setAutoRanging(false);
        ChartFactory.setXAxisLabel(xAxis);
        BandwidthDataFactory.SHOW_MINUTES.addListener((u, o, n) -> ChartFactory.setXAxisLabel(xAxis));
        xAxis.setLowerBound(0.0);
        xAxis.setSide(Side.RIGHT);
        xAxis.setTickLabelFormatter(new StringConverter<Number>(){

            @Override
            public String toString(Number object) {
                if (object.doubleValue() > 60.0) {
                    int i = (int)object.doubleValue();
                    return String.valueOf(i);
                }
                int i = (int)(object.doubleValue() * 10.0);
                return String.valueOf((double)i / 10.0);
            }

            @Override
            public Number fromString(String string) {
                return 0;
            }
        });
        return xAxis;
    }

    public static synchronized void zoomXAxis(LineChart<Number, Number> lineChart, ChartData chartData) {
        NumberAxis xAxis = (NumberAxis)lineChart.getXAxis();
        xAxis.setUpperBound((double)ProgData.countRunningTimeSeconds / (BandwidthDataFactory.SHOW_MINUTES.getValue() != false ? 60.0 : 1.0));
        double secondsPerPixel = chartData.getSecondsPerPixel();
        double MIN = (double)ProgData.countRunningTimeSeconds - (double)BandwidthDataFactory.CHART_SUM_PIXEL * secondsPerPixel;
        double lower = Math.max(MIN, 0.0);
        xAxis.setLowerBound(lower / (BandwidthDataFactory.SHOW_MINUTES.getValue() != false ? 60.0 : 1.0));
    }

    private static void setXAxisLabel(NumberAxis xAxis) {
        xAxis.setLabel("Programmlaufzeit " + (BandwidthDataFactory.SHOW_MINUTES.getValue() != false ? "[min]" : "[s]"));
    }

    public static NumberAxis createYAxis() {
        NumberAxis yAxis = new NumberAxis();
        yAxis.setAutoRanging(true);
        yAxis.setLowerBound(0.0);
        yAxis.setLabel("Wert");
        return yAxis;
    }

    public static synchronized void generateYScale(LineChart<Number, Number> lineChart, ChartData chartData) {
        int max = 0;
        int scale = 1;
        for (BandwidthData bandwidthData : chartData.getBandwidthDataList()) {
            int m;
            if (!bandwidthData.isShowing() || (m = bandwidthData.getMaxValue()) <= max) continue;
            max = m;
        }
        while (max > 25000) {
            max /= 1000;
            scale *= 1000;
        }
        chartData.setyScale(scale);
        ChartFactory.setYAxisLabel(lineChart, scale);
    }

    private static void setYAxisLabel(LineChart<Number, Number> lineChart, int scale) {
        switch (scale) {
            case 1: {
                lineChart.getYAxis().setLabel("Bandbreite [kB/s]");
                break;
            }
            case 1000: {
                lineChart.getYAxis().setLabel("Bandbreite [MB/s]");
                break;
            }
            case 1000000: {
                lineChart.getYAxis().setLabel("Bandbreite [GB/s]");
            }
        }
    }
}

