/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.chart;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.gui.chart.BandwidthDataFactory;
import java.util.Arrays;

public class BandwidthData {
    private DownloadData download;
    private int downloadState = 0;
    private String name = "";
    private long startTimeSec = -1L;
    private boolean showing = false;
    private boolean downloading = true;
    private int[] data = new int[BandwidthDataFactory.MAX_DATA];
    private int tmpValue = 0;

    public BandwidthData(DownloadData download) {
        this.download = download;
        this.setDownloadState();
    }

    public void setDownload(DownloadData download) {
        this.download = download;
        this.setDownloadState();
    }

    public DownloadData getDownload() {
        return this.download;
    }

    private void setDownloadState() {
        if (this.download != null) {
            this.downloadState = this.download.getState();
        }
    }

    public int getDownloadState() {
        this.setDownloadState();
        return this.downloadState;
    }

    public void setStartTimeNow() {
        this.startTimeSec = ProgData.countRunningTimeSeconds;
        this.cleanUpData();
    }

    public long getStartTimeSec() {
        return this.startTimeSec;
    }

    public void cleanUpData() {
        Arrays.fill(this.data, 0);
    }

    public void addData(long a) {
        if (this.startTimeSec < 0L) {
            this.setStartTimeNow();
        }
        this.tmpValue += (int)(a / 1000L);
        if (BandwidthDataFactory.GET_DATA_COUNT >= BandwidthDataFactory.DATA_ALL_SECONDS - 1) {
            for (int i = 1; i < this.data.length; ++i) {
                this.data[i - 1] = this.data[i];
            }
            this.data[this.data.length - 1] = this.tmpValue / BandwidthDataFactory.DATA_ALL_SECONDS;
            this.tmpValue = 0;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isShowing() {
        return this.showing;
    }

    public boolean isDownloading() {
        return this.downloading;
    }

    public void setDownloading(boolean downloading) {
        this.downloading = downloading;
    }

    public int[] getData() {
        return this.data;
    }

    public void setShowing(boolean showing) {
        this.showing = showing;
    }

    public boolean isEmpty() {
        for (int datum : this.data) {
            if (datum <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean allValuesEmpty() {
        for (int datum : this.data) {
            if (datum <= 0) continue;
            return false;
        }
        return true;
    }

    public int getMaxValue() {
        int max = 0;
        for (int i = this.getMaxFirstIdx(); i < this.data.length; ++i) {
            if (this.data[i] <= max) continue;
            max = this.data[i];
        }
        return max;
    }

    private int getMaxFirstIdx() {
        int first = this.data.length - ProgConfig.DOWNLOAD_CHART_MAX_TIME_TO_SHOW_MIN.get() * 60 / BandwidthDataFactory.DATA_ALL_SECONDS;
        return Math.max(first, 0);
    }
}

