/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadInfosFactory;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;

public class StatusBarController
extends AnchorPane {
    private final Label lblSelFilm = new Label();
    private final Label lblLeftFilm = new Label();
    private final Label lblRightFilm = new Label();
    private final Circle circleFilm = new Circle(6.0);
    private final HBox hBoxCircleFilm = new HBox(0.0);
    private final Label lblSelLiveFilm = new Label();
    private final Label lblLeftLiveFilm = new Label();
    private final Label lblRightLiveFilm = new Label();
    private final Circle circleLiveFilm = new Circle(6.0);
    private final HBox hBoxCircleLiveFilm = new HBox(0.0);
    private final Label lblSelDownload = new Label();
    private final Label lblLeftDownload = new Label();
    private final Label lblRightDownload = new Label();
    private final Circle circleDownload = new Circle(6.0);
    private final HBox hBoxCircleDownload = new HBox(0.0);
    private final Label lblSelAbo = new Label();
    private final Label lblLeftAbo = new Label();
    private final Label lblRightAbo = new Label();
    private final Circle circleAbo = new Circle(6.0);
    private final HBox hBoxCircleAbo = new HBox(0.0);
    private final StackPane stackPane = new StackPane();
    private final Pane filmPane;
    private final Pane liveFilmPane;
    private final Pane downloadPane;
    private final Pane aboPane;
    private final ProgData progData;
    private boolean stopTimer = false;
    private boolean halfSecond = false;
    private boolean blink = false;

    public StatusBarController(ProgData progData) {
        this.progData = progData;
        this.getChildren().addAll((Node[])new Node[]{this.stackPane});
        AnchorPane.setLeftAnchor(this.stackPane, 0.0);
        AnchorPane.setBottomAnchor(this.stackPane, 0.0);
        AnchorPane.setRightAnchor(this.stackPane, 0.0);
        AnchorPane.setTopAnchor(this.stackPane, 0.0);
        this.lblSelFilm.setTooltip(new Tooltip("Anzahl markierter Filme"));
        this.lblSelLiveFilm.setTooltip(new Tooltip("Anzahl markierter Filme"));
        this.lblSelDownload.setTooltip(new Tooltip("Anzahl markierter Downloads"));
        this.lblSelAbo.setTooltip(new Tooltip("Anzahl markierter Abos"));
        this.hBoxCircleFilm.getChildren().add(this.circleFilm);
        this.hBoxCircleDownload.getChildren().add(this.circleDownload);
        this.hBoxCircleAbo.getChildren().add(this.circleAbo);
        this.filmPane = this.getHBox(this.lblSelFilm, this.lblLeftFilm, this.hBoxCircleFilm, this.lblRightFilm);
        this.liveFilmPane = this.getHBox(this.lblSelLiveFilm, this.lblLeftLiveFilm, this.hBoxCircleLiveFilm, this.lblRightLiveFilm);
        this.downloadPane = this.getHBox(this.lblSelDownload, this.lblLeftDownload, this.hBoxCircleDownload, this.lblRightDownload);
        this.aboPane = this.getHBox(this.lblSelAbo, this.lblLeftAbo, this.hBoxCircleAbo, this.lblRightAbo);
        this.make();
        this.setVisProp();
    }

    private HBox getHBox(Label lblSel, Label lblLeft, HBox hBoxCircle, Label lblRight) {
        HBox hBox = new HBox();
        hBoxCircle.setAlignment(Pos.CENTER);
        hBoxCircle.setPadding(new Insets(0.0, 15.0, 0.0, 15.0));
        hBox.setPadding(new Insets(2.0, 5.0, 2.0, 5.0));
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        lblSel.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        lblSel.getStyleClass().add("lblSelectedLines");
        lblLeft.getStyleClass().add("lblInfo");
        hBox.setStyle("-fx-background-color: -fx-background;");
        hBox.getChildren().addAll((Node[])new Node[]{lblSel, lblLeft, hBoxCircle, P2GuiTools.getHBoxGrower(), lblRight});
        return hBox;
    }

    private void setVisProp() {
        this.lblSelFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblSelFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblLeftFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblLeftFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblRightFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.lblRightFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.hBoxCircleFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.hBoxCircleFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.lblSelLiveFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblSelLiveFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblLeftLiveFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblLeftLiveFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblRightLiveFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.lblRightLiveFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.hBoxCircleLiveFilm.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.hBoxCircleLiveFilm.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.lblSelDownload.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblSelDownload.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblLeftDownload.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblLeftDownload.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblRightDownload.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.lblRightDownload.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.hBoxCircleDownload.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.hBoxCircleDownload.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.lblSelAbo.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblSelAbo.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        this.lblLeftAbo.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblLeftAbo.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        this.lblRightAbo.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.lblRightAbo.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        this.hBoxCircleAbo.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        this.hBoxCircleAbo.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
    }

    private void make() {
        this.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                ContextMenu contextMenu = new ContextMenu();
                this.getMenu(contextMenu);
                contextMenu.show(ProgData.getInstance().primaryStage, m.getScreenX(), m.getScreenY());
            }
        });
        this.stackPane.getChildren().addAll((Node[])new Node[]{this.filmPane, this.downloadPane, this.aboPane});
        this.stackPane.setPadding(new Insets(0.0));
        this.filmPane.toFront();
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_START){

            @Override
            public void pingGui() {
                StatusBarController.this.stopTimer = true;
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_FINISHED){

            @Override
            public void pingGui() {
                StatusBarController.this.stopTimer = false;
                StatusBarController.this.setStatusbarIndex();
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_TIMER_SECOND){

            @Override
            public void pingGui() {
                StatusBarController.this.halfSecond = !StatusBarController.this.halfSecond;
                try {
                    if (!StatusBarController.this.stopTimer) {
                        StatusBarController.this.setStatusbarIndex();
                    }
                }
                catch (Exception ex) {
                    P2Log.errorLog(936251087, ex);
                }
            }
        });
    }

    private void getMenu(ContextMenu contextMenu) {
        CheckMenuItem miOn = new CheckMenuItem("Statusleiste anzeigen");
        miOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_ON);
        CheckMenuItem miSelOn = new CheckMenuItem("Anzeige der Anzahl der markierten Zeilen");
        miSelOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_SEL);
        CheckMenuItem miLeftOn = new CheckMenuItem("Anzeige des Infobereichs links");
        miLeftOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_LEFT);
        CheckMenuItem miDotOn = new CheckMenuItem("Anzeige des Farbpunktes f\u00fcr die Downloads");
        miDotOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_DOT);
        CheckMenuItem miRightOn = new CheckMenuItem("Anzeige der Infos \u00fcber die Filmliste");
        miRightOn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_STATUS_BAR_FIELD_RIGHT);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miOn, miSelOn, miLeftOn, miDotOn, miRightOn});
    }

    public void setStatusbarIndex() {
        switch (MTPlayerController.paneShown) {
            case FILM: {
                this.filmPane.toFront();
                this.setInfoFilm();
                this.setTextForRightDisplay();
                break;
            }
            case LIVE_FILM: {
                this.liveFilmPane.toFront();
                this.setInfoLiveFilm();
                this.setTextForRightDisplay();
                break;
            }
            case DOWNLOAD: {
                this.downloadPane.toFront();
                this.setInfoDownload();
                this.setTextForRightDisplay();
                break;
            }
            case ABO: {
                this.aboPane.toFront();
                this.setInfoAbo();
                this.setTextForRightDisplay();
            }
        }
    }

    private void setInfoFilm() {
        this.setCircleStyle();
        this.lblLeftFilm.setText(DownloadInfosFactory.getStatusInfosFilm());
        int selCount = this.progData.filmGuiController.getSelCount();
        this.lblSelFilm.setText((String)(selCount > 0 ? "" + selCount : " "));
    }

    private void setInfoLiveFilm() {
        this.setCircleStyle();
        this.lblLeftFilm.setText(DownloadInfosFactory.getStatusInfosLiveFilm());
        int selCount = this.progData.liveFilmGuiController.getSelCount();
        this.lblSelFilm.setText((String)(selCount > 0 ? "" + selCount : " "));
    }

    private void setInfoDownload() {
        this.setCircleStyle();
        this.lblLeftDownload.setText(DownloadInfosFactory.getStatusInfosDownload());
        int selCount = this.progData.downloadGuiController.getSelCount();
        this.lblSelDownload.setText((String)(selCount > 0 ? "" + selCount : " "));
    }

    private void setInfoAbo() {
        this.setCircleStyle();
        this.lblLeftAbo.setText(DownloadInfosFactory.getStatusInfosAbo());
        int selCount = this.progData.aboGuiController.getSelCount();
        this.lblSelAbo.setText((String)(selCount > 0 ? "" + selCount : " "));
    }

    private void setCircleStyle() {
        if (this.halfSecond && this.blink) {
            this.circleFilm.setVisible(false);
            this.circleDownload.setVisible(false);
            this.circleAbo.setVisible(false);
        } else {
            this.circleFilm.setVisible(true);
            this.circleDownload.setVisible(true);
            this.circleAbo.setVisible(true);
        }
        boolean bl = this.blink = this.progData.downloadInfos.getNotStarted() > 0;
        if (this.progData.downloadInfos.getFinishedError() > 0) {
            this.circleFilm.setFill(Paint.valueOf("red"));
            this.circleDownload.setFill(Paint.valueOf("red"));
            this.circleAbo.setFill(Paint.valueOf("red"));
        } else if (this.progData.downloadInfos.getLoading() > 0) {
            this.circleFilm.setFill(Paint.valueOf("green"));
            this.circleDownload.setFill(Paint.valueOf("green"));
            this.circleAbo.setFill(Paint.valueOf("green"));
        } else {
            this.circleFilm.setFill(Paint.valueOf(ProgConfig.SYSTEM_DARK_THEME.getValue() != false ? "#c1c1c1" : "#666666"));
            this.circleDownload.setFill(Paint.valueOf(ProgConfig.SYSTEM_DARK_THEME.getValue() != false ? "#c1c1c1" : "#666666"));
            this.circleAbo.setFill(Paint.valueOf(ProgConfig.SYSTEM_DARK_THEME.getValue() != false ? "#c1c1c1" : "#666666"));
        }
    }

    private void setTextForRightDisplay() {
        Object strText = "Filmliste erstellt: ";
        strText = (String)strText + this.progData.filmList.genDate();
        strText = (String)strText + " Uhr  ";
        int second = this.progData.filmList.getAge();
        if (second != 0) {
            strText = (String)strText + "||  Alter: ";
            int minute = second / 60;
            Object strSecond = String.valueOf(second % 60);
            Object strMinute = String.valueOf(minute % 60);
            Object strHour = String.valueOf(minute / 60);
            if (((String)strSecond).length() < 2) {
                strSecond = "0" + (String)strSecond;
            }
            if (((String)strMinute).length() < 2) {
                strMinute = "0" + (String)strMinute;
            }
            if (((String)strHour).length() < 2) {
                strHour = "0" + (String)strHour;
            }
            strText = (String)strText + (String)strHour + ":" + (String)strMinute + ":" + (String)strSecond + " ";
        }
        this.lblRightFilm.setText((String)strText);
        this.lblRightDownload.setText((String)strText);
        this.lblRightAbo.setText((String)strText);
    }
}

