/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.p2lib.p2event.P2Events;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.P2InfoFactory;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class MsgMemController
extends AnchorPane {
    private final VBox vBoxCont = new VBox();
    private LineChart<Number, Number> lineChart = null;
    private final ObservableList<XYChart.Series<Number, Number>> listChart = FXCollections.observableArrayList();
    private int countSek = 0;
    private final Runtime rt = Runtime.getRuntime();
    private final Label lblMem = new Label("");
    private static final int MEGABYTE = 1000000;

    public MsgMemController() {
        this.initCharts();
        this.vBoxCont.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.vBoxCont.setSpacing(5.0);
        AnchorPane.setTopAnchor(this.vBoxCont, 0.0);
        AnchorPane.setRightAnchor(this.vBoxCont, 0.0);
        AnchorPane.setBottomAnchor(this.vBoxCont, 0.0);
        AnchorPane.setLeftAnchor(this.vBoxCont, 0.0);
        VBox.setVgrow(this.lineChart, Priority.ALWAYS);
        this.vBoxCont.getChildren().addAll((Node[])new Node[]{this.lblMem, this.lineChart});
        this.getChildren().add(this.vBoxCont);
        ProgData.getInstance().pEventHandler.addListener(new P2Listener(P2Events.EVENT_TIMER_SECOND){

            @Override
            public void pingGui() {
                MsgMemController.this.searchInfos();
            }
        });
    }

    private NumberAxis createXAxis() {
        NumberAxis xAxis = new NumberAxis();
        xAxis.setAutoRanging(true);
        xAxis.setForceZeroInRange(false);
        xAxis.setTickLabelFormatter(new StringConverter<Number>(){

            @Override
            public String toString(Number object) {
                int i = (int)(object.doubleValue() * 10.0);
                return "" + (double)i / 10.0;
            }

            @Override
            public Number fromString(String string) {
                return 0;
            }
        });
        return xAxis;
    }

    private NumberAxis createYAxis() {
        NumberAxis xAxis = new NumberAxis();
        xAxis.setForceZeroInRange(false);
        xAxis.setAutoRanging(true);
        return xAxis;
    }

    private void initCharts() {
        this.lineChart = new LineChart<Number, Number>(this.createXAxis(), this.createYAxis());
        this.listChart.add(new XYChart.Series("Gesamtspeicher", FXCollections.observableArrayList()));
        this.listChart.add(new XYChart.Series("Benutzt", FXCollections.observableArrayList()));
        this.lineChart.setData(this.listChart);
        this.lineChart.setTitle("Programmspeicher");
        this.lineChart.getXAxis().setLabel("Zeit [min]");
        this.lineChart.getYAxis().setLabel("[MByte]");
        this.lineChart.setAnimated(false);
        this.lineChart.setCreateSymbols(false);
    }

    private synchronized void searchInfos() {
        ++this.countSek;
        if (this.countSek % 2 == 0) {
            return;
        }
        double countMin = (double)this.countSek / 60.0;
        long maxMem = P2InfoFactory.getOs() == P2InfoFactory.OperatingSystemType.LINUX ? this.rt.totalMemory() : this.rt.maxMemory();
        long totalMemory = this.rt.totalMemory();
        long freeMemory = this.rt.freeMemory();
        long usedMem = totalMemory - freeMemory;
        long used = usedMem / 1000000L;
        long total = maxMem / 1000000L;
        String info = used + " von " + total + "MB";
        this.lineChart.setTitle("Programmspeicher  [" + info + "]");
        ((XYChart.Series)this.listChart.get(0)).getData().add(new XYChart.Data<Double, Long>(countMin, total));
        ((XYChart.Series)this.listChart.get(1)).getData().add(new XYChart.Data<Double, Long>(countMin, used));
        for (XYChart.Series series : this.listChart) {
            if (series.getData().size() <= 500) continue;
            series.getData().remove(0);
        }
    }
}

