/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.gui.AboMenu;
import de.p2tools.mtplayer.gui.DownloadMenu;
import de.p2tools.mtplayer.gui.FilmMenu;
import de.p2tools.mtplayer.gui.LiveFilmMenu;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.VBox;

public class MenuController
extends ScrollPane {
    public MenuController(StartupMode sm) {
        VBox vb = new VBox();
        this.setMinWidth(Double.NEGATIVE_INFINITY);
        this.setFitToHeight(true);
        this.setFitToWidth(true);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setContent(vb);
        vb.setPadding(new Insets(5.0));
        vb.setSpacing(15.0);
        vb.setAlignment(Pos.TOP_CENTER);
        switch (sm) {
            case Film: {
                new FilmMenu(vb).init();
                this.visibleProperty().bind(ProgConfig.FILM_GUI_SHOW_MENU);
                this.managedProperty().bind(ProgConfig.FILM_GUI_SHOW_MENU);
                this.setOnMouseClicked(mouseEvent -> {
                    if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                        ProgConfig.FILM_GUI_SHOW_MENU.set(!ProgConfig.FILM_GUI_SHOW_MENU.get());
                    }
                });
                break;
            }
            case LIVE_FILM: {
                new LiveFilmMenu(vb).init();
                this.visibleProperty().bind(ProgConfig.LIVE_FILM_GUI_SHOW_MENU);
                this.managedProperty().bind(ProgConfig.LIVE_FILM_GUI_SHOW_MENU);
                this.setOnMouseClicked(mouseEvent -> {
                    if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                        ProgConfig.LIVE_FILM_GUI_SHOW_MENU.set(!ProgConfig.LIVE_FILM_GUI_SHOW_MENU.get());
                    }
                });
                break;
            }
            case DOWNLOAD: {
                new DownloadMenu(vb).init();
                this.visibleProperty().bind(ProgConfig.DOWNLOAD_GUI_SHOW_MENU);
                this.managedProperty().bind(ProgConfig.DOWNLOAD_GUI_SHOW_MENU);
                this.setOnMouseClicked(mouseEvent -> {
                    if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                        ProgConfig.DOWNLOAD_GUI_SHOW_MENU.set(!ProgConfig.DOWNLOAD_GUI_SHOW_MENU.get());
                    }
                });
                break;
            }
            case ABO: {
                new AboMenu(vb).init();
                this.visibleProperty().bind(ProgConfig.ABO_GUI_SHOW_MENU);
                this.managedProperty().bind(ProgConfig.ABO_GUI_SHOW_MENU);
                this.setOnMouseClicked(mouseEvent -> {
                    if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                        ProgConfig.ABO_GUI_SHOW_MENU.set(!ProgConfig.ABO_GUI_SHOW_MENU.get());
                    }
                });
            }
        }
    }

    public static enum StartupMode {
        Film,
        LIVE_FILM,
        DOWNLOAD,
        ABO;

    }
}

