/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.film.FilmSaveFactory;
import de.p2tools.mtplayer.controller.starter.StartDownloadFactory;
import de.p2tools.mtplayer.gui.FilmTableContextMenu;
import de.p2tools.mtplayer.gui.LiveFilmGuiController;
import de.p2tools.mtplayer.gui.tools.table.TableLiveFilm;
import java.util.Optional;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class LiveFilmTableContextMenu {
    private final ProgData progData;
    private final LiveFilmGuiController filmGuiController;
    private final TableLiveFilm tableView;

    public LiveFilmTableContextMenu(ProgData progData, LiveFilmGuiController filmGuiController, TableLiveFilm tableView) {
        this.progData = progData;
        this.filmGuiController = filmGuiController;
        this.tableView = tableView;
    }

    public ContextMenu getContextMenu(FilmDataMTP film) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem miStart = new MenuItem("Film abspielen");
        miStart.setOnAction(a -> {
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().liveFilmGuiController.getSel(true, true);
            filmSelection.ifPresent(FilmPlayFactory::playFilm);
        });
        MenuItem miSave = new MenuItem("Film speichern");
        miSave.setOnAction(a -> FilmSaveFactory.saveFilmList());
        miStart.setDisable(film == null);
        miSave.setDisable(film == null);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miStart, miSave});
        Menu mStartFilm = FilmTableContextMenu.startFilmWithSet(this.progData, film);
        if (mStartFilm != null) {
            contextMenu.getItems().add(mStartFilm);
        }
        Menu mCopyUrl = FilmTableContextMenu.copyInfos(film);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{mCopyUrl});
        MenuItem miLoadUt = new MenuItem("Untertitel speichern");
        miLoadUt.setDisable(film == null || film.getUrlSubtitle().isEmpty());
        miLoadUt.setOnAction(a -> StartDownloadFactory.downloadSubtitle(film, true));
        MenuItem miLoadTxt = new MenuItem("Info-Datei speichern");
        miLoadTxt.setDisable(film == null);
        miLoadTxt.setOnAction(a -> StartDownloadFactory.downloadSubtitle(film, false));
        MenuItem miFilmInfo = new MenuItem("Filminformation anzeigen");
        miFilmInfo.setDisable(film == null);
        miFilmInfo.setOnAction(a -> this.filmGuiController.showFilmInfo());
        MenuItem miMediaDb = new MenuItem("Film in der Mediensammlung suchen");
        miMediaDb.setDisable(film == null);
        miMediaDb.setOnAction(a -> this.filmGuiController.searchFilmInMediaCollection());
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miLoadUt, miLoadTxt, miFilmInfo, miMediaDb});
        MenuItem toolTipTable = new MenuItem(ProgConfig.LIVE_FILM_GUI_SHOW_TABLE_TOOL_TIP.getValue() != false ? "Keine Infos beim \u00dcberfahren einer Zeile anzeigen" : "Infos beim \u00dcberfahren einer Zeile anzeigen");
        toolTipTable.setOnAction(a -> ProgConfig.LIVE_FILM_GUI_SHOW_TABLE_TOOL_TIP.setValue(ProgConfig.LIVE_FILM_GUI_SHOW_TABLE_TOOL_TIP.getValue() == false));
        MenuItem resetTable = new MenuItem("Tabelle zur\u00fccksetzen");
        resetTable.setOnAction(a -> this.tableView.resetTable());
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{toolTipTable, resetTable});
        return contextMenu;
    }
}

