/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.gui.LiveFilmGuiController;
import de.p2tools.mtplayer.gui.MenuController;
import de.p2tools.mtplayer.gui.filter.live.LiveFilmFilterController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDto;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneFactory;
import java.util.ArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class LiveFilmGui {
    ProgData progData;
    private final SplitPane splitPane = new SplitPane();
    private final HBox hBox = new HBox();
    private final LiveFilmFilterController liveFilmFilterController;
    private final LiveFilmGuiController liveFilmGuiController;
    private final BooleanProperty boundFilter = new SimpleBooleanProperty(false);
    private final P2ClosePaneController infoControllerFilter;

    public LiveFilmGui() {
        this.progData = ProgData.getInstance();
        this.liveFilmFilterController = new LiveFilmFilterController();
        this.liveFilmGuiController = new LiveFilmGuiController();
        ArrayList<P2ClosePaneDto> list = new ArrayList<P2ClosePaneDto>();
        P2ClosePaneDto infoDto = new P2ClosePaneDto(this.liveFilmFilterController, ProgConfig.LIVE_FILM__FILTER_IS_RIP, ProgConfig.LIVE_FILM__FILTER_DIALOG_SIZE, ProgData.LIVE_FILM_TAB_ON, "Filter", "Filter", true, this.progData.maskerPane.getVisibleProperty());
        list.add(infoDto);
        this.infoControllerFilter = new P2ClosePaneController(list, ProgConfig.LIVE_FILM__FILTER_IS_SHOWING);
    }

    public SplitPane pack() {
        MenuController menuController = new MenuController(MenuController.StartupMode.LIVE_FILM);
        this.progData.liveFilmGuiController = this.liveFilmGuiController;
        this.splitPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        SplitPane.setResizableWithParent(this.liveFilmFilterController, Boolean.FALSE);
        this.hBox.setPrefSize(-1.0, -1.0);
        this.hBox.setMinSize(-1.0, -1.0);
        this.hBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        HBox.setHgrow(this.splitPane, Priority.ALWAYS);
        this.hBox.getChildren().addAll((Node[])new Node[]{this.splitPane, menuController});
        ProgConfig.LIVE_FILM__FILTER_IS_SHOWING.addListener((observable2, oldValue, newValue) -> this.setSplit());
        ProgConfig.LIVE_FILM__FILTER_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setSplit());
        this.setSplit();
        return new SplitPane(this.hBox);
    }

    private void setSplit() {
        P2ClosePaneFactory.setSplit(this.boundFilter, this.splitPane, this.infoControllerFilter, true, this.liveFilmGuiController, ProgConfig.LIVE_FILM__FILTER_DIVIDER, ProgConfig.LIVE_FILM__FILTER_IS_SHOWING);
    }
}

