/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.MTPlayerFactory;
import de.p2tools.mtplayer.controller.config.PShortKeyFactory;
import de.p2tools.mtplayer.controller.config.PShortcut;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.film.FilmSaveFactory;
import de.p2tools.mtplayer.controller.filmfilter.FilmFilter;
import de.p2tools.mtplayer.controller.filmfilter.FilterSamples;
import de.p2tools.mtplayer.gui.ToolBarButton;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.shortcut.P2ShortcutWorker;
import java.util.Optional;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;

public class FilmMenu {
    private final VBox vBox;
    private final ProgData progData;
    private FilmFilter storedActFilterSettings = null;
    private static final String FILM_FILTER_BOOKMARK_TEXT = "Alle angelegte Bookmarks anzeigen\nder zweite Klick stellt den\neingestellten Filter wieder her";

    public FilmMenu(VBox vBox) {
        this.vBox = vBox;
        this.progData = ProgData.getInstance();
    }

    public void init() {
        this.vBox.getChildren().clear();
        this.initFilmMenu();
        this.initButton();
    }

    private void initButton() {
        VBox vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(0.0);
        vBoxSpace.setMinHeight(0.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btPlay = new ToolBarButton(this.vBox, "Abspielen", "Markierten Film abspielen", ProgIcons.ICON_TOOLBAR_START.getImageView());
        ToolBarButton btPlayAll = new ToolBarButton(this.vBox, "Alle Abspielen", "Alle Markierten Filme abspielen", ProgIcons.ICON_TOOLBAR_START_ALL.getImageView());
        ToolBarButton btSave = new ToolBarButton(this.vBox, "Speichern", "Markierte Filme speichern", ProgIcons.ICON_TOOLBAR_REC.getImageView());
        btPlay.setOnAction(a -> {
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().filmGuiController.getSel(true, true);
            if (filmSelection.isPresent()) {
                FilmPlayFactory.playFilm(filmSelection.get());
                this.progData.filmGuiController.tableView.refresh();
                this.progData.filmGuiController.tableView.requestFocus();
            }
        });
        btPlayAll.setOnAction(a -> {
            FilmPlayFactory.playFilmList(ProgData.getInstance().filmGuiController.getSelList(true));
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        btSave.setOnAction(a -> {
            FilmSaveFactory.saveFilmList();
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(10.0);
        vBoxSpace.setMinHeight(10.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btBookmark = new ToolBarButton(this.vBox, "Bookmarks anlegen", "Bookmarks f\u00fcr die markierten Filme anlegen", ProgIcons.ICON_TOOLBAR_BOOKMARK.getImageView());
        ToolBarButton btDelBookmark = new ToolBarButton(this.vBox, "Bookmarks l\u00f6schen", "Bookmarks f\u00fcr die markierten Filme l\u00f6schen", ProgIcons.ICON_TOOLBAR_DEL_BOOKMARK.getImageView());
        ToolBarButton btDelAllBookmark = new ToolBarButton(this.vBox, "Alle Bookmarks l\u00f6schen", "Alle angelegten Bookmarks l\u00f6schen", ProgIcons.ICON_TOOLBAR_DEL_ALL_BOOKMARK.getImageView());
        ToolBarButton btFilterBookmark = new ToolBarButton(this.vBox, "Bookmarks anzeigen", FILM_FILTER_BOOKMARK_TEXT, ProgIcons.ICON_TOOLBAR_BOOKMARK_FILTER.getImageView());
        btBookmark.setOnAction(a -> {
            this.progData.filmGuiController.bookmarkFilm(true);
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        btDelBookmark.setOnAction(a -> {
            this.progData.filmGuiController.bookmarkFilm(false);
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        btDelAllBookmark.setOnAction(a -> {
            this.progData.historyListBookmarks.clearAll(this.progData.primaryStage);
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        btFilterBookmark.setOnAction(a -> {
            FilmFilter bookmarkFilter;
            FilmFilter sf = this.progData.filterWorker.getActFilterSettings();
            if (sf.isSame(bookmarkFilter = FilterSamples.getBookmarkFilter())) {
                if (this.storedActFilterSettings != null) {
                    this.progData.filterWorker.setActFilterSettings(this.storedActFilterSettings);
                    this.storedActFilterSettings = null;
                } else {
                    this.progData.filterWorker.getActFilterSettings().clearFilter();
                }
            } else {
                this.storedActFilterSettings = this.progData.filterWorker.getActFilterSettings().getCopy();
                this.progData.filterWorker.setActFilterSettings(bookmarkFilter);
            }
            this.progData.filmGuiController.tableView.refresh();
            this.progData.filmGuiController.tableView.requestFocus();
        });
        this.vBox.getChildren().add(P2GuiTools.getVBoxGrower());
        ToolBarButton btLiveFilm = new ToolBarButton(this.vBox, "Live-Suche", "Live-Suche in der ARD/ZDF-Mediathek", ProgIcons.ICON_TOOLBAR_LIVE.getImageView());
        btLiveFilm.setOnAction(a -> ProgConfig.LIVE_FILM_IS_VISIBLE.set(!ProgConfig.LIVE_FILM_IS_VISIBLE.get()));
        this.vBox.getChildren().add(P2GuiTools.getVDistance(10));
    }

    private void initFilmMenu() {
        MenuButton mb = new MenuButton("");
        mb.setTooltip(new Tooltip("Filmmen\u00fc anzeigen"));
        mb.setGraphic(ProgIcons.ICON_TOOLBAR_MENU.getImageView());
        mb.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-0"});
        MenuItem mbPlay = new MenuItem("Film abspielen");
        mbPlay.setOnAction(a -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.FILM) {
                return;
            }
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().filmGuiController.getSel(true, true);
            filmSelection.ifPresent(FilmPlayFactory::playFilm);
        });
        P2ShortcutWorker.addShortCut(mbPlay, PShortcut.SHORTCUT_PLAY_FILM);
        MenuItem mbPlayAll = new MenuItem("Alle markierten Film abspielen");
        mbPlayAll.setOnAction(a -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.FILM) {
                return;
            }
            FilmPlayFactory.playFilmList(ProgData.getInstance().filmGuiController.getSelList(true));
        });
        P2ShortcutWorker.addShortCut(mbPlayAll, PShortcut.SHORTCUT_PLAY_FILM_ALL);
        MenuItem mbSave = new MenuItem("Film speichern");
        mbSave.setOnAction(e -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.FILM) {
                return;
            }
            FilmSaveFactory.saveFilmList();
        });
        P2ShortcutWorker.addShortCut(mbSave, PShortcut.SHORTCUT_SAVE_FILM);
        mb.getItems().addAll((MenuItem[])new MenuItem[]{mbPlay, mbPlayAll, mbSave});
        MenuItem miFilmShown = new MenuItem("Filme als gesehen markieren");
        miFilmShown.setOnAction(a -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.FILM) {
                return;
            }
            this.progData.filmGuiController.setFilmShown(true);
        });
        P2ShortcutWorker.addShortCut(miFilmShown, PShortcut.SHORTCUT_FILM_SHOWN);
        MenuItem miFilmNotShown = new MenuItem("Filme als ungesehen markieren");
        miFilmNotShown.setOnAction(a -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.FILM) {
                return;
            }
            this.progData.filmGuiController.setFilmShown(false);
        });
        P2ShortcutWorker.addShortCut(miFilmNotShown, PShortcut.SHORTCUT_FILM_NOT_SHOWN);
        MenuItem miFilmInfo = new MenuItem("Filminformation anzeigen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_INFO_FILM.getActShortcut());
        miFilmInfo.setOnAction(a -> this.progData.filmGuiController.showFilmInfo());
        MenuItem miFilmMediaCollection = new MenuItem("Film in der Mediensammlung suchen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SEARCH_FILM_IN_MEDIACOLLECTION.getActShortcut());
        miFilmMediaCollection.setOnAction(a -> this.progData.filmGuiController.searchFilmInMediaCollection());
        MenuItem miCopyTheme = new MenuItem("Thema in die Zwischenablage kopieren" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_COPY_FILM_THEME_TO_CLIPBOARD.getActShortcut());
        miCopyTheme.setOnAction(a -> this.progData.filmGuiController.copyFilmThemeTitle(true));
        MenuItem miCopyTitle = new MenuItem("Titel in die Zwischenablage kopieren" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_COPY_FILM_TITLE_TO_CLIPBOARD.getActShortcut());
        miCopyTitle.setOnAction(a -> this.progData.filmGuiController.copyFilmThemeTitle(false));
        Menu submenuBlacklist = new Menu("Blacklist");
        MenuItem miBlack = new MenuItem("Blacklist-Eintrag f\u00fcr den Film erstellen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_ADD_BLACKLIST.getActShortcut());
        miBlack.setOnAction(event -> BlacklistFactory.addBlackFilm(true));
        MenuItem miBlackTheme = new MenuItem("Thema direkt in die Blacklist einf\u00fcgen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_ADD_BLACKLIST_THEME.getActShortcut());
        miBlackTheme.setOnAction(event -> BlacklistFactory.addBlackThemeFilm());
        submenuBlacklist.getItems().addAll((MenuItem[])new MenuItem[]{miBlack, miBlackTheme});
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miFilmShown, miFilmNotShown, miFilmInfo, miFilmMediaCollection, miCopyTheme, miCopyTitle, submenuBlacklist});
        Menu submenuBookmark = new Menu("Bookmarks");
        MenuItem miBookmarkAdd = new MenuItem("Neue Bookmarks anlegen");
        miBookmarkAdd.setOnAction(a -> this.progData.filmGuiController.bookmarkFilm(true));
        MenuItem miBookmarkDel = new MenuItem("Bookmarks l\u00f6schen");
        miBookmarkDel.setOnAction(a -> this.progData.filmGuiController.bookmarkFilm(false));
        MenuItem miBookmarkDelAll = new MenuItem("Alle angelegten Bookmarks l\u00f6schen");
        miBookmarkDelAll.setOnAction(a -> this.progData.historyListBookmarks.clearAll(this.progData.primaryStage));
        submenuBookmark.getItems().addAll((MenuItem[])new MenuItem[]{miBookmarkAdd, miBookmarkDel, miBookmarkDelAll});
        mb.getItems().add(submenuBookmark);
        MenuItem miShowFilter = new MenuItem("Filter ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_FILTER.getActShortcut());
        miShowFilter.disableProperty().bind(ProgConfig.FILM__FILTER_IS_RIP);
        miShowFilter.setOnAction(a -> MTPlayerFactory.setFilter());
        MenuItem miShowInfo = new MenuItem("Infos ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_INFOS.getActShortcut());
        miShowInfo.disableProperty().bind(ProgConfig.FILM__INFO_PANE_IS_RIP.and(ProgConfig.FILM__BUTTON_PANE_IS_RIP).and(ProgConfig.FILM__MEDIA_PANE_IS_RIP));
        miShowInfo.setOnAction(a -> MTPlayerFactory.setInfos());
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miShowFilter, miShowInfo});
        this.vBox.getChildren().add(mb);
    }
}

