/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.MTPlayerFactory;
import de.p2tools.mtplayer.controller.config.PShortKeyFactory;
import de.p2tools.mtplayer.controller.config.PShortcut;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.abo.AboSearchDownloadsFactory;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadFactory;
import de.p2tools.mtplayer.gui.ToolBarButton;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.shortcut.P2ShortcutWorker;
import javafx.beans.binding.Bindings;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;

public class DownloadMenu {
    private final VBox vBox;
    private final ProgData progData;

    public DownloadMenu(VBox vBox) {
        this.vBox = vBox;
        this.progData = ProgData.getInstance();
    }

    public void init() {
        this.vBox.getChildren().clear();
        this.initMenu();
        this.initButton();
    }

    private void initButton() {
        this.vBox.getChildren().add(P2GuiTools.getVDistance(10));
        ToolBarButton btnRefresh = new ToolBarButton(this.vBox, "Downloads aktualisieren", "Liste der Downloads aktualisieren", ProgIcons.ICON_TOOLBAR_DOWNLOAD_REFRESH.getImageView());
        this.vBox.getChildren().add(P2GuiTools.getVDistance(10));
        ToolBarButton btnStart = new ToolBarButton(this.vBox, "Downloads Starten", "Markierte Downloads starten", ProgIcons.ICON_TOOLBAR_DOWNLOAD_START.getImageView());
        ToolBarButton btnStartAll = new ToolBarButton(this.vBox, "Alle Downloads starten", "Alle Downloads starten", ProgIcons.ICON_TOOLBAR_DOWNLOAD_START_ALL.getImageView());
        ToolBarButton btStartAllTime = new ToolBarButton(this.vBox, "Alle Downloads mit Startzeit starten", "Alle Downloads mit Startzeit starten", ProgIcons.ICON_TOOLBAR_DOWNLOAD_START_ALL_TIME.getImageView());
        this.vBox.getChildren().add(P2GuiTools.getVDistance(10));
        ToolBarButton btnBack = new ToolBarButton(this.vBox, "Downloads zur\u00fcckstellen", "Markierte Downloads zur\u00fcckstellen", ProgIcons.ICON_TOOLBAR_DOWNLOAD_UNDO.getImageView());
        ToolBarButton btnDel = new ToolBarButton(this.vBox, "Downloads l\u00f6schen", "Markierte Downloads l\u00f6schen", ProgIcons.ICON_TOOLBAR_DOWNLOAD_DEL.getImageView());
        ToolBarButton btnChange = new ToolBarButton(this.vBox, "Downloads \u00e4ndern", "Markierte Downloads \u00e4ndern", ProgIcons.ICON_TOOLBAR_CONFIG.getImageView());
        ToolBarButton btnClear = new ToolBarButton(this.vBox, "Downloads aufr\u00e4umen", "Liste der Downloads aufr\u00e4umen", ProgIcons.ICON_TOOLBAR_DOWNLOAD_CLEAN.getImageView());
        this.vBox.getChildren().add(P2GuiTools.getVDistance(10));
        ToolBarButton btnDownloadFilm = new ToolBarButton(this.vBox, "Film Starten", "Gespeicherten Film abspielen", ProgIcons.ICON_TOOLBAR_START.getImageView());
        btnRefresh.setOnAction(a -> {
            AboSearchDownloadsFactory.searchForDownloadsFromAbosAndMaybeStart();
            this.progData.downloadGuiController.tableView.refresh();
            this.progData.downloadGuiController.tableView.requestFocus();
        });
        btnClear.setOnAction(a -> {
            DownloadFactory.cleanUpList(this.progData.downloadList);
            this.progData.downloadGuiController.tableView.refresh();
            this.progData.downloadGuiController.tableView.requestFocus();
        });
        btnChange.setOnAction(a -> {
            this.progData.downloadGuiController.changeDownload();
            this.progData.downloadGuiController.tableView.refresh();
            this.progData.downloadGuiController.tableView.requestFocus();
        });
        btnStart.setOnAction(a -> {
            this.progData.downloadGuiController.startDownload(false);
            this.progData.downloadGuiController.tableView.refresh();
            this.progData.downloadGuiController.tableView.requestFocus();
        });
        btnStartAll.setOnAction(a -> {
            this.progData.downloadGuiController.startDownload(true);
            this.progData.downloadGuiController.tableView.refresh();
            this.progData.downloadGuiController.tableView.requestFocus();
        });
        btStartAllTime.setOnAction(a -> {
            this.progData.downloadGuiController.startDownloadTime();
            this.progData.downloadGuiController.tableView.refresh();
            this.progData.downloadGuiController.tableView.requestFocus();
        });
        btnBack.setOnAction(a -> {
            this.progData.downloadGuiController.moveDownloadBack();
            this.progData.downloadGuiController.tableView.refresh();
            this.progData.downloadGuiController.tableView.requestFocus();
        });
        btnDel.setOnAction(a -> {
            this.progData.downloadGuiController.deleteDownloads();
            this.progData.downloadGuiController.tableView.refresh();
            this.progData.downloadGuiController.tableView.requestFocus();
        });
        btnDownloadFilm.setOnAction(a -> {
            this.progData.downloadGuiController.playFilm();
            this.progData.downloadGuiController.tableView.refresh();
            this.progData.downloadGuiController.tableView.requestFocus();
        });
    }

    private void initMenu() {
        MenuButton mb = new MenuButton("");
        mb.setTooltip(new Tooltip("Downloadmen\u00fc anzeigen"));
        mb.setGraphic(ProgIcons.ICON_TOOLBAR_MENU.getImageView());
        mb.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-0"});
        MenuItem miDownloadStart = new MenuItem("Downloads starten");
        miDownloadStart.setOnAction(a -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.DOWNLOAD) {
                return;
            }
            this.progData.downloadGuiController.startDownload(false);
        });
        P2ShortcutWorker.addShortCut(miDownloadStart, PShortcut.SHORTCUT_DOWNLOAD_START);
        MenuItem miDownloadStop = new MenuItem("Downloads stoppen");
        miDownloadStop.setOnAction(a -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.DOWNLOAD) {
                return;
            }
            this.progData.downloadGuiController.stopDownload(false);
        });
        P2ShortcutWorker.addShortCut(miDownloadStop, PShortcut.SHORTCUT_DOWNLOAD_STOP);
        MenuItem miChange = new MenuItem("Download \u00e4ndern");
        miChange.setOnAction(a -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.DOWNLOAD) {
                return;
            }
            this.progData.downloadGuiController.changeDownload();
        });
        P2ShortcutWorker.addShortCut(miChange, PShortcut.SHORTCUT_DOWNLOAD_CHANGE);
        MenuItem miUndo = new MenuItem("Gel\u00f6schte wieder anlegen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_UNDO_DELETE.getActShortcut());
        miUndo.setOnAction(a -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.DOWNLOAD) {
                return;
            }
            this.progData.downloadList.undoDownloads();
        });
        miUndo.disableProperty().bind(Bindings.isEmpty(this.progData.downloadList.getUndoList()));
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miDownloadStart, miDownloadStop, miChange, miUndo});
        MenuItem miPrefer = new MenuItem("Downloads vorziehen");
        miPrefer.setOnAction(a -> this.progData.downloadGuiController.preferDownload());
        MenuItem miPutBack = new MenuItem("Downloads zur\u00fcckstellen");
        miPutBack.setOnAction(a -> this.progData.downloadGuiController.moveDownloadBack());
        MenuItem miRemove = new MenuItem("Downloads aus Liste entfernen");
        miRemove.setOnAction(a -> this.progData.downloadGuiController.deleteDownloads());
        Menu submenuDownload = new Menu("Downloads");
        submenuDownload.getItems().addAll((MenuItem[])new MenuItem[]{miPrefer, miPutBack, miRemove});
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{submenuDownload});
        MenuItem mbStartAll = new MenuItem("Alle Downloads starten");
        mbStartAll.setOnAction(a -> this.progData.downloadGuiController.startDownload(true));
        MenuItem mbStartTimeAll = new MenuItem("Alle Downloads mit Startzeit starten");
        mbStartTimeAll.setOnAction(a -> this.progData.downloadGuiController.startDownloadTime());
        MenuItem mbStopAll = new MenuItem("Alle Downloads stoppen");
        mbStopAll.setOnAction(a -> this.progData.downloadGuiController.stopDownload(true));
        MenuItem mbStopWait = new MenuItem("Alle wartenden Downloads stoppen");
        mbStopWait.setOnAction(a -> this.progData.downloadGuiController.stopWaitingDownloads());
        MenuItem mbUpdateList = new MenuItem("Liste der Downloads aktualisieren");
        mbUpdateList.setOnAction(e -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.DOWNLOAD) {
                return;
            }
            AboSearchDownloadsFactory.searchForDownloadsFromAbosAndMaybeStart();
        });
        P2ShortcutWorker.addShortCut(mbUpdateList, PShortcut.SHORTCUT_DOWNLOADS_UPDATE);
        MenuItem mbClean = new MenuItem("Liste der Downloads aufr\u00e4umen");
        mbClean.setOnAction(e -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.DOWNLOAD) {
                return;
            }
            DownloadFactory.cleanUpList(this.progData.downloadList);
        });
        P2ShortcutWorker.addShortCut(mbClean, PShortcut.SHORTCUT_DOWNLOADS_CLEAN_UP);
        Menu submenuAllDownloads = new Menu("Alle Downloads");
        submenuAllDownloads.getItems().addAll((MenuItem[])new MenuItem[]{mbStartAll, mbStartTimeAll, mbStopAll, mbStopWait, mbUpdateList, mbClean});
        mb.getItems().addAll((MenuItem[])new MenuItem[]{submenuAllDownloads});
        MenuItem miFilmInfo = new MenuItem("Filminformation anzeigen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_INFO_FILM.getActShortcut());
        miFilmInfo.setOnAction(a -> this.progData.downloadGuiController.showFilmInfo());
        MenuItem miCopyTheme = new MenuItem("Thema in die Zwischenablage kopieren" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_COPY_FILM_THEME_TO_CLIPBOARD.getActShortcut());
        miCopyTheme.setOnAction(a -> MTPlayerFactory.copyTheme());
        MenuItem miCopyTitle = new MenuItem("Titel in die Zwischenablage kopieren" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_COPY_FILM_TITLE_TO_CLIPBOARD.getActShortcut());
        miCopyTitle.setOnAction(a -> MTPlayerFactory.copyTitle());
        Menu submenuBlacklist = new Menu("Blacklist");
        MenuItem miBlack = new MenuItem("Blacklist-Eintrag f\u00fcr den Film erstellen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_ADD_BLACKLIST.getActShortcut());
        miBlack.setOnAction(event -> BlacklistFactory.addBlackFilm(false));
        MenuItem miBlackTheme = new MenuItem("Thema direkt in die Blacklist einf\u00fcgen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_ADD_BLACKLIST_THEME.getActShortcut());
        miBlackTheme.setOnAction(event -> BlacklistFactory.addBlackThemeDownload());
        submenuBlacklist.getItems().addAll((MenuItem[])new MenuItem[]{miBlack, miBlackTheme});
        MenuItem miPlayUrl = new MenuItem("Film (URL) abspielen");
        miPlayUrl.setOnAction(a -> this.progData.downloadGuiController.playUrl());
        MenuItem miCopyUrl = new MenuItem("Download (URL) kopieren");
        miCopyUrl.setOnAction(a -> this.progData.downloadGuiController.copyUrl());
        MenuItem miMediaDb = new MenuItem("Download in der Mediensammlung suchen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SEARCH_FILM_IN_MEDIACOLLECTION.getActShortcut());
        miMediaDb.setOnAction(a -> this.progData.downloadGuiController.searchFilmInMediaCollection());
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miFilmInfo, miCopyTheme, miCopyTitle, submenuBlacklist, miPlayUrl, miCopyUrl, miMediaDb});
        MenuItem miSelectAll = new MenuItem("Alles ausw\u00e4hlen");
        miSelectAll.setOnAction(a -> this.progData.downloadGuiController.selectAll());
        MenuItem miSelection = new MenuItem("Auswahl umkehren");
        miSelection.setOnAction(a -> this.progData.downloadGuiController.invertSelection());
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miSelectAll, miSelection});
        MenuItem miShowFilter = new MenuItem("Filter ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_FILTER.getActShortcut());
        miShowFilter.disableProperty().bind(ProgConfig.DOWNLOAD__FILTER_IS_RIP);
        miShowFilter.setOnAction(a -> MTPlayerFactory.setFilter());
        MenuItem miShowInfo = new MenuItem("Infos ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_INFOS.getActShortcut());
        miShowInfo.disableProperty().bind(ProgConfig.DOWNLOAD__INFO_PANE_IS_RIP.and(ProgConfig.DOWNLOAD__CHART_PANE_IS_RIP).and(ProgConfig.DOWNLOAD__ERROR_PANE_IS_RIP).and(ProgConfig.DOWNLOAD__MEDIA_PANE__IS_RIP).and(ProgConfig.DOWNLOAD__LIST_PANE_IS_RIP));
        miShowInfo.setOnAction(a -> MTPlayerFactory.setInfos());
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miShowFilter, miShowInfo});
        this.vBox.getChildren().add(mb);
    }
}

