/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryDelDownloadFiles;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.film.FilmToolsFactory;
import de.p2tools.mtplayer.gui.DownloadTableContextMenu;
import de.p2tools.mtplayer.gui.dialog.FilmInfoDialogController;
import de.p2tools.mtplayer.gui.dialog.downloadadd.DownloadAddDialogController;
import de.p2tools.mtplayer.gui.dialog.downloaddialog.DownloadStartAtTimeController;
import de.p2tools.mtplayer.gui.infoPane.InfoPaneFactory;
import de.p2tools.mtplayer.gui.infoPane.PaneBandwidthChart;
import de.p2tools.mtplayer.gui.infoPane.PaneDownloadError;
import de.p2tools.mtplayer.gui.infoPane.PaneDownloadInfoList;
import de.p2tools.mtplayer.gui.infoPane.PaneFilmInfo;
import de.p2tools.mtplayer.gui.infoPane.PaneMedia;
import de.p2tools.mtplayer.gui.mediaSearch.MediaDataDto;
import de.p2tools.mtplayer.gui.mediadialog.MediaDialogController;
import de.p2tools.mtplayer.gui.tools.table.Table;
import de.p2tools.mtplayer.gui.tools.table.TableDownload;
import de.p2tools.mtplayer.gui.tools.table.TableRowDownload;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Open;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDto;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneFactory;
import de.p2tools.p2lib.mtfilter.Filter;
import de.p2tools.p2lib.mtfilter.FilterCheck;
import de.p2tools.p2lib.p2event.P2Events;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.P2ToolsFactory;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;

public class DownloadGuiController
extends AnchorPane {
    private final SplitPane splitPane = new SplitPane();
    private final ScrollPane scrollPane = new ScrollPane();
    public final TableDownload tableView;
    private final ProgData progData;
    private final FilteredList<DownloadData> filteredListDownloads;
    private final SortedList<DownloadData> sortedListDownloads;
    private final PaneFilmInfo paneFilmInfo;
    private final PaneMedia paneMedia;
    private final PaneBandwidthChart paneBandwidthChart;
    private final PaneDownloadError paneDownloadError;
    private final PaneDownloadInfoList paneDownloadInfoList;
    private final P2ClosePaneController infoController;
    private final BooleanProperty boundInfo = new SimpleBooleanProperty(false);

    public DownloadGuiController() {
        this.progData = ProgData.getInstance();
        this.tableView = new TableDownload(Table.TABLE_ENUM.DOWNLOAD);
        AnchorPane.setLeftAnchor(this.splitPane, 0.0);
        AnchorPane.setBottomAnchor(this.splitPane, 0.0);
        AnchorPane.setRightAnchor(this.splitPane, 0.0);
        AnchorPane.setTopAnchor(this.splitPane, 0.0);
        this.splitPane.setOrientation(Orientation.VERTICAL);
        this.getChildren().addAll((Node[])new Node[]{this.splitPane});
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setContent(this.tableView);
        this.paneFilmInfo = new PaneFilmInfo(ProgConfig.DOWNLOAD_PANE_INFO_DIVIDER);
        MediaDataDto mDtoMedia = new MediaDataDto();
        MediaDataDto mDtoAbo = new MediaDataDto();
        this.initDto(mDtoMedia, mDtoAbo);
        this.paneMedia = new PaneMedia(mDtoMedia, mDtoAbo);
        this.paneBandwidthChart = new PaneBandwidthChart(this.progData);
        this.paneDownloadError = new PaneDownloadError();
        this.paneDownloadInfoList = new PaneDownloadInfoList();
        ArrayList<P2ClosePaneDto> list = new ArrayList<P2ClosePaneDto>();
        P2ClosePaneDto infoDto = new P2ClosePaneDto(this.paneFilmInfo, ProgConfig.DOWNLOAD__INFO_PANE_IS_RIP, ProgConfig.DOWNLOAD__INFO_DIALOG_SIZE, ProgData.DOWNLOAD_TAB_ON, "Beschreibung", "Beschreibung", false, this.progData.maskerPane.getVisibleProperty());
        list.add(infoDto);
        infoDto = new P2ClosePaneDto(this.paneMedia, ProgConfig.DOWNLOAD__MEDIA_PANE__IS_RIP, ProgConfig.DOWNLOAD__MEDIA_DIALOG_SIZE, ProgData.DOWNLOAD_TAB_ON, "Mediensammlung", "Mediensammlung", false, this.progData.maskerPane.getVisibleProperty());
        list.add(infoDto);
        infoDto = new P2ClosePaneDto(this.paneBandwidthChart, ProgConfig.DOWNLOAD__CHART_PANE_IS_RIP, ProgConfig.DOWNLOAD__CHART_DIALOG_SIZE, ProgData.DOWNLOAD_TAB_ON, "Bandbreite", "Bandbreite", false, this.progData.maskerPane.getVisibleProperty());
        list.add(infoDto);
        infoDto = new P2ClosePaneDto(this.paneDownloadError, ProgConfig.DOWNLOAD__ERROR_PANE_IS_RIP, ProgConfig.DOWNLOAD__ERROR_DIALOG_SIZE, ProgData.DOWNLOAD_TAB_ON, "Fehler", "Fehler", false, this.progData.maskerPane.getVisibleProperty());
        list.add(infoDto);
        infoDto = new P2ClosePaneDto(this.paneDownloadInfoList, ProgConfig.DOWNLOAD__LIST_PANE_IS_RIP, ProgConfig.DOWNLOAD__LIST_DIALOG_SIZE, ProgData.DOWNLOAD_TAB_ON, "Infos", "Infos", false, this.progData.maskerPane.getVisibleProperty());
        list.add(infoDto);
        this.infoController = new P2ClosePaneController(list, ProgConfig.DOWNLOAD__INFO_IS_SHOWING);
        ProgConfig.DOWNLOAD__INFO_IS_SHOWING.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.DOWNLOAD__INFO_PANE_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.DOWNLOAD__MEDIA_PANE__IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.DOWNLOAD__ERROR_PANE_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.DOWNLOAD__CHART_PANE_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.DOWNLOAD__LIST_PANE_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        this.filteredListDownloads = new FilteredList<DownloadData>(this.progData.downloadList, p -> true);
        this.sortedListDownloads = new SortedList<DownloadData>((ObservableList<DownloadData>)this.filteredListDownloads);
        this.setInfoPane();
        this.initTable();
        this.initListener();
        this.setFilterProperty();
        this.setFilter();
    }

    public void tableRefresh() {
        Platform.runLater(() -> P2TableFactory.refreshTable(this.tableView));
    }

    public void isShown() {
        this.setFilmInfos((DownloadData)this.tableView.getSelectionModel().getSelectedItem());
        this.tableView.requestFocus();
    }

    public ArrayList<DownloadData> getSelList() {
        ArrayList<DownloadData> ret = new ArrayList<DownloadData>();
        ret.addAll(this.tableView.getSelectionModel().getSelectedItems());
        if (ret.isEmpty()) {
            P2Alert.showInfoNoSelection();
        }
        return ret;
    }

    public Optional<DownloadData> getSel() {
        return this.getSel(true);
    }

    public Optional<DownloadData> getSel(boolean show) {
        int selectedTableRow = this.tableView.getSelectionModel().getSelectedIndex();
        if (selectedTableRow >= 0) {
            return Optional.of((DownloadData)this.tableView.getSelectionModel().getSelectedItem());
        }
        if (show) {
            P2Alert.showInfoNoSelection();
        }
        return Optional.empty();
    }

    public int getDownloadsShown() {
        return this.tableView.getItems().size();
    }

    public int getSelCount() {
        return this.tableView.getSelectionModel().getSelectedItems().size();
    }

    public void playFilm() {
        Optional<DownloadData> download = this.getSel();
        download.ifPresent(downloadData -> P2Open.playStoredFilm(downloadData.getDestPathFile(), ProgConfig.SYSTEM_PROG_PLAY_FILME, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView()));
    }

    public void deleteFilmFile() {
        Optional<DownloadData> download = this.getSel();
        if (download.isEmpty()) {
            return;
        }
        DownloadFactoryDelDownloadFiles.deleteFilesOfDownload(download.get());
    }

    public void openDestinationDir() {
        Optional<DownloadData> download = this.getSel();
        if (download.isEmpty()) {
            return;
        }
        String s = download.get().getDestPath();
        P2Open.openDir(s, ProgConfig.SYSTEM_PROG_OPEN_DIR, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
    }

    public void playUrl() {
        Optional<DownloadData> download = this.getSel();
        if (download.isEmpty()) {
            return;
        }
        FilmPlayFactory.playUrl(download.get());
    }

    public void copyFilmThemeTitle(boolean theme) {
        Optional<DownloadData> downloadData = this.getSel(true);
        downloadData.ifPresent(data -> P2ToolsFactory.copyToClipboard(theme ? data.getTheme() : data.getTitle()));
    }

    public void copyUrl() {
        Optional<DownloadData> download = this.getSel();
        if (download.isEmpty()) {
            return;
        }
        P2ToolsFactory.copyToClipboard(download.get().getUrl());
    }

    private void setFilmInfos(DownloadData download) {
        if (InfoPaneFactory.paneIsVisible(MTPlayerController.PANE_SHOWN.DOWNLOAD, this.paneFilmInfo)) {
            this.paneFilmInfo.setFilm(download);
        }
        if (InfoPaneFactory.paneIsVisible(MTPlayerController.PANE_SHOWN.DOWNLOAD, this.paneMedia)) {
            this.paneMedia.setSearchPredicate(download);
        }
        FilmInfoDialogController.getInstance().setFilm(download != null ? download.getFilm() : null);
    }

    public void showFilmInfo() {
        FilmInfoDialogController.getInstanceAndShow().showFilmInfo();
    }

    public void searchFilmInMediaCollection() {
        Optional<DownloadData> download = this.getSel();
        download.ifPresent(downloadData -> new MediaDialogController(downloadData.getTheme(), downloadData.getTitle()));
    }

    public void startDownload(boolean all) {
        this.downloadStartAgain(all);
    }

    public void startDownloadTime() {
        new DownloadStartAtTimeController(this.progData, this.tableView.getItems(), this.tableView.getSelectionModel().getSelectedItems());
    }

    public void stopDownload(boolean all) {
        this.stopDownloads(all);
    }

    public void stopWaitingDownloads() {
        this.stopWaiting();
    }

    public void preferDownload() {
        this.progData.downloadList.preferDownloads(this.getSelList());
    }

    public void moveDownloadBack() {
        this.progData.downloadList.putBackDownloads(this.getSelList());
    }

    public void deleteDownloads() {
        int sel = this.tableView.getSelectionModel().getSelectedIndex();
        this.progData.downloadList.delDownloads(this.getSelList());
        if (sel >= 0) {
            this.tableView.getSelectionModel().clearSelection();
            if (this.tableView.getItems().size() > sel) {
                this.tableView.getSelectionModel().select(sel);
            } else {
                this.tableView.getSelectionModel().selectLast();
            }
        }
    }

    public void changeDownload() {
        this.change();
    }

    public void setFilmShown() {
        this.setFilmShown(true);
    }

    public void setFilmNotShown() {
        this.setFilmShown(false);
    }

    public void selectAll() {
        this.tableView.getSelectionModel().selectAll();
    }

    public void invertSelection() {
        P2TableFactory.invertSelection(this.tableView);
    }

    public void saveTable() {
        Table.saveTable(this.tableView, Table.TABLE_ENUM.DOWNLOAD);
    }

    private void initListener() {
        ProgData.getInstance().pEventHandler.addListener(new P2Listener(P2Events.EVENT_TIMER_SECOND){

            @Override
            public void pingGui() {
                DownloadGuiController.this.paneBandwidthChart.searchInfos(InfoPaneFactory.paneIsVisible(MTPlayerController.PANE_SHOWN.DOWNLOAD, DownloadGuiController.this.paneBandwidthChart));
                if (InfoPaneFactory.paneIsVisible(MTPlayerController.PANE_SHOWN.DOWNLOAD, DownloadGuiController.this.paneDownloadInfoList)) {
                    DownloadGuiController.this.paneDownloadInfoList.setInfoText();
                }
            }
        });
        ProgData.getInstance().pEventHandler.addListener(new P2Listener(P2Events.EVENT_TIMER_SECOND){

            @Override
            public void pingGui() {
                if (!((String)ProgConfig.FILTER_DOWNLOAD_STATE.get()).isEmpty()) {
                    DownloadGuiController.this.setFilter();
                }
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_SET_DATA_CHANGED){

            @Override
            public void pingGui() {
                DownloadGuiController.this.tableView.refresh();
            }
        });
        this.progData.downloadList.downloadsChangedProperty().addListener((observable2, oldValue, newValue) -> this.setFilter());
    }

    private void initTable() {
        Table.setTable(this.tableView);
        this.tableView.setItems(this.sortedListDownloads);
        this.sortedListDownloads.comparatorProperty().bind(this.tableView.comparatorProperty());
        this.tableView.setRowFactory(tv -> {
            TableRowDownload row = new TableRowDownload();
            row.setOnMouseClicked(event -> {
                if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2 && !row.isEmpty()) {
                    this.changeDownload();
                }
            });
            row.hoverProperty().addListener(observable2 -> {
                DownloadData downloadData = (DownloadData)row.getItem();
                if (row.isHover() && downloadData != null) {
                    this.setFilmInfos(downloadData);
                } else if (downloadData == null) {
                    this.setFilmInfos((DownloadData)this.tableView.getSelectionModel().getSelectedItem());
                }
            });
            return row;
        });
        this.tableView.hoverProperty().addListener(o -> {
            if (!this.tableView.isHover()) {
                this.setFilmInfos((DownloadData)this.tableView.getSelectionModel().getSelectedItem());
            }
        });
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> Platform.runLater(() -> this.setFilmInfos((DownloadData)this.tableView.getSelectionModel().getSelectedItem())));
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                Optional<DownloadData> optionalDownload = this.getSel(false);
                DownloadData download = optionalDownload.orElse(null);
                ContextMenu contextMenu = new DownloadTableContextMenu(this.progData, this, this.tableView).getContextMenu(download);
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (P2TableFactory.SPACE.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeDown(this.tableView);
                event.consume();
            }
            if (P2TableFactory.SPACE_SHIFT.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeUp(this.tableView);
                event.consume();
            }
        });
    }

    private void setFilterProperty() {
        ProgConfig.FILTER_DOWNLOAD_CHANNEL.addListener((observable2, oldValue, newValue) -> this.setFilter());
        ProgConfig.FILTER_DOWNLOAD_ABO.addListener((observable2, oldValue, newValue) -> this.setFilter());
        ProgConfig.FILTER_DOWNLOAD_SOURCE.addListener((observable2, oldValue, newValue) -> this.setFilter());
        ProgConfig.FILTER_DOWNLOAD_TYPE.addListener((observable2, oldValue, newValue) -> this.setFilter());
        ProgConfig.FILTER_DOWNLOAD_STATE.addListener((observable2, oldValue, newValue) -> this.setFilter());
    }

    private void setFilter() {
        Platform.runLater(() -> {
            Predicate<DownloadData> predicate = downloadData -> true;
            String sender = ProgConfig.FILTER_DOWNLOAD_CHANNEL.getValueSafe();
            String abo = ProgConfig.FILTER_DOWNLOAD_ABO.getValueSafe();
            String source2 = ProgConfig.FILTER_DOWNLOAD_SOURCE.getValueSafe();
            String type = ProgConfig.FILTER_DOWNLOAD_TYPE.getValueSafe();
            String state = ProgConfig.FILTER_DOWNLOAD_STATE.getValueSafe();
            predicate = predicate.and(download -> !download.isPlacedBack());
            if (!sender.isEmpty()) {
                Filter filter = new Filter(sender, true);
                predicate = predicate.and(blackData -> FilterCheck.check(filter, blackData.getChannel()));
            }
            if (!abo.isEmpty()) {
                predicate = predicate.and(downloadData -> downloadData.getAboName().equals(abo));
            }
            if (!source2.isEmpty()) {
                predicate = predicate.and(downloadData -> downloadData.getSource().equals(source2));
            }
            if (!type.isEmpty()) {
                predicate = predicate.and(downloadData -> downloadData.getType().equals(type));
            }
            if (!state.isEmpty()) {
                predicate = predicate.and(downloadData -> state.equals("Noch nicht gestartet") && !downloadData.isStarted() || state.equals("Gestartet, wartet noch") && downloadData.isStateStartedWaiting() || state.equals("Gestartet, l\u00e4uft oder wartet") && downloadData.isStarted() || state.equals("L\u00e4uft") && downloadData.isStateStartedRun() || state.equals("Fehlerhaft") && downloadData.isStateError());
            }
            this.filteredListDownloads.setPredicate(predicate);
        });
    }

    private void setFilmShown(boolean shown) {
        ArrayList<DownloadData> arrayDownloadData = this.getSelList();
        ArrayList<FilmDataMTP> filmArrayList = new ArrayList<FilmDataMTP>();
        arrayDownloadData.forEach(download -> {
            if (download.getFilm() != null) {
                filmArrayList.add(download.getFilm());
            }
        });
        FilmToolsFactory.setFilmShown(filmArrayList, shown);
    }

    private void stopWaiting() {
        ArrayList<DownloadData> listStopDownload = new ArrayList<DownloadData>();
        this.tableView.getItems().stream().filter(download -> download.isStateStartedWaiting()).forEach(download -> listStopDownload.add((DownloadData)download));
        this.progData.downloadList.stopDownloads(listStopDownload);
    }

    private void downloadStartAgain(boolean all) {
        ArrayList<DownloadData> startDownloadsList = new ArrayList<DownloadData>();
        startDownloadsList.addAll(all ? this.tableView.getItems() : this.getSelList());
        this.progData.downloadList.startDownloads(startDownloadsList, true);
    }

    private void stopDownloads(boolean all) {
        ArrayList<DownloadData> listDownloadsSelected = new ArrayList<DownloadData>(all ? this.tableView.getItems() : this.getSelList());
        this.progData.downloadList.stopDownloads(listDownloadsSelected);
        this.setFilter();
    }

    private synchronized void change() {
        ArrayList<DownloadData> list = this.getSelList();
        if (!list.isEmpty()) {
            new DownloadAddDialogController(this.progData, list);
        }
    }

    private void setInfoPane() {
        P2ClosePaneFactory.setSplit(this.boundInfo, this.splitPane, this.infoController, false, this.scrollPane, ProgConfig.DOWNLOAD__INFO_DIVIDER, ProgConfig.DOWNLOAD__INFO_IS_SHOWING);
    }

    private void initDto(MediaDataDto mediaDataDtoMedia, MediaDataDto mediaDataDtoAbo) {
        mediaDataDtoMedia.whatToShow = MediaDataDto.SHOW_WHAT.SHOW_MEDIA;
        mediaDataDtoMedia.buildSearchFrom = ProgConfig.INFO_DOWNLOAD_BUILD_SEARCH_FROM_FOR_MEDIA;
        mediaDataDtoMedia.searchInWhat = ProgConfig.INFO_DOWNLOAD_SEARCH_IN_WHAT_FOR_MEDIA;
        mediaDataDtoMedia.cleaning = ProgConfig.INFO_DOWNLOAD_CLEAN_MEDIA;
        mediaDataDtoMedia.cleaningExact = ProgConfig.INFO_DOWNLOAD_CLEAN_EXACT_MEDIA;
        mediaDataDtoMedia.cleaningAndOr = ProgConfig.INFO_DOWNLOAD_CLEAN_AND_OR_MEDIA;
        mediaDataDtoMedia.cleaningList = ProgConfig.INFO_DOWNLOAD_CLEAN_LIST_MEDIA;
        mediaDataDtoAbo.whatToShow = MediaDataDto.SHOW_WHAT.SHOW_ABO;
        mediaDataDtoAbo.buildSearchFrom = ProgConfig.INFO_DOWNLOAD_BUILD_SEARCH_FROM_FOR_ABO;
        mediaDataDtoAbo.searchInWhat = ProgConfig.INFO_DOWNLOAD_SEARCH_IN_WHAT_FOR_ABO;
        mediaDataDtoAbo.cleaning = ProgConfig.INFO_DOWNLOAD_CLEAN_ABO;
        mediaDataDtoAbo.cleaningExact = ProgConfig.INFO_DOWNLOAD_CLEAN_EXACT_ABO;
        mediaDataDtoAbo.cleaningAndOr = ProgConfig.INFO_DOWNLOAD_CLEAN_AND_OR_ABO;
        mediaDataDtoAbo.cleaningList = ProgConfig.INFO_DOWNLOAD_CLEAN_LIST_ABO;
    }
}

