/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.MTPlayerFactory;
import de.p2tools.mtplayer.controller.config.PShortKeyFactory;
import de.p2tools.mtplayer.controller.config.PShortcut;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.abo.AboListFactory;
import de.p2tools.mtplayer.gui.ToolBarButton;
import javafx.beans.binding.Bindings;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;

public class AboMenu {
    private final VBox vBox;
    private final ProgData progData;

    public AboMenu(VBox vBox) {
        this.vBox = vBox;
        this.progData = ProgData.getInstance();
    }

    public void init() {
        this.vBox.getChildren().clear();
        this.initMenu();
        this.initButton();
    }

    private void initButton() {
        VBox vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(0.0);
        vBoxSpace.setMinHeight(0.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btNew = new ToolBarButton(this.vBox, "Neues Abo", "Neus Abo anlegen", ProgIcons.ICON_TOOLBAR_ABO_NEW.getImageView());
        vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(10.0);
        vBoxSpace.setMinHeight(10.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btOn = new ToolBarButton(this.vBox, "Abos einschalten", "Markierte Abos einschalten", ProgIcons.ICON_TOOLBAR_ABO_ON.getImageView());
        ToolBarButton btOff = new ToolBarButton(this.vBox, "Abos ausschalten", "Markierte Abos ausschalten", ProgIcons.ICON_TOOLBAR_ABO_OFF.getImageView());
        ToolBarButton btDel = new ToolBarButton(this.vBox, "Abos l\u00f6schen", "Markierte Abos l\u00f6schen", ProgIcons.ICON_TOOLBAR_ABO_DEL.getImageView());
        ToolBarButton btChange = new ToolBarButton(this.vBox, "Abos \u00e4ndern", "Markierte Abos \u00e4ndern", ProgIcons.ICON_TOOLBAR_CONFIG.getImageView());
        btNew.setOnAction(a -> {
            AboListFactory.addNewAbo("Neu", "", "", "");
            this.progData.aboGuiController.tableView.refresh();
            this.progData.aboGuiController.tableView.requestFocus();
        });
        btOn.setOnAction(a -> {
            AboListFactory.setAboActive(true);
            this.progData.aboGuiController.tableView.refresh();
            this.progData.aboGuiController.tableView.requestFocus();
        });
        btOff.setOnAction(a -> {
            AboListFactory.setAboActive(false);
            this.progData.aboGuiController.tableView.refresh();
            this.progData.aboGuiController.tableView.requestFocus();
        });
        btDel.setOnAction(a -> {
            AboListFactory.deleteAbo();
            this.progData.aboGuiController.tableView.refresh();
            this.progData.aboGuiController.tableView.requestFocus();
        });
        btChange.setOnAction(a -> {
            AboListFactory.editAbo();
            this.progData.aboGuiController.tableView.refresh();
            this.progData.aboGuiController.tableView.requestFocus();
        });
    }

    private void initMenu() {
        MenuButton mb = new MenuButton("");
        mb.setTooltip(new Tooltip("Abomen\u00fc anzeigen"));
        mb.setGraphic(ProgIcons.ICON_TOOLBAR_MENU.getImageView());
        mb.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-0"});
        MenuItem mbOn = new MenuItem("Abos einschalten");
        mbOn.setOnAction(a -> AboListFactory.setAboActive(true));
        MenuItem mbOff = new MenuItem("Abos ausschalten");
        mbOff.setOnAction(e -> AboListFactory.setAboActive(false));
        MenuItem miDel = new MenuItem("Abos l\u00f6schen");
        miDel.setOnAction(a -> AboListFactory.deleteAbo());
        MenuItem miChange = new MenuItem("Abos \u00e4ndern");
        miChange.setOnAction(a -> AboListFactory.editAbo());
        MenuItem miNew = new MenuItem("Neues Abo anlegen");
        miNew.setOnAction(a -> AboListFactory.addNewAbo("Neu", "", "", ""));
        MenuItem miAboAddFilter = new MenuItem("Aus dem Film-Filter ein Abo erstellen");
        miAboAddFilter.setOnAction(a -> AboListFactory.addNewAboFromFilterButton());
        MenuItem miUndo = new MenuItem("Gel\u00f6schte wieder anlegen" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_UNDO_DELETE.getActShortcut());
        miUndo.setOnAction(a -> {
            if (MTPlayerController.paneShown != MTPlayerController.PANE_SHOWN.ABO) {
                return;
            }
            this.progData.aboList.undoAbos();
        });
        miUndo.disableProperty().bind(Bindings.isEmpty(this.progData.aboList.getUndoList()));
        mb.getItems().addAll((MenuItem[])new MenuItem[]{mbOn, mbOff, miDel, miChange, miNew, miAboAddFilter, miUndo});
        MenuItem miSelectAll = new MenuItem("Alles ausw\u00e4hlen");
        miSelectAll.setOnAction(a -> this.progData.aboGuiController.selectAll());
        MenuItem miSelection = new MenuItem("Auswahl umkehren");
        miSelection.setOnAction(a -> this.progData.aboGuiController.invertSelection());
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miSelectAll, miSelection});
        MenuItem miShowFilter = new MenuItem("Filter ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_FILTER.getActShortcut());
        miShowFilter.disableProperty().bind(ProgConfig.ABO__FILTER_IS_RIP);
        miShowFilter.setOnAction(a -> MTPlayerFactory.setFilter());
        MenuItem miShowInfo = new MenuItem("Infos ein-/ausblenden" + PShortKeyFactory.SHORT_CUT_LEER + PShortcut.SHORTCUT_SHOW_INFOS.getActShortcut());
        miShowInfo.disableProperty().bind(ProgConfig.ABO__INFO_PANE_IS_RIP.and(ProgConfig.ABO__LIST_PANE_IS_RIP));
        miShowInfo.setOnAction(a -> MTPlayerFactory.setInfos());
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miShowFilter, miShowInfo});
        this.vBox.getChildren().add(mb);
    }
}

