/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.worker;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.p2lib.tools.duration.P2Duration;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ThemeListFactory {
    public static final ObservableList<String> allChannelList = FXCollections.observableArrayList("");
    public static ObservableList<String> themeForChannelList = FXCollections.observableArrayList("");
    public static BooleanProperty themeForChannelChanged = new SimpleBooleanProperty(false);
    public static final ObservableList<String> channelsForAbosList = FXCollections.observableArrayList("");
    public static final ObservableList<String> allAboNamesList = FXCollections.observableArrayList("");

    private ThemeListFactory() {
    }

    public static synchronized void createThemeList(ProgData progData, String sender) {
        P2Duration.counterStart("createThemeList");
        ArrayList<String> newThemeList = new ArrayList<String>();
        if (sender.isEmpty()) {
            newThemeList.addAll(Arrays.asList(progData.filmListFiltered.themePerChannel[0]));
        } else {
            ThemeListFactory.makeTheme(progData, sender.trim(), newThemeList);
        }
        Collator collator = Collator.getInstance(Locale.GERMANY);
        collator.setStrength(0);
        collator.setDecomposition(1);
        Comparator comparator = (arg1, arg2) -> {
            if (arg1.startsWith("\"") || arg1.startsWith("#") || arg1.startsWith("\u201e")) {
                arg1 = arg1.substring(1);
            }
            if (arg2.startsWith("\"") || arg2.startsWith("#") || arg2.startsWith("\u201e")) {
                arg2 = arg2.substring(1);
            }
            return collator.compare((String)arg1, (String)arg2);
        };
        newThemeList.sort(comparator);
        progData.worker.saveFilter();
        themeForChannelList = FXCollections.observableArrayList("");
        themeForChannelList.setAll((Collection<String>)newThemeList);
        progData.worker.resetFilter();
        themeForChannelChanged.setValue(themeForChannelChanged.getValue() == false);
        P2Duration.counterStop("createThemeList");
    }

    private static void makeTheme(ProgData progData, String sender, ArrayList<String> theme) {
        if (sender.contains(",")) {
            String[] senderArr = sender.toLowerCase().split(",");
            TreeSet<String> tree = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            tree.add("");
            block0: for (int i = 1; i < progData.filmListFiltered.themePerChannel.length; ++i) {
                for (String s : senderArr) {
                    if (!progData.filmListFiltered.sender[i].equalsIgnoreCase(s.trim())) continue;
                    tree.addAll(Arrays.asList(progData.filmListFiltered.themePerChannel[i]));
                    continue block0;
                }
            }
            theme.addAll(tree);
        } else {
            for (int i = 1; i < progData.filmListFiltered.themePerChannel.length; ++i) {
                if (!progData.filmListFiltered.sender[i].equalsIgnoreCase(sender)) continue;
                theme.addAll(Arrays.asList(progData.filmListFiltered.themePerChannel[i]));
                break;
            }
        }
    }
}

