/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.update;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.dialogs.WhatsNewInfo;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import java.time.LocalDate;
import java.util.ArrayList;

public class WhatsNewList
extends ArrayList<WhatsNewInfo> {
    private LocalDate maxDate = LocalDate.MIN;

    public WhatsNewList() {
        this.addWhatsNew();
        this.forEach((? super E whatsNewInfo) -> {
            if (whatsNewInfo.getDate().isAfter(this.maxDate)) {
                this.maxDate = whatsNewInfo.getDate();
            }
        });
    }

    public LocalDate getMaxDate() {
        return this.maxDate;
    }

    public void setLastShown() {
        ProgConfig.SYSTEM_WHATS_NEW_DATE_LAST_SHOWN.setValue(P2LDateFactory.toStringR(this.maxDate));
    }

    public ArrayList<WhatsNewInfo> getOnlyNews() {
        ArrayList<WhatsNewInfo> list = new ArrayList<WhatsNewInfo>();
        LocalDate lastDate = P2LDateFactory.fromStringR(ProgConfig.SYSTEM_WHATS_NEW_DATE_LAST_SHOWN.getValueSafe());
        this.forEach((? super E whatsNewInfo) -> {
            if (lastDate.isBefore(whatsNewInfo.getDate())) {
                list.add((WhatsNewInfo)whatsNewInfo);
            }
        });
        return list;
    }

    private void addWhatsNew() {
        WhatsNewInfo whatsNewInfo = new WhatsNewInfo(LocalDate.of(2025, 4, 7), "", "Live-Suche ZDF", "Die Live-Suche f\u00fcr das ZDF wurde an die ge\u00e4nderte Mediathek angepasst.", 50);
        this.add(whatsNewInfo);
    }
}

