/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.update;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.update.SearchProgramUpdate;
import de.p2tools.mtplayer.controller.update.WhatsNewList;
import de.p2tools.p2lib.dialogs.WhatsNewDialog;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import javafx.application.Platform;

public class WhatsNewFactory {
    private WhatsNewFactory() {
    }

    public static void checkUpdate() {
        P2Log.sysLog("Programmstart, alte Programm-Release-Nr: " + ProgConfig.SYSTEM_PROG_BUILD_NO.getValueSafe());
        P2Log.sysLog("Programmstart, aktuelle Programm-Release-Nr: " + P2InfoFactory.getBuildNo());
        if (!ProgConfig.SYSTEM_PROG_BUILD_NO.getValueSafe().equals(P2InfoFactory.getBuildNo())) {
            WhatsNewFactory.showWhatsNew(false);
        } else {
            WhatsNewFactory.checkProgUpdate();
        }
    }

    public static void setLastShown() {
        ProgConfig.SYSTEM_WHATS_NEW_DATE_LAST_SHOWN.setValue(P2LDateFactory.getNowStringR());
    }

    public static void showWhatsNew(boolean showAlways) {
        WhatsNewList whatsNewList = new WhatsNewList();
        try {
            ArrayList list;
            ArrayList arrayList = list = showAlways ? whatsNewList : whatsNewList.getOnlyNews();
            if (!list.isEmpty()) {
                Platform.runLater(() -> new WhatsNewDialog(ProgData.getInstance().primaryStage, "MTPlayer", "https://www.p2tools.de/mtplayer/", ProgConfig.SYSTEM_PROG_OPEN_URL, (boolean)ProgConfig.SYSTEM_DARK_THEME.getValue(), list).make());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        whatsNewList.setLastShown();
    }

    private static void checkProgUpdate() {
        P2Duration.onlyPing("checkProgUpdate");
        if (ProgConfig.SYSTEM_SEARCH_UPDATE.getValue().booleanValue() && !WhatsNewFactory.isUpdateCheckTodayDone()) {
            WhatsNewFactory.runUpdateCheck();
        } else {
            ArrayList<String> list = new ArrayList<String>(5);
            list.add("Kein Update-Check:");
            if (!ProgConfig.SYSTEM_SEARCH_UPDATE.getValue().booleanValue()) {
                list.add("  der User will nicht");
            }
            if (WhatsNewFactory.isUpdateCheckTodayDone()) {
                list.add("  heute schon gemacht");
            }
            P2Log.sysLog(list);
        }
    }

    private static boolean isUpdateCheckTodayDone() {
        return ((String)ProgConfig.SYSTEM_SEARCH_UPDATE_TODAY_DONE.get()).equals(P2LDateFactory.getNowStringR());
    }

    private static void runUpdateCheck() {
        ProgConfig.SYSTEM_SEARCH_UPDATE_TODAY_DONE.setValue(P2LDateFactory.getNowStringR());
        new SearchProgramUpdate(ProgData.getInstance()).searchNewProgramVersion(false);
    }
}

